/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.rpkiobjects;

import au.com.bytecode.opencsv.CSVWriter;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Writer;
import java.security.cert.X509CRLEntry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletResponse;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.ValidityPeriod;
import net.ripe.rpki.commons.crypto.cms.ghostbuster.GhostbustersCms;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.cms.roa.RoaCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.util.CertificateRepositoryObjectFactory;
import net.ripe.rpki.commons.crypto.x509cert.X509CertificateInformationAccessDescriptor;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.crypto.x509cert.X509RouterCertificate;
import net.ripe.rpki.commons.validation.ValidationCheck;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.rpkiobjects.RpkiObjectController;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationCheck;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Hex;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(path={"/api/rpki-objects"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class RpkiObjectController {
    private static final Logger log = LoggerFactory.getLogger(RpkiObjectController.class);
    @Autowired
    private RpkiObjects rpkiObjects;
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private ValidationRuns validationRuns;
    @Autowired
    private Storage storage;

    @GetMapping(path={"/"})
    public ResponseEntity<ApiResponse<Stream<RpkiObj>>> all() {
        List objects = ((List)this.storage.readTx(tx -> this.trustAnchors.findAll(tx))).parallelStream().flatMap(arg_0 -> this.getRpkiObjsPerTa(arg_0)).collect(Collectors.toList());
        return ResponseEntity.ok((Object)ApiResponse.data(objects.stream()));
    }

    private Stream<RpkiObj> getRpkiObjsPerTa(TrustAnchor trustAnchor) {
        return ((Stream)((List)this.storage.readTx(tx -> this.validationRuns.findLatestSuccessfulCaTreeValidationRun(tx, trustAnchor).map(vr -> this.getAssociatedRpkiObjects(tx, vr, this.getCheckMap(vr))).orElse(Stream.empty()).collect(Collectors.toList()))).stream().sorted(Comparator.comparing(o -> RpkiObjectController.location((RpkiObject.Type)((RpkiObject)o.getLeft()).getType(), (SortedSet)((SortedSet)o.getMiddle())))).parallel()).map(triple -> {
            RpkiObject rpkiObject = (RpkiObject)triple.getLeft();
            SortedSet locations = (SortedSet)triple.getMiddle();
            Optional vc = (Optional)triple.getRight();
            return this.mapRpkiObject(rpkiObject, vc.map(c -> ValidationResult.withLocation((String)c.getLocation())).orElse(ValidationResult.withLocation((String)RpkiObjectController.location((RpkiObject.Type)rpkiObject.getType(), (SortedSet)locations))));
        }).filter(Objects::nonNull);
    }

    private Stream<Triple<RpkiObject, SortedSet<String>, Optional<net.ripe.rpki.validator3.storage.data.validation.ValidationCheck>>> getAssociatedRpkiObjects(Tx.Read tx, CertificateTreeValidationRun vr, Map<String, net.ripe.rpki.validator3.storage.data.validation.ValidationCheck> checkMap) {
        return this.validationRuns.findAssociatedPks(tx, vr).stream().map(k -> this.rpkiObjects.get(tx, k)).filter(Optional::isPresent).map(Optional::get).map(ro -> {
            SortedSet locations = this.rpkiObjects.getLocations(tx, ro.key());
            Optional<net.ripe.rpki.validator3.storage.data.validation.ValidationCheck> check = locations.stream().map(checkMap::get).filter(Objects::nonNull).findFirst();
            return Triple.of((Object)ro, (Object)locations, check);
        });
    }

    private Map<String, net.ripe.rpki.validator3.storage.data.validation.ValidationCheck> getCheckMap(CertificateTreeValidationRun vr) {
        return vr.getValidationChecks().stream().collect(Collectors.toMap(net.ripe.rpki.validator3.storage.data.validation.ValidationCheck::getLocation, Function.identity(), (a, b) -> {
            if (a.getStatus() == ValidationCheck.Status.ERROR) {
                return a;
            }
            if (b.getStatus() == ValidationCheck.Status.ERROR) {
                return b;
            }
            return a;
        }));
    }

    private static Stream<CertificateRepositoryObject> objectStream(Stream<byte[]> byteStream, String fileExtension) {
        return byteStream.collect(Collectors.toList()).parallelStream().map(bytes -> {
            ValidationResult vr = ValidationResult.withLocation((String)("whatever." + fileExtension));
            return CertificateRepositoryObjectFactory.createCertificateRepositoryObject((byte[])bytes, (ValidationResult)vr);
        });
    }

    @GetMapping(path={"/certified.csv"}, produces={"text/csv; charset=UTF-8"})
    @ApiIgnore
    public void certified(HttpServletResponse response) throws IOException {
        IpResourceSet all = IpResourceSet.parse((String)"0/0, ::/0");
        IpResourceSet ipResources = new IpResourceSet();
        Pair txResult = (Pair)this.storage.readTx(tx -> {
            Set roaAKIs = RpkiObjectController.objectStream((Stream)this.rpkiObjects.streamObjects(tx, RpkiObject.Type.ROA), (String)"roa").filter(p -> p instanceof RoaCms).map(p -> Hex.format((byte[])((RoaCms)p).getCertificate().getAuthorityKeyIdentifier())).collect(Collectors.toSet());
            List allCerts = RpkiObjectController.objectStream((Stream)this.rpkiObjects.streamObjects(tx, RpkiObject.Type.CER), (String)"cer").filter(p -> p instanceof X509ResourceCertificate).map(p -> (X509ResourceCertificate)p).collect(Collectors.toList());
            return Pair.of(roaAKIs, allCerts);
        });
        Set roaAKIs = (Set)txResult.getLeft();
        List allCerts = (List)txResult.getRight();
        List roaParents = allCerts.stream().filter(c -> !c.isRoot() && roaAKIs.contains(Hex.format((byte[])c.getSubjectKeyIdentifier()))).collect(Collectors.toList());
        Map<String, Set> byAki = allCerts.stream().collect(Collectors.toMap(c -> Hex.format((byte[])c.getAuthorityKeyIdentifier()), RpkiObjectController::oneElem, (c1, c2) -> {
            c1.addAll(c2);
            return c1;
        }));
        Map bySki = allCerts.stream().collect(Collectors.toMap(c -> Hex.format((byte[])c.getSubjectKeyIdentifier()), Function.identity(), (c1, c2) -> c1.getSerialNumber().compareTo(c2.getSerialNumber()) > 0 ? c1 : c2));
        roaParents.parallelStream().map(c -> {
            String aki = Hex.format((byte[])c.getAuthorityKeyIdentifier());
            return (X509ResourceCertificate)bySki.get(aki);
        }).filter(Objects::nonNull).distinct().flatMap(c -> {
            String ski = Hex.format((byte[])c.getSubjectKeyIdentifier());
            return byAki.getOrDefault(ski, Collections.emptySet()).stream();
        }).forEachOrdered(c -> {
            IpResourceSet resources = c.getResources();
            if (!resources.contains(all)) {
                for (IpResource r : resources) {
                    if (r.getType() == IpResourceType.ASN) continue;
                    ipResources.add(r);
                }
            }
        });
        response.setContentType("text/csv; charset=UTF-8");
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            writer.writeNext(new String[]{"Resource"});
            for (IpResource r : ipResources) {
                writer.writeNext(new String[]{r.toString()});
            }
        }
    }

    @GetMapping(path={"/certificates.csv"}, produces={"text/csv; charset=UTF-8"})
    @ApiIgnore
    public void certificates(HttpServletResponse response) throws IOException {
        response.setContentType("text/csv; charset=UTF-8");
        try (CSVWriter writer = new CSVWriter((Writer)response.getWriter());){
            writer.writeNext(new String[]{"Subject", "Resources"});
            Stream byteStream = (Stream)this.storage.readTx(tx -> this.rpkiObjects.streamObjects(tx, RpkiObject.Type.CER));
            RpkiObjectController.objectStream((Stream)byteStream, (String)"cer").forEachOrdered(c -> {
                if (c instanceof X509ResourceCertificate) {
                    X509ResourceCertificate cert = (X509ResourceCertificate)c;
                    writer.writeNext(new String[]{cert.getSubject().toString(), cert.getResources().toString()});
                }
            });
        }
    }

    private static <T> Set<T> oneElem(T c) {
        HashSet<T> a = new HashSet<T>();
        a.add(c);
        return a;
    }

    private RpkiObj mapRpkiObject(RpkiObject rpkiObject, ValidationResult validationResult) {
        switch (1.$SwitchMap$net$ripe$rpki$validator3$storage$data$RpkiObject$Type[rpkiObject.getType().ordinal()]) {
            case 1: {
                return this.makeTypedDto(rpkiObject, validationResult, X509ResourceCertificate.class, cert -> this.makeCertificate(validationResult, cert, rpkiObject));
            }
            case 2: {
                return this.makeTypedDto(rpkiObject, validationResult, X509RouterCertificate.class, cert -> this.makeCertificate(validationResult, cert, rpkiObject));
            }
            case 3: {
                return this.makeTypedDto(rpkiObject, validationResult, RoaCms.class, cert -> this.makeRoa(validationResult, cert, rpkiObject));
            }
            case 4: {
                return this.makeTypedDto(rpkiObject, validationResult, ManifestCms.class, cert -> this.makeMft(validationResult, cert, rpkiObject));
            }
            case 5: {
                return this.makeTypedDto(rpkiObject, validationResult, X509Crl.class, cert -> this.makeCrl(validationResult, cert, rpkiObject));
            }
            case 6: {
                return this.makeTypedDto(rpkiObject, validationResult, GhostbustersCms.class, gbr -> this.makeGbr(validationResult, gbr, rpkiObject));
            }
            case 7: {
                return this.makeOther(validationResult, rpkiObject);
            }
        }
        throw new IllegalArgumentException("RPKI object with unknown type " + rpkiObject);
    }

    private <T extends CertificateRepositoryObject> RpkiObj makeTypedDto(RpkiObject rpkiObject, ValidationResult validationResult, Class<T> clazz, Function<T, RpkiObj> create) {
        return rpkiObject.get(clazz, validationResult).map(create).orElse(null);
    }

    private static String location(RpkiObject.Type objectType, SortedSet<String> locations) {
        if (locations.isEmpty()) {
            return "unknown." + objectType.toString().toLowerCase(Locale.ROOT);
        }
        return locations.first();
    }

    private ResourceCertificate makeCertificate(ValidationResult validationResult, X509ResourceCertificate certificate, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        return ResourceCertificate.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).resources(RpkiObjectController.formatResources((IpResourceSet)certificate.getResources())).subjectName(certificate.getSubject().getName()).ski(Hex.format((byte[])certificate.getSubjectKeyIdentifier())).aki(Hex.format((byte[])certificate.getAuthorityKeyIdentifier())).validityTime(RpkiObjectController.formatValidity((ValidityPeriod)certificate.getValidityPeriod())).sia(RpkiObjectController.formatSia((X509CertificateInformationAccessDescriptor[])certificate.getSubjectInformationAccess())).serial(certificate.getSerialNumber()).sha256(Hex.format((byte[])rpkiObject.getSha256())).build();
    }

    private RouterCertificate makeCertificate(ValidationResult validationResult, X509RouterCertificate certificate, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        return RouterCertificate.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).subjectName(certificate.getSubject().getName()).ski(Hex.format((byte[])certificate.getSubjectKeyIdentifier())).aki(Hex.format((byte[])certificate.getAuthorityKeyIdentifier())).validityTime(RpkiObjectController.formatValidity((ValidityPeriod)certificate.getValidityPeriod())).sia(RpkiObjectController.formatSia((X509CertificateInformationAccessDescriptor[])certificate.getSubjectInformationAccess())).serial(certificate.getSerialNumber()).sha256(Hex.format((byte[])rpkiObject.getSha256())).build();
    }

    private boolean isValid(ValidationResult validationResult) {
        return !validationResult.hasFailureForCurrentLocation();
    }

    private Roa makeRoa(ValidationResult validationResult, RoaCms roaCms, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        List pref = roaCms.getPrefixes();
        List prefixes = pref == null ? Collections.emptyList() : pref.stream().map(p -> RoaPrefix.builder().prefix(p.getPrefix().toString()).maxLenght(p.getMaximumLength()).build()).collect(Collectors.toList());
        return Roa.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).asn(roaCms.getAsn().toString()).roaPrefixes(prefixes).sha256(Hex.format((byte[])rpkiObject.getSha256())).eeCertificate(this.makeEeCertificate(roaCms.getCertificate())).build();
    }

    private EeCertificate makeEeCertificate(X509ResourceCertificate certificate) {
        return EeCertificate.builder().validityTime(RpkiObjectController.formatValidity((ValidityPeriod)certificate.getValidityPeriod())).subjectName(certificate.getSubject().getName()).serial(certificate.getSerialNumber()).resources(RpkiObjectController.formatResources((IpResourceSet)certificate.getResources())).build();
    }

    private Mft makeMft(ValidationResult validationResult, ManifestCms manifestCms, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        return Mft.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).eeCertificate(this.makeEeCertificate(manifestCms.getCertificate())).thisUpdateTime(manifestCms.getThisUpdateTime().toDate()).nextUpdateTime(manifestCms.getNextUpdateTime().toDate()).manifestNumber(manifestCms.getNumber()).entries(this.makeMftEntries(manifestCms.getFiles())).sha256(Hex.format((byte[])rpkiObject.getSha256())).build();
    }

    private List<MftEntry> makeMftEntries(Map<String, byte[]> files) {
        return files.entrySet().stream().map(e -> MftEntry.builder().filename((String)e.getKey()).sha256(Hex.format((byte[])((byte[])e.getValue()))).build()).collect(Collectors.toList());
    }

    private Crl makeCrl(ValidationResult validationResult, X509Crl crl, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        Set<? extends X509CRLEntry> revokedCertificates = crl.getCrl().getRevokedCertificates();
        List revocations = revokedCertificates == null ? Collections.emptyList() : revokedCertificates.stream().map(X509CRLEntry::getSerialNumber).collect(Collectors.toList());
        return Crl.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).aki(Hex.format((byte[])crl.getAuthorityKeyIdentifier())).serial(crl.getNumber()).revocations(revocations).build();
    }

    private RpkiObj makeGbr(ValidationResult validationResult, GhostbustersCms gbr, RpkiObject rpkiObject) {
        String location = validationResult.getCurrentLocation().getName();
        boolean isValid = this.isValid(validationResult);
        return GhostbustersRecord.builder().uri(location).valid(isValid).warnings(RpkiObjectController.formatChecks((List)validationResult.getWarnings())).errors(RpkiObjectController.formatChecks((List)validationResult.getFailuresForAllLocations())).sha256(Hex.format((byte[])rpkiObject.getSha256())).vCard(gbr.getVCardContent()).eeCertificate(this.makeEeCertificate(gbr.getCertificate())).build();
    }

    private RpkiObj makeOther(ValidationResult vr, RpkiObject ro) {
        TreeSet s = Sets.newTreeSet();
        s.add(vr.getCurrentLocation().getName());
        return Other.builder().uri(RpkiObjectController.location((RpkiObject.Type)ro.getType(), (SortedSet)s)).build();
    }

    private static List<String> formatResources(IpResourceSet resources) {
        return StreamSupport.stream(resources.spliterator(), false).map(Object::toString).collect(Collectors.toList());
    }

    private static Map<String, String> formatSia(X509CertificateInformationAccessDescriptor[] sia) {
        return Arrays.stream(sia).collect(Collectors.toMap(s -> s.getMethod().toString(), s -> s.getLocation().toASCIIString()));
    }

    private static ValidityTime formatValidity(ValidityPeriod validityPeriod) {
        return ValidityTime.builder().notValidAfter(validityPeriod.getNotValidAfter().toDate()).notValidBefore(validityPeriod.getNotValidBefore().toDate()).build();
    }

    private static List<Issue> formatChecks(List<ValidationCheck> checks) {
        return checks.stream().map(validationCheck -> Issue.builder().status(validationCheck.getStatus().toString()).key(validationCheck.getKey()).parameters(validationCheck.getParams()).build()).collect(Collectors.toList());
    }
}

