/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.health;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.bgp.BgpPreviewService;
import net.ripe.rpki.validator3.api.bgp.BgpRisDump;
import net.ripe.rpki.validator3.api.health.Health;
import net.ripe.rpki.validator3.api.health.HealthController;
import net.ripe.rpki.validator3.api.trustanchors.TaStatus;
import net.ripe.rpki.validator3.api.util.BuildInformation;
import net.ripe.rpki.validator3.api.util.Dates;
import net.ripe.rpki.validator3.background.BackgroundJobs;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/api/healthcheck"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class HealthController {
    private static final Logger log = LoggerFactory.getLogger(HealthController.class);
    @Autowired
    private TrustAnchors trustAnchors;
    @Autowired
    private BgpPreviewService bgpPreviewService;
    @Autowired
    private BackgroundJobs backgroundJobs;
    @Autowired
    private BuildInformation buildInformation;
    @Autowired
    private Storage storage;

    @GetMapping
    public ResponseEntity<ApiResponse<?>> health() {
        try {
            List trustAnchorReady = ((List)this.storage.readTx(tx -> this.trustAnchors.getStatuses(tx))).stream().map(taStatus -> new TaHealth(taStatus.getTaName(), taStatus.isCompletedValidation())).collect(Collectors.toList());
            Map<String, Boolean> bgpDumpReady = this.bgpPreviewService.getBgpDumps().stream().collect(Collectors.toMap(BgpRisDump::getUrl, dmp -> dmp.getLastModified() != null));
            Map databaseStatus = this.databaseStatus();
            return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)Health.of((String)"OK", trustAnchorReady, bgpDumpReady, (Map)databaseStatus, (BuildInformation)this.buildInformation)).build());
        }
        catch (Exception e) {
            return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)("ERROR: " + e.getMessage())).build());
        }
    }

    @GetMapping(path={"/backgrounds"})
    public ResponseEntity<ApiResponse<Map<String, BackgroundJobs.Execution>>> check() {
        return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)this.backgroundJobs.getStat()).build());
    }

    @GetMapping(path={"/all-ta-completed"})
    public ResponseEntity<ApiResponse<?>> statuses() {
        List statuses = (List)this.storage.readTx(tx -> this.trustAnchors.getStatuses(tx));
        boolean allComplete = statuses.stream().filter(TaStatus::isCompletedValidation).count() >= 5L;
        OffsetDateTime utc = OffsetDateTime.now(ZoneOffset.UTC);
        Instant eightHoursAgo = utc.toInstant().minus(8L, ChronoUnit.HOURS);
        Map<String, String> lateTAs = statuses.stream().filter(s -> Dates.parseUTC((String)s.getLastUpdated()).isBefore(eightHoursAgo)).collect(Collectors.toMap(TaStatus::getTaName, TaStatus::getLastUpdated));
        if (allComplete && lateTAs.isEmpty()) {
            return ResponseEntity.ok((Object)ApiResponse.builder().data((Object)"OK").build());
        }
        return ResponseEntity.ok((Object)ApiResponse.builder().data(lateTAs).build());
    }

    private Map<String, String> databaseStatus() {
        try {
            return this.storage.getDbStats();
        }
        catch (Exception e) {
            return Collections.singletonMap("error", e.getMessage());
        }
    }
}

