/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import java.beans.ConstructorProperties;
import net.ripe.rpki.rtr.domain.RtrDataUnit;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;
import net.ripe.rpki.rtr.domain.pdus.RouterKeyPdu;
import org.bouncycastle.util.Arrays;

public final class RtrRouterKey
implements RtrDataUnit {
    private final byte[] subjectKeyIdentifier;
    private final byte[] subjectPublicKeyInfo;
    private final int asn;

    public Pdu toPdu(ProtocolVersion protocolVersion, Flags flags) {
        return RouterKeyPdu.of((ProtocolVersion)protocolVersion, (Flags)flags, (byte[])this.subjectKeyIdentifier, (byte[])this.subjectPublicKeyInfo, (int)this.asn);
    }

    public int compareToSameType(RtrDataUnit o) {
        RtrRouterKey that = (RtrRouterKey)o;
        int rc = Integer.compare(this.asn, that.asn);
        if (rc != 0) {
            return rc;
        }
        rc = Arrays.compareUnsigned((byte[])this.subjectKeyIdentifier, (byte[])that.subjectKeyIdentifier);
        if (rc != 0) {
            return rc;
        }
        return Arrays.compareUnsigned((byte[])this.subjectPublicKeyInfo, (byte[])that.subjectPublicKeyInfo);
    }

    @ConstructorProperties(value={"subjectKeyIdentifier", "subjectPublicKeyInfo", "asn"})
    private RtrRouterKey(byte[] subjectKeyIdentifier, byte[] subjectPublicKeyInfo, int asn) {
        this.subjectKeyIdentifier = subjectKeyIdentifier;
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
        this.asn = asn;
    }

    public static RtrRouterKey of(byte[] subjectKeyIdentifier, byte[] subjectPublicKeyInfo, int asn) {
        return new RtrRouterKey(subjectKeyIdentifier, subjectPublicKeyInfo, asn);
    }

    public byte[] getSubjectKeyIdentifier() {
        return this.subjectKeyIdentifier;
    }

    public byte[] getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public int getAsn() {
        return this.asn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtrRouterKey)) {
            return false;
        }
        RtrRouterKey other = (RtrRouterKey)o;
        if (this.getAsn() != other.getAsn()) {
            return false;
        }
        if (!java.util.Arrays.equals(this.getSubjectKeyIdentifier(), other.getSubjectKeyIdentifier())) {
            return false;
        }
        return java.util.Arrays.equals(this.getSubjectPublicKeyInfo(), other.getSubjectPublicKeyInfo());
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAsn();
        result = result * 59 + java.util.Arrays.hashCode(this.getSubjectKeyIdentifier());
        result = result * 59 + java.util.Arrays.hashCode(this.getSubjectPublicKeyInfo());
        return result;
    }

    public String toString() {
        return "RtrRouterKey(subjectKeyIdentifier=" + java.util.Arrays.toString(this.getSubjectKeyIdentifier()) + ", subjectPublicKeyInfo=" + java.util.Arrays.toString(this.getSubjectPublicKeyInfo()) + ", asn=" + this.getAsn() + ")";
    }
}

