/****************************************************************************
**
** Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtOpenGL module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
**
** This file was generated by glgen version 0.1
** Command line was: glgen
**
** glgen is Copyright (C) 2013 Klaralvdalens Datakonsult AB (KDAB)
**
** This is an auto-generated file.
** Do not edit! All changes made to it will be lost.
**
****************************************************************************/

#ifndef QOPENGLVERSIONFUNCTIONS_3_3_CORE_H
#define QOPENGLVERSIONFUNCTIONS_3_3_CORE_H

#include <QtOpenGL/qtopenglglobal.h>

#if !defined(QT_NO_OPENGL) && !QT_CONFIG(opengles2)

#include <QtOpenGL/QOpenGLVersionProfile>
#include <QtOpenGL/QOpenGLVersionFunctions>
#include <QtGui/qopenglcontext.h>

QT_BEGIN_NAMESPACE

class Q_OPENGL_EXPORT QOpenGLFunctions_3_3_Core : public QAbstractOpenGLFunctions
{
public:
    QOpenGLFunctions_3_3_Core();
    ~QOpenGLFunctions_3_3_Core();

    bool initializeOpenGLFunctions() override;

    // OpenGL 1.0 core functions
    void glViewport(GLint x, GLint y, GLsizei width, GLsizei height);
    void glDepthRange(GLdouble nearVal, GLdouble farVal);
    GLboolean glIsEnabled(GLenum cap);
    void glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params);
    void glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params);
    void glGetTexParameteriv(GLenum target, GLenum pname, GLint *params);
    void glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params);
    void glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels);
    const GLubyte * glGetString(GLenum name);
    void glGetIntegerv(GLenum pname, GLint *params);
    void glGetFloatv(GLenum pname, GLfloat *params);
    GLenum glGetError();
    void glGetDoublev(GLenum pname, GLdouble *params);
    void glGetBooleanv(GLenum pname, GLboolean *params);
    void glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels);
    void glReadBuffer(GLenum mode);
    void glPixelStorei(GLenum pname, GLint param);
    void glPixelStoref(GLenum pname, GLfloat param);
    void glDepthFunc(GLenum func);
    void glStencilOp(GLenum fail, GLenum zfail, GLenum zpass);
    void glStencilFunc(GLenum func, GLint ref, GLuint mask);
    void glLogicOp(GLenum opcode);
    void glBlendFunc(GLenum sfactor, GLenum dfactor);
    void glFlush();
    void glFinish();
    void glEnable(GLenum cap);
    void glDisable(GLenum cap);
    void glDepthMask(GLboolean flag);
    void glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha);
    void glStencilMask(GLuint mask);
    void glClearDepth(GLdouble depth);
    void glClearStencil(GLint s);
    void glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);
    void glClear(GLbitfield mask);
    void glDrawBuffer(GLenum mode);
    void glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexParameteriv(GLenum target, GLenum pname, const GLint *params);
    void glTexParameteri(GLenum target, GLenum pname, GLint param);
    void glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params);
    void glTexParameterf(GLenum target, GLenum pname, GLfloat param);
    void glScissor(GLint x, GLint y, GLsizei width, GLsizei height);
    void glPolygonMode(GLenum face, GLenum mode);
    void glPointSize(GLfloat size);
    void glLineWidth(GLfloat width);
    void glHint(GLenum target, GLenum mode);
    void glFrontFace(GLenum mode);
    void glCullFace(GLenum mode);

    // OpenGL 1.1 core functions
    GLboolean glIsTexture(GLuint texture);
    void glGenTextures(GLsizei n, GLuint *textures);
    void glDeleteTextures(GLsizei n, const GLuint *textures);
    void glBindTexture(GLenum target, GLuint texture);
    void glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels);
    void glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width);
    void glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border);
    void glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border);
    void glPolygonOffset(GLfloat factor, GLfloat units);
    void glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices);
    void glDrawArrays(GLenum mode, GLint first, GLsizei count);

    // OpenGL 1.2 core functions
    void glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height);
    void glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels);
    void glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
    void glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices);
    void glBlendEquation(GLenum mode);
    void glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha);

    // OpenGL 1.3 core functions
    void glGetCompressedTexImage(GLenum target, GLint level, GLvoid *img);
    void glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data);
    void glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data);
    void glSampleCoverage(GLfloat value, GLboolean invert);
    void glActiveTexture(GLenum texture);

    // OpenGL 1.4 core functions
    void glPointParameteriv(GLenum pname, const GLint *params);
    void glPointParameteri(GLenum pname, GLint param);
    void glPointParameterfv(GLenum pname, const GLfloat *params);
    void glPointParameterf(GLenum pname, GLfloat param);
    void glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount);
    void glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount);
    void glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha);

    // OpenGL 1.5 core functions
    void glGetBufferPointerv(GLenum target, GLenum pname, GLvoid* *params);
    void glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params);
    GLboolean glUnmapBuffer(GLenum target);
    GLvoid* glMapBuffer(GLenum target, GLenum access);
    void glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data);
    void glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data);
    void glBufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage);
    GLboolean glIsBuffer(GLuint buffer);
    void glGenBuffers(GLsizei n, GLuint *buffers);
    void glDeleteBuffers(GLsizei n, const GLuint *buffers);
    void glBindBuffer(GLenum target, GLuint buffer);
    void glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params);
    void glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params);
    void glGetQueryiv(GLenum target, GLenum pname, GLint *params);
    void glEndQuery(GLenum target);
    void glBeginQuery(GLenum target, GLuint id);
    GLboolean glIsQuery(GLuint id);
    void glDeleteQueries(GLsizei n, const GLuint *ids);
    void glGenQueries(GLsizei n, GLuint *ids);

    // OpenGL 2.0 core functions
    void glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
    void glValidateProgram(GLuint program);
    void glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniform4iv(GLint location, GLsizei count, const GLint *value);
    void glUniform3iv(GLint location, GLsizei count, const GLint *value);
    void glUniform2iv(GLint location, GLsizei count, const GLint *value);
    void glUniform1iv(GLint location, GLsizei count, const GLint *value);
    void glUniform4fv(GLint location, GLsizei count, const GLfloat *value);
    void glUniform3fv(GLint location, GLsizei count, const GLfloat *value);
    void glUniform2fv(GLint location, GLsizei count, const GLfloat *value);
    void glUniform1fv(GLint location, GLsizei count, const GLfloat *value);
    void glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
    void glUniform3i(GLint location, GLint v0, GLint v1, GLint v2);
    void glUniform2i(GLint location, GLint v0, GLint v1);
    void glUniform1i(GLint location, GLint v0);
    void glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
    void glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
    void glUniform2f(GLint location, GLfloat v0, GLfloat v1);
    void glUniform1f(GLint location, GLfloat v0);
    void glUseProgram(GLuint program);
    void glShaderSource(GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length);
    void glLinkProgram(GLuint program);
    GLboolean glIsShader(GLuint shader);
    GLboolean glIsProgram(GLuint program);
    void glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid* *pointer);
    void glGetVertexAttribiv(GLuint index, GLenum pname, GLint *params);
    void glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params);
    void glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params);
    void glGetUniformiv(GLuint program, GLint location, GLint *params);
    void glGetUniformfv(GLuint program, GLint location, GLfloat *params);
    GLint glGetUniformLocation(GLuint program, const GLchar *name);
    void glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
    void glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
    void glGetShaderiv(GLuint shader, GLenum pname, GLint *params);
    void glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
    void glGetProgramiv(GLuint program, GLenum pname, GLint *params);
    GLint glGetAttribLocation(GLuint program, const GLchar *name);
    void glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj);
    void glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
    void glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
    void glEnableVertexAttribArray(GLuint index);
    void glDisableVertexAttribArray(GLuint index);
    void glDetachShader(GLuint program, GLuint shader);
    void glDeleteShader(GLuint shader);
    void glDeleteProgram(GLuint program);
    GLuint glCreateShader(GLenum type);
    GLuint glCreateProgram();
    void glCompileShader(GLuint shader);
    void glBindAttribLocation(GLuint program, GLuint index, const GLchar *name);
    void glAttachShader(GLuint program, GLuint shader);
    void glStencilMaskSeparate(GLenum face, GLuint mask);
    void glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask);
    void glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
    void glDrawBuffers(GLsizei n, const GLenum *bufs);
    void glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha);

    // OpenGL 2.1 core functions
    void glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
    void glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

    // OpenGL 3.0 core functions
    GLboolean glIsVertexArray(GLuint array);
    void glGenVertexArrays(GLsizei n, GLuint *arrays);
    void glDeleteVertexArrays(GLsizei n, const GLuint *arrays);
    void glBindVertexArray(GLuint array);
    void glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length);
    GLvoid* glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access);
    void glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer);
    void glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height);
    void glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter);
    void glGenerateMipmap(GLenum target);
    void glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params);
    void glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
    void glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
    void glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    void glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
    GLenum glCheckFramebufferStatus(GLenum target);
    void glGenFramebuffers(GLsizei n, GLuint *framebuffers);
    void glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers);
    void glBindFramebuffer(GLenum target, GLuint framebuffer);
    GLboolean glIsFramebuffer(GLuint framebuffer);
    void glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params);
    void glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
    void glGenRenderbuffers(GLsizei n, GLuint *renderbuffers);
    void glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers);
    void glBindRenderbuffer(GLenum target, GLuint renderbuffer);
    GLboolean glIsRenderbuffer(GLuint renderbuffer);
    const GLubyte * glGetStringi(GLenum name, GLuint index);
    void glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil);
    void glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value);
    void glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value);
    void glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value);
    void glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params);
    void glGetTexParameterIiv(GLenum target, GLenum pname, GLint *params);
    void glTexParameterIuiv(GLenum target, GLenum pname, const GLuint *params);
    void glTexParameterIiv(GLenum target, GLenum pname, const GLint *params);
    void glUniform4uiv(GLint location, GLsizei count, const GLuint *value);
    void glUniform3uiv(GLint location, GLsizei count, const GLuint *value);
    void glUniform2uiv(GLint location, GLsizei count, const GLuint *value);
    void glUniform1uiv(GLint location, GLsizei count, const GLuint *value);
    void glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3);
    void glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2);
    void glUniform2ui(GLint location, GLuint v0, GLuint v1);
    void glUniform1ui(GLint location, GLuint v0);
    GLint glGetFragDataLocation(GLuint program, const GLchar *name);
    void glBindFragDataLocation(GLuint program, GLuint color, const GLchar *name);
    void glGetUniformuiv(GLuint program, GLint location, GLuint *params);
    void glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params);
    void glGetVertexAttribIiv(GLuint index, GLenum pname, GLint *params);
    void glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer);
    void glEndConditionalRender();
    void glBeginConditionalRender(GLuint id, GLenum mode);
    void glClampColor(GLenum target, GLenum clamp);
    void glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
    void glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar* const *varyings, GLenum bufferMode);
    void glBindBufferBase(GLenum target, GLuint index, GLuint buffer);
    void glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size);
    void glEndTransformFeedback();
    void glBeginTransformFeedback(GLenum primitiveMode);
    GLboolean glIsEnabledi(GLenum target, GLuint index);
    void glDisablei(GLenum target, GLuint index);
    void glEnablei(GLenum target, GLuint index);
    void glGetIntegeri_v(GLenum target, GLuint index, GLint *data);
    void glGetBooleani_v(GLenum target, GLuint index, GLboolean *data);
    void glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a);

    // OpenGL 3.1 core functions
    void glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size);
    void glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding);
    void glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName);
    void glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params);
    GLuint glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName);
    void glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName);
    void glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params);
    void glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices);
    void glPrimitiveRestartIndex(GLuint index);
    void glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer);
    void glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount);
    void glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount);

    // OpenGL 3.2 core functions
    void glSampleMaski(GLuint index, GLbitfield mask);
    void glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val);
    void glTexImage3DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations);
    void glTexImage2DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations);
    void glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values);
    void glGetInteger64v(GLenum pname, GLint64 *params);
    void glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
    GLenum glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout);
    void glDeleteSync(GLsync sync);
    GLboolean glIsSync(GLsync sync);
    GLsync glFenceSync(GLenum condition, GLbitfield flags);
    void glProvokingVertex(GLenum mode);
    void glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex);
    void glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex);
    void glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
    void glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex);
    void glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level);
    void glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params);
    void glGetInteger64i_v(GLenum target, GLuint index, GLint64 *data);

    // OpenGL 3.3 core functions
    void glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value);
    void glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value);
    void glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params);
    void glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params);
    void glQueryCounter(GLuint id, GLenum target);
    void glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params);
    void glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params);
    void glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params);
    void glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params);
    void glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param);
    void glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param);
    void glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param);
    void glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param);
    void glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param);
    void glSamplerParameteri(GLuint sampler, GLenum pname, GLint param);
    void glBindSampler(GLuint unit, GLuint sampler);
    GLboolean glIsSampler(GLuint sampler);
    void glDeleteSamplers(GLsizei count, const GLuint *samplers);
    void glGenSamplers(GLsizei count, GLuint *samplers);
    GLint glGetFragDataIndex(GLuint program, const GLchar *name);
    void glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name);
    void glVertexAttribDivisor(GLuint index, GLuint divisor);

private:
    friend class QOpenGLVersionFunctionsFactory;

    static bool isContextCompatible(QOpenGLContext *context);
    static QOpenGLVersionProfile versionProfile();

    QOpenGLFunctions_1_0_CoreBackend* d_1_0_Core;
    QOpenGLFunctions_1_1_CoreBackend* d_1_1_Core;
    QOpenGLFunctions_1_2_CoreBackend* d_1_2_Core;
    QOpenGLFunctions_1_3_CoreBackend* d_1_3_Core;
    QOpenGLFunctions_1_4_CoreBackend* d_1_4_Core;
    QOpenGLFunctions_1_5_CoreBackend* d_1_5_Core;
    QOpenGLFunctions_2_0_CoreBackend* d_2_0_Core;
    QOpenGLFunctions_2_1_CoreBackend* d_2_1_Core;
    QOpenGLFunctions_3_0_CoreBackend* d_3_0_Core;
    QOpenGLFunctions_3_1_CoreBackend* d_3_1_Core;
    QOpenGLFunctions_3_2_CoreBackend* d_3_2_Core;
    QOpenGLFunctions_3_3_CoreBackend* d_3_3_Core;
};

// OpenGL 1.0 core functions
inline void QOpenGLFunctions_3_3_Core::glViewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_0_Core->f.Viewport(x, y, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glDepthRange(GLdouble nearVal, GLdouble farVal)
{
    d_1_0_Core->f.DepthRange(nearVal, farVal);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsEnabled(GLenum cap)
{
    return d_1_0_Core->f.IsEnabled(cap);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexLevelParameteriv(GLenum target, GLint level, GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetTexLevelParameteriv(target, level, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexLevelParameterfv(GLenum target, GLint level, GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetTexLevelParameterfv(target, level, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetTexParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetTexParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexImage(GLenum target, GLint level, GLenum format, GLenum type, GLvoid *pixels)
{
    d_1_0_Core->f.GetTexImage(target, level, format, type, pixels);
}

inline const GLubyte * QOpenGLFunctions_3_3_Core::glGetString(GLenum name)
{
    return d_1_0_Core->f.GetString(name);
}

inline void QOpenGLFunctions_3_3_Core::glGetIntegerv(GLenum pname, GLint *params)
{
    d_1_0_Core->f.GetIntegerv(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetFloatv(GLenum pname, GLfloat *params)
{
    d_1_0_Core->f.GetFloatv(pname, params);
}

inline GLenum QOpenGLFunctions_3_3_Core::glGetError()
{
    return d_1_0_Core->f.GetError();
}

inline void QOpenGLFunctions_3_3_Core::glGetDoublev(GLenum pname, GLdouble *params)
{
    d_1_0_Core->f.GetDoublev(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetBooleanv(GLenum pname, GLboolean *params)
{
    d_1_0_Core->f.GetBooleanv(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glReadPixels(GLint x, GLint y, GLsizei width, GLsizei height, GLenum format, GLenum type, GLvoid *pixels)
{
    d_1_0_Core->f.ReadPixels(x, y, width, height, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glReadBuffer(GLenum mode)
{
    d_1_0_Core->f.ReadBuffer(mode);
}

inline void QOpenGLFunctions_3_3_Core::glPixelStorei(GLenum pname, GLint param)
{
    d_1_0_Core->f.PixelStorei(pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glPixelStoref(GLenum pname, GLfloat param)
{
    d_1_0_Core->f.PixelStoref(pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glDepthFunc(GLenum func)
{
    d_1_0_Core->f.DepthFunc(func);
}

inline void QOpenGLFunctions_3_3_Core::glStencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    d_1_0_Core->f.StencilOp(fail, zfail, zpass);
}

inline void QOpenGLFunctions_3_3_Core::glStencilFunc(GLenum func, GLint ref, GLuint mask)
{
    d_1_0_Core->f.StencilFunc(func, ref, mask);
}

inline void QOpenGLFunctions_3_3_Core::glLogicOp(GLenum opcode)
{
    d_1_0_Core->f.LogicOp(opcode);
}

inline void QOpenGLFunctions_3_3_Core::glBlendFunc(GLenum sfactor, GLenum dfactor)
{
    d_1_0_Core->f.BlendFunc(sfactor, dfactor);
}

inline void QOpenGLFunctions_3_3_Core::glFlush()
{
    d_1_0_Core->f.Flush();
}

inline void QOpenGLFunctions_3_3_Core::glFinish()
{
    d_1_0_Core->f.Finish();
}

inline void QOpenGLFunctions_3_3_Core::glEnable(GLenum cap)
{
    d_1_0_Core->f.Enable(cap);
}

inline void QOpenGLFunctions_3_3_Core::glDisable(GLenum cap)
{
    d_1_0_Core->f.Disable(cap);
}

inline void QOpenGLFunctions_3_3_Core::glDepthMask(GLboolean flag)
{
    d_1_0_Core->f.DepthMask(flag);
}

inline void QOpenGLFunctions_3_3_Core::glColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    d_1_0_Core->f.ColorMask(red, green, blue, alpha);
}

inline void QOpenGLFunctions_3_3_Core::glStencilMask(GLuint mask)
{
    d_1_0_Core->f.StencilMask(mask);
}

inline void QOpenGLFunctions_3_3_Core::glClearDepth(GLdouble depth)
{
    d_1_0_Core->f.ClearDepth(depth);
}

inline void QOpenGLFunctions_3_3_Core::glClearStencil(GLint s)
{
    d_1_0_Core->f.ClearStencil(s);
}

inline void QOpenGLFunctions_3_3_Core::glClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_0_Core->f.ClearColor(red, green, blue, alpha);
}

inline void QOpenGLFunctions_3_3_Core::glClear(GLbitfield mask)
{
    d_1_0_Core->f.Clear(mask);
}

inline void QOpenGLFunctions_3_3_Core::glDrawBuffer(GLenum mode)
{
    d_1_0_Core->f.DrawBuffer(mode);
}

inline void QOpenGLFunctions_3_3_Core::glTexImage2D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_0_Core->f.TexImage2D(target, level, internalformat, width, height, border, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glTexImage1D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_0_Core->f.TexImage1D(target, level, internalformat, width, border, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    d_1_0_Core->f.TexParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameteri(GLenum target, GLenum pname, GLint param)
{
    d_1_0_Core->f.TexParameteri(target, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    d_1_0_Core->f.TexParameterfv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    d_1_0_Core->f.TexParameterf(target, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glScissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_0_Core->f.Scissor(x, y, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glPolygonMode(GLenum face, GLenum mode)
{
    d_1_0_Core->f.PolygonMode(face, mode);
}

inline void QOpenGLFunctions_3_3_Core::glPointSize(GLfloat size)
{
    d_1_0_Core->f.PointSize(size);
}

inline void QOpenGLFunctions_3_3_Core::glLineWidth(GLfloat width)
{
    d_1_0_Core->f.LineWidth(width);
}

inline void QOpenGLFunctions_3_3_Core::glHint(GLenum target, GLenum mode)
{
    d_1_0_Core->f.Hint(target, mode);
}

inline void QOpenGLFunctions_3_3_Core::glFrontFace(GLenum mode)
{
    d_1_0_Core->f.FrontFace(mode);
}

inline void QOpenGLFunctions_3_3_Core::glCullFace(GLenum mode)
{
    d_1_0_Core->f.CullFace(mode);
}


// OpenGL 1.1 core functions
inline GLboolean QOpenGLFunctions_3_3_Core::glIsTexture(GLuint texture)
{
    return d_1_1_Core->f.IsTexture(texture);
}

inline void QOpenGLFunctions_3_3_Core::glGenTextures(GLsizei n, GLuint *textures)
{
    d_1_1_Core->f.GenTextures(n, textures);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteTextures(GLsizei n, const GLuint *textures)
{
    d_1_1_Core->f.DeleteTextures(n, textures);
}

inline void QOpenGLFunctions_3_3_Core::glBindTexture(GLenum target, GLuint texture)
{
    d_1_1_Core->f.BindTexture(target, texture);
}

inline void QOpenGLFunctions_3_3_Core::glTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_1_Core->f.TexSubImage2D(target, level, xoffset, yoffset, width, height, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_1_Core->f.TexSubImage1D(target, level, xoffset, width, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glCopyTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_1_Core->f.CopyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glCopyTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLint x, GLint y, GLsizei width)
{
    d_1_1_Core->f.CopyTexSubImage1D(target, level, xoffset, x, y, width);
}

inline void QOpenGLFunctions_3_3_Core::glCopyTexImage2D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLsizei height, GLint border)
{
    d_1_1_Core->f.CopyTexImage2D(target, level, internalformat, x, y, width, height, border);
}

inline void QOpenGLFunctions_3_3_Core::glCopyTexImage1D(GLenum target, GLint level, GLenum internalformat, GLint x, GLint y, GLsizei width, GLint border)
{
    d_1_1_Core->f.CopyTexImage1D(target, level, internalformat, x, y, width, border);
}

inline void QOpenGLFunctions_3_3_Core::glPolygonOffset(GLfloat factor, GLfloat units)
{
    d_1_1_Core->f.PolygonOffset(factor, units);
}

inline void QOpenGLFunctions_3_3_Core::glDrawElements(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices)
{
    d_1_1_Core->f.DrawElements(mode, count, type, indices);
}

inline void QOpenGLFunctions_3_3_Core::glDrawArrays(GLenum mode, GLint first, GLsizei count)
{
    d_1_1_Core->f.DrawArrays(mode, first, count);
}


// OpenGL 1.2 core functions
inline void QOpenGLFunctions_3_3_Core::glCopyTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLint x, GLint y, GLsizei width, GLsizei height)
{
    d_1_2_Core->f.CopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_2_Core->f.TexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glTexImage3D(GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels)
{
    d_1_2_Core->f.TexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels);
}

inline void QOpenGLFunctions_3_3_Core::glDrawRangeElements(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices)
{
    d_1_2_Core->f.DrawRangeElements(mode, start, end, count, type, indices);
}

inline void QOpenGLFunctions_3_3_Core::glBlendEquation(GLenum mode)
{
    d_1_2_Core->f.BlendEquation(mode);
}

inline void QOpenGLFunctions_3_3_Core::glBlendColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    d_1_2_Core->f.BlendColor(red, green, blue, alpha);
}


// OpenGL 1.3 core functions
inline void QOpenGLFunctions_3_3_Core::glGetCompressedTexImage(GLenum target, GLint level, GLvoid *img)
{
    d_1_3_Core->f.GetCompressedTexImage(target, level, img);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexSubImage1D(GLenum target, GLint level, GLint xoffset, GLsizei width, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage1D(target, level, xoffset, width, format, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexSubImage2D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLsizei width, GLsizei height, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexSubImage3D(GLenum target, GLint level, GLint xoffset, GLint yoffset, GLint zoffset, GLsizei width, GLsizei height, GLsizei depth, GLenum format, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexImage1D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage1D(target, level, internalformat, width, border, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexImage2D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage2D(target, level, internalformat, width, height, border, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glCompressedTexImage3D(GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid *data)
{
    d_1_3_Core->f.CompressedTexImage3D(target, level, internalformat, width, height, depth, border, imageSize, data);
}

inline void QOpenGLFunctions_3_3_Core::glSampleCoverage(GLfloat value, GLboolean invert)
{
    d_1_3_Core->f.SampleCoverage(value, invert);
}

inline void QOpenGLFunctions_3_3_Core::glActiveTexture(GLenum texture)
{
    d_1_3_Core->f.ActiveTexture(texture);
}


// OpenGL 1.4 core functions
inline void QOpenGLFunctions_3_3_Core::glPointParameteriv(GLenum pname, const GLint *params)
{
    d_1_4_Core->f.PointParameteriv(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glPointParameteri(GLenum pname, GLint param)
{
    d_1_4_Core->f.PointParameteri(pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glPointParameterfv(GLenum pname, const GLfloat *params)
{
    d_1_4_Core->f.PointParameterfv(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glPointParameterf(GLenum pname, GLfloat param)
{
    d_1_4_Core->f.PointParameterf(pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glMultiDrawElements(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount)
{
    d_1_4_Core->f.MultiDrawElements(mode, count, type, indices, drawcount);
}

inline void QOpenGLFunctions_3_3_Core::glMultiDrawArrays(GLenum mode, const GLint *first, const GLsizei *count, GLsizei drawcount)
{
    d_1_4_Core->f.MultiDrawArrays(mode, first, count, drawcount);
}

inline void QOpenGLFunctions_3_3_Core::glBlendFuncSeparate(GLenum sfactorRGB, GLenum dfactorRGB, GLenum sfactorAlpha, GLenum dfactorAlpha)
{
    d_1_4_Core->f.BlendFuncSeparate(sfactorRGB, dfactorRGB, sfactorAlpha, dfactorAlpha);
}


// OpenGL 1.5 core functions
inline void QOpenGLFunctions_3_3_Core::glGetBufferPointerv(GLenum target, GLenum pname, GLvoid* *params)
{
    d_1_5_Core->f.GetBufferPointerv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetBufferParameteriv(target, pname, params);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glUnmapBuffer(GLenum target)
{
    return d_1_5_Core->f.UnmapBuffer(target);
}

inline GLvoid* QOpenGLFunctions_3_3_Core::glMapBuffer(GLenum target, GLenum access)
{
    return d_1_5_Core->f.MapBuffer(target, access);
}

inline void QOpenGLFunctions_3_3_Core::glGetBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, GLvoid *data)
{
    d_1_5_Core->f.GetBufferSubData(target, offset, size, data);
}

inline void QOpenGLFunctions_3_3_Core::glBufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const GLvoid *data)
{
    d_1_5_Core->f.BufferSubData(target, offset, size, data);
}

inline void QOpenGLFunctions_3_3_Core::glBufferData(GLenum target, GLsizeiptr size, const GLvoid *data, GLenum usage)
{
    d_1_5_Core->f.BufferData(target, size, data, usage);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsBuffer(GLuint buffer)
{
    return d_1_5_Core->f.IsBuffer(buffer);
}

inline void QOpenGLFunctions_3_3_Core::glGenBuffers(GLsizei n, GLuint *buffers)
{
    d_1_5_Core->f.GenBuffers(n, buffers);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteBuffers(GLsizei n, const GLuint *buffers)
{
    d_1_5_Core->f.DeleteBuffers(n, buffers);
}

inline void QOpenGLFunctions_3_3_Core::glBindBuffer(GLenum target, GLuint buffer)
{
    d_1_5_Core->f.BindBuffer(target, buffer);
}

inline void QOpenGLFunctions_3_3_Core::glGetQueryObjectuiv(GLuint id, GLenum pname, GLuint *params)
{
    d_1_5_Core->f.GetQueryObjectuiv(id, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetQueryObjectiv(GLuint id, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetQueryObjectiv(id, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetQueryiv(GLenum target, GLenum pname, GLint *params)
{
    d_1_5_Core->f.GetQueryiv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glEndQuery(GLenum target)
{
    d_1_5_Core->f.EndQuery(target);
}

inline void QOpenGLFunctions_3_3_Core::glBeginQuery(GLenum target, GLuint id)
{
    d_1_5_Core->f.BeginQuery(target, id);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsQuery(GLuint id)
{
    return d_1_5_Core->f.IsQuery(id);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteQueries(GLsizei n, const GLuint *ids)
{
    d_1_5_Core->f.DeleteQueries(n, ids);
}

inline void QOpenGLFunctions_3_3_Core::glGenQueries(GLsizei n, GLuint *ids)
{
    d_1_5_Core->f.GenQueries(n, ids);
}


// OpenGL 2.0 core functions
inline void QOpenGLFunctions_3_3_Core::glVertexAttribPointer(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer)
{
    d_2_0_Core->f.VertexAttribPointer(index, size, type, normalized, stride, pointer);
}

inline void QOpenGLFunctions_3_3_Core::glValidateProgram(GLuint program)
{
    d_2_0_Core->f.ValidateProgram(program);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_0_Core->f.UniformMatrix4fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_0_Core->f.UniformMatrix3fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_0_Core->f.UniformMatrix2fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4iv(GLint location, GLsizei count, const GLint *value)
{
    d_2_0_Core->f.Uniform4iv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3iv(GLint location, GLsizei count, const GLint *value)
{
    d_2_0_Core->f.Uniform3iv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2iv(GLint location, GLsizei count, const GLint *value)
{
    d_2_0_Core->f.Uniform2iv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1iv(GLint location, GLsizei count, const GLint *value)
{
    d_2_0_Core->f.Uniform1iv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4fv(GLint location, GLsizei count, const GLfloat *value)
{
    d_2_0_Core->f.Uniform4fv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3fv(GLint location, GLsizei count, const GLfloat *value)
{
    d_2_0_Core->f.Uniform3fv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2fv(GLint location, GLsizei count, const GLfloat *value)
{
    d_2_0_Core->f.Uniform2fv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1fv(GLint location, GLsizei count, const GLfloat *value)
{
    d_2_0_Core->f.Uniform1fv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4i(GLint location, GLint v0, GLint v1, GLint v2, GLint v3)
{
    d_2_0_Core->f.Uniform4i(location, v0, v1, v2, v3);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3i(GLint location, GLint v0, GLint v1, GLint v2)
{
    d_2_0_Core->f.Uniform3i(location, v0, v1, v2);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2i(GLint location, GLint v0, GLint v1)
{
    d_2_0_Core->f.Uniform2i(location, v0, v1);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1i(GLint location, GLint v0)
{
    d_2_0_Core->f.Uniform1i(location, v0);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3)
{
    d_2_0_Core->f.Uniform4f(location, v0, v1, v2, v3);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3f(GLint location, GLfloat v0, GLfloat v1, GLfloat v2)
{
    d_2_0_Core->f.Uniform3f(location, v0, v1, v2);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2f(GLint location, GLfloat v0, GLfloat v1)
{
    d_2_0_Core->f.Uniform2f(location, v0, v1);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1f(GLint location, GLfloat v0)
{
    d_2_0_Core->f.Uniform1f(location, v0);
}

inline void QOpenGLFunctions_3_3_Core::glUseProgram(GLuint program)
{
    d_2_0_Core->f.UseProgram(program);
}

inline void QOpenGLFunctions_3_3_Core::glShaderSource(GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length)
{
    d_2_0_Core->f.ShaderSource(shader, count, string, length);
}

inline void QOpenGLFunctions_3_3_Core::glLinkProgram(GLuint program)
{
    d_2_0_Core->f.LinkProgram(program);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsShader(GLuint shader)
{
    return d_2_0_Core->f.IsShader(shader);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsProgram(GLuint program)
{
    return d_2_0_Core->f.IsProgram(program);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribPointerv(GLuint index, GLenum pname, GLvoid* *pointer)
{
    d_2_0_Core->f.GetVertexAttribPointerv(index, pname, pointer);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribiv(GLuint index, GLenum pname, GLint *params)
{
    d_2_0_Core->f.GetVertexAttribiv(index, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribfv(GLuint index, GLenum pname, GLfloat *params)
{
    d_2_0_Core->f.GetVertexAttribfv(index, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribdv(GLuint index, GLenum pname, GLdouble *params)
{
    d_2_0_Core->f.GetVertexAttribdv(index, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetUniformiv(GLuint program, GLint location, GLint *params)
{
    d_2_0_Core->f.GetUniformiv(program, location, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetUniformfv(GLuint program, GLint location, GLfloat *params)
{
    d_2_0_Core->f.GetUniformfv(program, location, params);
}

inline GLint QOpenGLFunctions_3_3_Core::glGetUniformLocation(GLuint program, const GLchar *name)
{
    return d_2_0_Core->f.GetUniformLocation(program, name);
}

inline void QOpenGLFunctions_3_3_Core::glGetShaderSource(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source)
{
    d_2_0_Core->f.GetShaderSource(shader, bufSize, length, source);
}

inline void QOpenGLFunctions_3_3_Core::glGetShaderInfoLog(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    d_2_0_Core->f.GetShaderInfoLog(shader, bufSize, length, infoLog);
}

inline void QOpenGLFunctions_3_3_Core::glGetShaderiv(GLuint shader, GLenum pname, GLint *params)
{
    d_2_0_Core->f.GetShaderiv(shader, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetProgramInfoLog(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog)
{
    d_2_0_Core->f.GetProgramInfoLog(program, bufSize, length, infoLog);
}

inline void QOpenGLFunctions_3_3_Core::glGetProgramiv(GLuint program, GLenum pname, GLint *params)
{
    d_2_0_Core->f.GetProgramiv(program, pname, params);
}

inline GLint QOpenGLFunctions_3_3_Core::glGetAttribLocation(GLuint program, const GLchar *name)
{
    return d_2_0_Core->f.GetAttribLocation(program, name);
}

inline void QOpenGLFunctions_3_3_Core::glGetAttachedShaders(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj)
{
    d_2_0_Core->f.GetAttachedShaders(program, maxCount, count, obj);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveUniform(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
    d_2_0_Core->f.GetActiveUniform(program, index, bufSize, length, size, type, name);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveAttrib(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name)
{
    d_2_0_Core->f.GetActiveAttrib(program, index, bufSize, length, size, type, name);
}

inline void QOpenGLFunctions_3_3_Core::glEnableVertexAttribArray(GLuint index)
{
    d_2_0_Core->f.EnableVertexAttribArray(index);
}

inline void QOpenGLFunctions_3_3_Core::glDisableVertexAttribArray(GLuint index)
{
    d_2_0_Core->f.DisableVertexAttribArray(index);
}

inline void QOpenGLFunctions_3_3_Core::glDetachShader(GLuint program, GLuint shader)
{
    d_2_0_Core->f.DetachShader(program, shader);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteShader(GLuint shader)
{
    d_2_0_Core->f.DeleteShader(shader);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteProgram(GLuint program)
{
    d_2_0_Core->f.DeleteProgram(program);
}

inline GLuint QOpenGLFunctions_3_3_Core::glCreateShader(GLenum type)
{
    return d_2_0_Core->f.CreateShader(type);
}

inline GLuint QOpenGLFunctions_3_3_Core::glCreateProgram()
{
    return d_2_0_Core->f.CreateProgram();
}

inline void QOpenGLFunctions_3_3_Core::glCompileShader(GLuint shader)
{
    d_2_0_Core->f.CompileShader(shader);
}

inline void QOpenGLFunctions_3_3_Core::glBindAttribLocation(GLuint program, GLuint index, const GLchar *name)
{
    d_2_0_Core->f.BindAttribLocation(program, index, name);
}

inline void QOpenGLFunctions_3_3_Core::glAttachShader(GLuint program, GLuint shader)
{
    d_2_0_Core->f.AttachShader(program, shader);
}

inline void QOpenGLFunctions_3_3_Core::glStencilMaskSeparate(GLenum face, GLuint mask)
{
    d_2_0_Core->f.StencilMaskSeparate(face, mask);
}

inline void QOpenGLFunctions_3_3_Core::glStencilFuncSeparate(GLenum face, GLenum func, GLint ref, GLuint mask)
{
    d_2_0_Core->f.StencilFuncSeparate(face, func, ref, mask);
}

inline void QOpenGLFunctions_3_3_Core::glStencilOpSeparate(GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass)
{
    d_2_0_Core->f.StencilOpSeparate(face, sfail, dpfail, dppass);
}

inline void QOpenGLFunctions_3_3_Core::glDrawBuffers(GLsizei n, const GLenum *bufs)
{
    d_2_0_Core->f.DrawBuffers(n, bufs);
}

inline void QOpenGLFunctions_3_3_Core::glBlendEquationSeparate(GLenum modeRGB, GLenum modeAlpha)
{
    d_2_0_Core->f.BlendEquationSeparate(modeRGB, modeAlpha);
}


// OpenGL 2.1 core functions
inline void QOpenGLFunctions_3_3_Core::glUniformMatrix4x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix4x3fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix3x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix3x4fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix4x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix4x2fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix2x4fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix2x4fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix3x2fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix3x2fv(location, count, transpose, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniformMatrix2x3fv(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value)
{
    d_2_1_Core->f.UniformMatrix2x3fv(location, count, transpose, value);
}


// OpenGL 3.0 core functions
inline GLboolean QOpenGLFunctions_3_3_Core::glIsVertexArray(GLuint array)
{
    return d_3_0_Core->f.IsVertexArray(array);
}

inline void QOpenGLFunctions_3_3_Core::glGenVertexArrays(GLsizei n, GLuint *arrays)
{
    d_3_0_Core->f.GenVertexArrays(n, arrays);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteVertexArrays(GLsizei n, const GLuint *arrays)
{
    d_3_0_Core->f.DeleteVertexArrays(n, arrays);
}

inline void QOpenGLFunctions_3_3_Core::glBindVertexArray(GLuint array)
{
    d_3_0_Core->f.BindVertexArray(array);
}

inline void QOpenGLFunctions_3_3_Core::glFlushMappedBufferRange(GLenum target, GLintptr offset, GLsizeiptr length)
{
    d_3_0_Core->f.FlushMappedBufferRange(target, offset, length);
}

inline GLvoid* QOpenGLFunctions_3_3_Core::glMapBufferRange(GLenum target, GLintptr offset, GLsizeiptr length, GLbitfield access)
{
    return d_3_0_Core->f.MapBufferRange(target, offset, length, access);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferTextureLayer(GLenum target, GLenum attachment, GLuint texture, GLint level, GLint layer)
{
    d_3_0_Core->f.FramebufferTextureLayer(target, attachment, texture, level, layer);
}

inline void QOpenGLFunctions_3_3_Core::glRenderbufferStorageMultisample(GLenum target, GLsizei samples, GLenum internalformat, GLsizei width, GLsizei height)
{
    d_3_0_Core->f.RenderbufferStorageMultisample(target, samples, internalformat, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glBlitFramebuffer(GLint srcX0, GLint srcY0, GLint srcX1, GLint srcY1, GLint dstX0, GLint dstY0, GLint dstX1, GLint dstY1, GLbitfield mask, GLenum filter)
{
    d_3_0_Core->f.BlitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
}

inline void QOpenGLFunctions_3_3_Core::glGenerateMipmap(GLenum target)
{
    d_3_0_Core->f.GenerateMipmap(target);
}

inline void QOpenGLFunctions_3_3_Core::glGetFramebufferAttachmentParameteriv(GLenum target, GLenum attachment, GLenum pname, GLint *params)
{
    d_3_0_Core->f.GetFramebufferAttachmentParameteriv(target, attachment, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferRenderbuffer(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer)
{
    d_3_0_Core->f.FramebufferRenderbuffer(target, attachment, renderbuffertarget, renderbuffer);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferTexture3D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset)
{
    d_3_0_Core->f.FramebufferTexture3D(target, attachment, textarget, texture, level, zoffset);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferTexture2D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    d_3_0_Core->f.FramebufferTexture2D(target, attachment, textarget, texture, level);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferTexture1D(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level)
{
    d_3_0_Core->f.FramebufferTexture1D(target, attachment, textarget, texture, level);
}

inline GLenum QOpenGLFunctions_3_3_Core::glCheckFramebufferStatus(GLenum target)
{
    return d_3_0_Core->f.CheckFramebufferStatus(target);
}

inline void QOpenGLFunctions_3_3_Core::glGenFramebuffers(GLsizei n, GLuint *framebuffers)
{
    d_3_0_Core->f.GenFramebuffers(n, framebuffers);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteFramebuffers(GLsizei n, const GLuint *framebuffers)
{
    d_3_0_Core->f.DeleteFramebuffers(n, framebuffers);
}

inline void QOpenGLFunctions_3_3_Core::glBindFramebuffer(GLenum target, GLuint framebuffer)
{
    d_3_0_Core->f.BindFramebuffer(target, framebuffer);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsFramebuffer(GLuint framebuffer)
{
    return d_3_0_Core->f.IsFramebuffer(framebuffer);
}

inline void QOpenGLFunctions_3_3_Core::glGetRenderbufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    d_3_0_Core->f.GetRenderbufferParameteriv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glRenderbufferStorage(GLenum target, GLenum internalformat, GLsizei width, GLsizei height)
{
    d_3_0_Core->f.RenderbufferStorage(target, internalformat, width, height);
}

inline void QOpenGLFunctions_3_3_Core::glGenRenderbuffers(GLsizei n, GLuint *renderbuffers)
{
    d_3_0_Core->f.GenRenderbuffers(n, renderbuffers);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteRenderbuffers(GLsizei n, const GLuint *renderbuffers)
{
    d_3_0_Core->f.DeleteRenderbuffers(n, renderbuffers);
}

inline void QOpenGLFunctions_3_3_Core::glBindRenderbuffer(GLenum target, GLuint renderbuffer)
{
    d_3_0_Core->f.BindRenderbuffer(target, renderbuffer);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsRenderbuffer(GLuint renderbuffer)
{
    return d_3_0_Core->f.IsRenderbuffer(renderbuffer);
}

inline const GLubyte * QOpenGLFunctions_3_3_Core::glGetStringi(GLenum name, GLuint index)
{
    return d_3_0_Core->f.GetStringi(name, index);
}

inline void QOpenGLFunctions_3_3_Core::glClearBufferfi(GLenum buffer, GLint drawbuffer, GLfloat depth, GLint stencil)
{
    d_3_0_Core->f.ClearBufferfi(buffer, drawbuffer, depth, stencil);
}

inline void QOpenGLFunctions_3_3_Core::glClearBufferfv(GLenum buffer, GLint drawbuffer, const GLfloat *value)
{
    d_3_0_Core->f.ClearBufferfv(buffer, drawbuffer, value);
}

inline void QOpenGLFunctions_3_3_Core::glClearBufferuiv(GLenum buffer, GLint drawbuffer, const GLuint *value)
{
    d_3_0_Core->f.ClearBufferuiv(buffer, drawbuffer, value);
}

inline void QOpenGLFunctions_3_3_Core::glClearBufferiv(GLenum buffer, GLint drawbuffer, const GLint *value)
{
    d_3_0_Core->f.ClearBufferiv(buffer, drawbuffer, value);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexParameterIuiv(GLenum target, GLenum pname, GLuint *params)
{
    d_3_0_Core->f.GetTexParameterIuiv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetTexParameterIiv(GLenum target, GLenum pname, GLint *params)
{
    d_3_0_Core->f.GetTexParameterIiv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameterIuiv(GLenum target, GLenum pname, const GLuint *params)
{
    d_3_0_Core->f.TexParameterIuiv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glTexParameterIiv(GLenum target, GLenum pname, const GLint *params)
{
    d_3_0_Core->f.TexParameterIiv(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4uiv(GLint location, GLsizei count, const GLuint *value)
{
    d_3_0_Core->f.Uniform4uiv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3uiv(GLint location, GLsizei count, const GLuint *value)
{
    d_3_0_Core->f.Uniform3uiv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2uiv(GLint location, GLsizei count, const GLuint *value)
{
    d_3_0_Core->f.Uniform2uiv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1uiv(GLint location, GLsizei count, const GLuint *value)
{
    d_3_0_Core->f.Uniform1uiv(location, count, value);
}

inline void QOpenGLFunctions_3_3_Core::glUniform4ui(GLint location, GLuint v0, GLuint v1, GLuint v2, GLuint v3)
{
    d_3_0_Core->f.Uniform4ui(location, v0, v1, v2, v3);
}

inline void QOpenGLFunctions_3_3_Core::glUniform3ui(GLint location, GLuint v0, GLuint v1, GLuint v2)
{
    d_3_0_Core->f.Uniform3ui(location, v0, v1, v2);
}

inline void QOpenGLFunctions_3_3_Core::glUniform2ui(GLint location, GLuint v0, GLuint v1)
{
    d_3_0_Core->f.Uniform2ui(location, v0, v1);
}

inline void QOpenGLFunctions_3_3_Core::glUniform1ui(GLint location, GLuint v0)
{
    d_3_0_Core->f.Uniform1ui(location, v0);
}

inline GLint QOpenGLFunctions_3_3_Core::glGetFragDataLocation(GLuint program, const GLchar *name)
{
    return d_3_0_Core->f.GetFragDataLocation(program, name);
}

inline void QOpenGLFunctions_3_3_Core::glBindFragDataLocation(GLuint program, GLuint color, const GLchar *name)
{
    d_3_0_Core->f.BindFragDataLocation(program, color, name);
}

inline void QOpenGLFunctions_3_3_Core::glGetUniformuiv(GLuint program, GLint location, GLuint *params)
{
    d_3_0_Core->f.GetUniformuiv(program, location, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribIuiv(GLuint index, GLenum pname, GLuint *params)
{
    d_3_0_Core->f.GetVertexAttribIuiv(index, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetVertexAttribIiv(GLuint index, GLenum pname, GLint *params)
{
    d_3_0_Core->f.GetVertexAttribIiv(index, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribIPointer(GLuint index, GLint size, GLenum type, GLsizei stride, const GLvoid *pointer)
{
    d_3_0_Core->f.VertexAttribIPointer(index, size, type, stride, pointer);
}

inline void QOpenGLFunctions_3_3_Core::glEndConditionalRender()
{
    d_3_0_Core->f.EndConditionalRender();
}

inline void QOpenGLFunctions_3_3_Core::glBeginConditionalRender(GLuint id, GLenum mode)
{
    d_3_0_Core->f.BeginConditionalRender(id, mode);
}

inline void QOpenGLFunctions_3_3_Core::glClampColor(GLenum target, GLenum clamp)
{
    d_3_0_Core->f.ClampColor(target, clamp);
}

inline void QOpenGLFunctions_3_3_Core::glGetTransformFeedbackVarying(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name)
{
    d_3_0_Core->f.GetTransformFeedbackVarying(program, index, bufSize, length, size, type, name);
}

inline void QOpenGLFunctions_3_3_Core::glTransformFeedbackVaryings(GLuint program, GLsizei count, const GLchar* const *varyings, GLenum bufferMode)
{
    d_3_0_Core->f.TransformFeedbackVaryings(program, count, varyings, bufferMode);
}

inline void QOpenGLFunctions_3_3_Core::glBindBufferBase(GLenum target, GLuint index, GLuint buffer)
{
    d_3_0_Core->f.BindBufferBase(target, index, buffer);
}

inline void QOpenGLFunctions_3_3_Core::glBindBufferRange(GLenum target, GLuint index, GLuint buffer, GLintptr offset, GLsizeiptr size)
{
    d_3_0_Core->f.BindBufferRange(target, index, buffer, offset, size);
}

inline void QOpenGLFunctions_3_3_Core::glEndTransformFeedback()
{
    d_3_0_Core->f.EndTransformFeedback();
}

inline void QOpenGLFunctions_3_3_Core::glBeginTransformFeedback(GLenum primitiveMode)
{
    d_3_0_Core->f.BeginTransformFeedback(primitiveMode);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsEnabledi(GLenum target, GLuint index)
{
    return d_3_0_Core->f.IsEnabledi(target, index);
}

inline void QOpenGLFunctions_3_3_Core::glDisablei(GLenum target, GLuint index)
{
    d_3_0_Core->f.Disablei(target, index);
}

inline void QOpenGLFunctions_3_3_Core::glEnablei(GLenum target, GLuint index)
{
    d_3_0_Core->f.Enablei(target, index);
}

inline void QOpenGLFunctions_3_3_Core::glGetIntegeri_v(GLenum target, GLuint index, GLint *data)
{
    d_3_0_Core->f.GetIntegeri_v(target, index, data);
}

inline void QOpenGLFunctions_3_3_Core::glGetBooleani_v(GLenum target, GLuint index, GLboolean *data)
{
    d_3_0_Core->f.GetBooleani_v(target, index, data);
}

inline void QOpenGLFunctions_3_3_Core::glColorMaski(GLuint index, GLboolean r, GLboolean g, GLboolean b, GLboolean a)
{
    d_3_0_Core->f.ColorMaski(index, r, g, b, a);
}


// OpenGL 3.1 core functions
inline void QOpenGLFunctions_3_3_Core::glCopyBufferSubData(GLenum readTarget, GLenum writeTarget, GLintptr readOffset, GLintptr writeOffset, GLsizeiptr size)
{
    d_3_1_Core->f.CopyBufferSubData(readTarget, writeTarget, readOffset, writeOffset, size);
}

inline void QOpenGLFunctions_3_3_Core::glUniformBlockBinding(GLuint program, GLuint uniformBlockIndex, GLuint uniformBlockBinding)
{
    d_3_1_Core->f.UniformBlockBinding(program, uniformBlockIndex, uniformBlockBinding);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveUniformBlockName(GLuint program, GLuint uniformBlockIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformBlockName)
{
    d_3_1_Core->f.GetActiveUniformBlockName(program, uniformBlockIndex, bufSize, length, uniformBlockName);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveUniformBlockiv(GLuint program, GLuint uniformBlockIndex, GLenum pname, GLint *params)
{
    d_3_1_Core->f.GetActiveUniformBlockiv(program, uniformBlockIndex, pname, params);
}

inline GLuint QOpenGLFunctions_3_3_Core::glGetUniformBlockIndex(GLuint program, const GLchar *uniformBlockName)
{
    return d_3_1_Core->f.GetUniformBlockIndex(program, uniformBlockName);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveUniformName(GLuint program, GLuint uniformIndex, GLsizei bufSize, GLsizei *length, GLchar *uniformName)
{
    d_3_1_Core->f.GetActiveUniformName(program, uniformIndex, bufSize, length, uniformName);
}

inline void QOpenGLFunctions_3_3_Core::glGetActiveUniformsiv(GLuint program, GLsizei uniformCount, const GLuint *uniformIndices, GLenum pname, GLint *params)
{
    d_3_1_Core->f.GetActiveUniformsiv(program, uniformCount, uniformIndices, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetUniformIndices(GLuint program, GLsizei uniformCount, const GLchar* const *uniformNames, GLuint *uniformIndices)
{
    d_3_1_Core->f.GetUniformIndices(program, uniformCount, uniformNames, uniformIndices);
}

inline void QOpenGLFunctions_3_3_Core::glPrimitiveRestartIndex(GLuint index)
{
    d_3_1_Core->f.PrimitiveRestartIndex(index);
}

inline void QOpenGLFunctions_3_3_Core::glTexBuffer(GLenum target, GLenum internalformat, GLuint buffer)
{
    d_3_1_Core->f.TexBuffer(target, internalformat, buffer);
}

inline void QOpenGLFunctions_3_3_Core::glDrawElementsInstanced(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount)
{
    d_3_1_Core->f.DrawElementsInstanced(mode, count, type, indices, instancecount);
}

inline void QOpenGLFunctions_3_3_Core::glDrawArraysInstanced(GLenum mode, GLint first, GLsizei count, GLsizei instancecount)
{
    d_3_1_Core->f.DrawArraysInstanced(mode, first, count, instancecount);
}


// OpenGL 3.2 core functions
inline void QOpenGLFunctions_3_3_Core::glSampleMaski(GLuint index, GLbitfield mask)
{
    d_3_2_Core->f.SampleMaski(index, mask);
}

inline void QOpenGLFunctions_3_3_Core::glGetMultisamplefv(GLenum pname, GLuint index, GLfloat *val)
{
    d_3_2_Core->f.GetMultisamplefv(pname, index, val);
}

inline void QOpenGLFunctions_3_3_Core::glTexImage3DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLboolean fixedsamplelocations)
{
    d_3_2_Core->f.TexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations);
}

inline void QOpenGLFunctions_3_3_Core::glTexImage2DMultisample(GLenum target, GLsizei samples, GLint internalformat, GLsizei width, GLsizei height, GLboolean fixedsamplelocations)
{
    d_3_2_Core->f.TexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations);
}

inline void QOpenGLFunctions_3_3_Core::glGetSynciv(GLsync sync, GLenum pname, GLsizei bufSize, GLsizei *length, GLint *values)
{
    d_3_2_Core->f.GetSynciv(sync, pname, bufSize, length, values);
}

inline void QOpenGLFunctions_3_3_Core::glGetInteger64v(GLenum pname, GLint64 *params)
{
    d_3_2_Core->f.GetInteger64v(pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    d_3_2_Core->f.WaitSync(sync, flags, timeout);
}

inline GLenum QOpenGLFunctions_3_3_Core::glClientWaitSync(GLsync sync, GLbitfield flags, GLuint64 timeout)
{
    return d_3_2_Core->f.ClientWaitSync(sync, flags, timeout);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteSync(GLsync sync)
{
    d_3_2_Core->f.DeleteSync(sync);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsSync(GLsync sync)
{
    return d_3_2_Core->f.IsSync(sync);
}

inline GLsync QOpenGLFunctions_3_3_Core::glFenceSync(GLenum condition, GLbitfield flags)
{
    return d_3_2_Core->f.FenceSync(condition, flags);
}

inline void QOpenGLFunctions_3_3_Core::glProvokingVertex(GLenum mode)
{
    d_3_2_Core->f.ProvokingVertex(mode);
}

inline void QOpenGLFunctions_3_3_Core::glMultiDrawElementsBaseVertex(GLenum mode, const GLsizei *count, GLenum type, const GLvoid* const *indices, GLsizei drawcount, const GLint *basevertex)
{
    d_3_2_Core->f.MultiDrawElementsBaseVertex(mode, count, type, indices, drawcount, basevertex);
}

inline void QOpenGLFunctions_3_3_Core::glDrawElementsInstancedBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLsizei instancecount, GLint basevertex)
{
    d_3_2_Core->f.DrawElementsInstancedBaseVertex(mode, count, type, indices, instancecount, basevertex);
}

inline void QOpenGLFunctions_3_3_Core::glDrawRangeElementsBaseVertex(GLenum mode, GLuint start, GLuint end, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
    d_3_2_Core->f.DrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex);
}

inline void QOpenGLFunctions_3_3_Core::glDrawElementsBaseVertex(GLenum mode, GLsizei count, GLenum type, const GLvoid *indices, GLint basevertex)
{
    d_3_2_Core->f.DrawElementsBaseVertex(mode, count, type, indices, basevertex);
}

inline void QOpenGLFunctions_3_3_Core::glFramebufferTexture(GLenum target, GLenum attachment, GLuint texture, GLint level)
{
    d_3_2_Core->f.FramebufferTexture(target, attachment, texture, level);
}

inline void QOpenGLFunctions_3_3_Core::glGetBufferParameteri64v(GLenum target, GLenum pname, GLint64 *params)
{
    d_3_2_Core->f.GetBufferParameteri64v(target, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetInteger64i_v(GLenum target, GLuint index, GLint64 *data)
{
    d_3_2_Core->f.GetInteger64i_v(target, index, data);
}


// OpenGL 3.3 core functions
inline void QOpenGLFunctions_3_3_Core::glVertexAttribP4uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    d_3_3_Core->f.VertexAttribP4uiv(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP4ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    d_3_3_Core->f.VertexAttribP4ui(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP3uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    d_3_3_Core->f.VertexAttribP3uiv(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP3ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    d_3_3_Core->f.VertexAttribP3ui(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP2uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    d_3_3_Core->f.VertexAttribP2uiv(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP2ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    d_3_3_Core->f.VertexAttribP2ui(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP1uiv(GLuint index, GLenum type, GLboolean normalized, const GLuint *value)
{
    d_3_3_Core->f.VertexAttribP1uiv(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribP1ui(GLuint index, GLenum type, GLboolean normalized, GLuint value)
{
    d_3_3_Core->f.VertexAttribP1ui(index, type, normalized, value);
}

inline void QOpenGLFunctions_3_3_Core::glGetQueryObjectui64v(GLuint id, GLenum pname, GLuint64 *params)
{
    d_3_3_Core->f.GetQueryObjectui64v(id, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetQueryObjecti64v(GLuint id, GLenum pname, GLint64 *params)
{
    d_3_3_Core->f.GetQueryObjecti64v(id, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glQueryCounter(GLuint id, GLenum target)
{
    d_3_3_Core->f.QueryCounter(id, target);
}

inline void QOpenGLFunctions_3_3_Core::glGetSamplerParameterIuiv(GLuint sampler, GLenum pname, GLuint *params)
{
    d_3_3_Core->f.GetSamplerParameterIuiv(sampler, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetSamplerParameterfv(GLuint sampler, GLenum pname, GLfloat *params)
{
    d_3_3_Core->f.GetSamplerParameterfv(sampler, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetSamplerParameterIiv(GLuint sampler, GLenum pname, GLint *params)
{
    d_3_3_Core->f.GetSamplerParameterIiv(sampler, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glGetSamplerParameteriv(GLuint sampler, GLenum pname, GLint *params)
{
    d_3_3_Core->f.GetSamplerParameteriv(sampler, pname, params);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameterIuiv(GLuint sampler, GLenum pname, const GLuint *param)
{
    d_3_3_Core->f.SamplerParameterIuiv(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameterIiv(GLuint sampler, GLenum pname, const GLint *param)
{
    d_3_3_Core->f.SamplerParameterIiv(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameterfv(GLuint sampler, GLenum pname, const GLfloat *param)
{
    d_3_3_Core->f.SamplerParameterfv(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameterf(GLuint sampler, GLenum pname, GLfloat param)
{
    d_3_3_Core->f.SamplerParameterf(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameteriv(GLuint sampler, GLenum pname, const GLint *param)
{
    d_3_3_Core->f.SamplerParameteriv(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glSamplerParameteri(GLuint sampler, GLenum pname, GLint param)
{
    d_3_3_Core->f.SamplerParameteri(sampler, pname, param);
}

inline void QOpenGLFunctions_3_3_Core::glBindSampler(GLuint unit, GLuint sampler)
{
    d_3_3_Core->f.BindSampler(unit, sampler);
}

inline GLboolean QOpenGLFunctions_3_3_Core::glIsSampler(GLuint sampler)
{
    return d_3_3_Core->f.IsSampler(sampler);
}

inline void QOpenGLFunctions_3_3_Core::glDeleteSamplers(GLsizei count, const GLuint *samplers)
{
    d_3_3_Core->f.DeleteSamplers(count, samplers);
}

inline void QOpenGLFunctions_3_3_Core::glGenSamplers(GLsizei count, GLuint *samplers)
{
    d_3_3_Core->f.GenSamplers(count, samplers);
}

inline GLint QOpenGLFunctions_3_3_Core::glGetFragDataIndex(GLuint program, const GLchar *name)
{
    return d_3_3_Core->f.GetFragDataIndex(program, name);
}

inline void QOpenGLFunctions_3_3_Core::glBindFragDataLocationIndexed(GLuint program, GLuint colorNumber, GLuint index, const GLchar *name)
{
    d_3_3_Core->f.BindFragDataLocationIndexed(program, colorNumber, index, name);
}

inline void QOpenGLFunctions_3_3_Core::glVertexAttribDivisor(GLuint index, GLuint divisor)
{
    d_3_3_Core->f.VertexAttribDivisor(index, divisor);
}



QT_END_NAMESPACE

#endif // QT_NO_OPENGL && !QT_CONFIG(opengles2)

#endif
