/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.modules;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.jscomp.modules.AutoValue_Export;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.Node;
import javax.annotation.Nullable;

public abstract class Export {
    public static final String DEFAULT_EXPORT_NAME = "*default*";
    static final String DEFAULT = "default";
    public static final String NAMESPACE = "*exports*";

    Export() {
    }

    static Builder builder() {
        return new AutoValue_Export.Builder().mutated(false);
    }

    abstract Builder toBuilder();

    final Export mutatedCopy() {
        return this.toBuilder().mutated(true).autoBuild();
    }

    @Nullable
    public abstract String exportName();

    @Nullable
    public abstract String moduleRequest();

    @Nullable
    public abstract String importName();

    @Nullable
    public abstract String localName();

    @Nullable
    public abstract ModuleLoader.ModulePath modulePath();

    @Nullable
    public abstract Node exportNode();

    @Nullable
    public abstract Node nameNode();

    public abstract ModuleMetadataMap.ModuleMetadata moduleMetadata();

    @Nullable
    public abstract String closureNamespace();

    public abstract boolean mutated();

    static abstract class Builder {
        Builder() {
        }

        abstract Builder exportName(@Nullable String var1);

        abstract Builder moduleRequest(@Nullable String var1);

        abstract Builder importName(@Nullable String var1);

        abstract Builder localName(@Nullable String var1);

        abstract Builder modulePath(@Nullable ModuleLoader.ModulePath var1);

        abstract Builder exportNode(@Nullable Node var1);

        abstract Builder nameNode(@Nullable Node var1);

        abstract Builder moduleMetadata(ModuleMetadataMap.ModuleMetadata var1);

        abstract Builder closureNamespace(@Nullable String var1);

        abstract Builder mutated(boolean var1);

        abstract Export autoBuild();

        final Export build() {
            Export e = this.autoBuild();
            if (e.moduleMetadata().isEs6Module()) {
                this.validateEsModule(e);
            } else if (e.moduleMetadata().isGoogModule()) {
                Builder.validateGoogModule(e);
            } else {
                Builder.validateOtherModule(e);
            }
            return e;
        }

        private void validateEsModule(Export e) {
            Preconditions.checkState(e.closureNamespace() == null);
            Preconditions.checkState(!"*".equals(e.importName()) || e.moduleRequest() != null && e.exportName() == null && e.localName() == null, "Star exports should not have exported / local names.");
            Preconditions.checkState(e.localName() == null || e.moduleRequest() == null, "Local exports should not have module requests.");
            Preconditions.checkState(e.moduleRequest() == null || e.localName() == null, "Reexports should not have local names.");
            Preconditions.checkState(e.moduleRequest() == null || e.importName() != null, "Reexports should have import names.");
            Preconditions.checkState(e.importName() == null || e.moduleRequest() != null, "Exports with an import name should be a reexport.");
        }

        private static void validateGoogModule(Export e) {
            Preconditions.checkState(e.closureNamespace() != null, "Exports should be associated with a namespace");
            Preconditions.checkState(e.exportName() != null, "Exports should be named");
            Preconditions.checkState(e.exportNode() != null, "Exports should have a node");
            Preconditions.checkState(e.localName() == null, "goog.module Exports don't set a localName");
            Preconditions.checkState(e.moduleRequest() == null, "goog modules cannot export from other modules");
        }

        private static void validateOtherModule(Export e) {
            Preconditions.checkNotNull(e.exportName());
            Preconditions.checkState(e.exportNode() == null);
            Preconditions.checkState(e.localName() == null);
            Preconditions.checkState(e.moduleRequest() == null);
            Preconditions.checkState(e.importName() == null);
            Preconditions.checkState(e.nameNode() == null);
        }
    }
}

