/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerInput;
import com.google.javascript.jscomp.Es6RewriteModules;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.ProcessCommonJSModules;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.deps.DependencyInfo;
import com.google.javascript.jscomp.deps.ModuleLoader;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

public class FindModuleDependencies
implements NodeTraversal.ScopedCallback {
    private final AbstractCompiler compiler;
    private final boolean supportsEs6Modules;
    private final boolean supportsCommonJsModules;
    private CompilerInput.ModuleType moduleType = CompilerInput.ModuleType.NONE;
    private Scope dynamicImportScope = null;
    private final ImmutableMap<String, String> inputPathByWebpackId;

    FindModuleDependencies(AbstractCompiler compiler, boolean supportsEs6Modules, boolean supportsCommonJsModules, ImmutableMap<String, String> inputPathByWebpackId) {
        this.compiler = compiler;
        this.supportsEs6Modules = supportsEs6Modules;
        this.supportsCommonJsModules = supportsCommonJsModules;
        this.inputPathByWebpackId = inputPathByWebpackId;
    }

    public void process(Node root) {
        CompilerInput input;
        Preconditions.checkArgument(root.isScript());
        if (Es6RewriteModules.isEs6ModuleRoot(root)) {
            this.moduleType = CompilerInput.ModuleType.ES6;
        }
        if ((input = this.compiler.getInput(root.getInputId())).getRequires().contains(DependencyInfo.Require.BASE)) {
            input.addOrderedRequire(DependencyInfo.Require.BASE);
        }
        NodeTraversal.traverse(this.compiler, root, this);
        if (this.moduleType == CompilerInput.ModuleType.ES6) {
            this.convertToEs6Module(root, true);
        } else if (this.moduleType == CompilerInput.ModuleType.NONE && this.inputPathByWebpackId != null && this.inputPathByWebpackId.containsValue(input.getPath().toString())) {
            this.moduleType = CompilerInput.ModuleType.IMPORTED_SCRIPT;
        }
        input.addProvide(input.getPath().toModuleName());
        input.setJsModuleType(this.moduleType);
        input.setHasFullParseDependencyInfo(true);
    }

    @Override
    public boolean shouldTraverse(NodeTraversal t, Node n, Node parent) {
        if (this.supportsCommonJsModules && n.isFunction() && ProcessCommonJSModules.isCommonJsDynamicImportCallback(n, this.compiler.getOptions().moduleResolutionMode) && this.dynamicImportScope == null) {
            this.dynamicImportScope = t.getScope();
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        Node maybeGetProp;
        ModuleLoader.ResolutionMode resolutionMode = this.compiler.getOptions().moduleResolutionMode;
        if ((parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) && n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
            this.moduleType = CompilerInput.ModuleType.GOOG;
            return;
        }
        if (this.supportsEs6Modules && n.isExport()) {
            this.moduleType = CompilerInput.ModuleType.ES6;
            if (!n.getBooleanProp(Node.EXPORT_DEFAULT) && n.hasTwoChildren()) {
                this.addEs6ModuleImportToGraph(t, n);
            }
        } else if (this.supportsEs6Modules && n.isImport()) {
            this.moduleType = CompilerInput.ModuleType.ES6;
            this.addEs6ModuleImportToGraph(t, n);
        } else if (this.supportsCommonJsModules) {
            if (this.moduleType != CompilerInput.ModuleType.GOOG && ProcessCommonJSModules.isCommonJsExport(t, n, resolutionMode)) {
                this.moduleType = CompilerInput.ModuleType.COMMONJS;
            } else if (ProcessCommonJSModules.isCommonJsImport(n, resolutionMode)) {
                String path = ProcessCommonJSModules.getCommonJsImportPath(n, resolutionMode);
                ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(path, n.getSourceFileName(), n.getLineno(), n.getCharno());
                if (modulePath != null) {
                    if (this.dynamicImportScope != null || ProcessCommonJSModules.isCommonJsDynamicImportCallback(NodeUtil.getEnclosingFunction(n), resolutionMode)) {
                        t.getInput().addDynamicRequire(modulePath.toModuleName());
                    } else {
                        t.getInput().addOrderedRequire(DependencyInfo.Require.commonJs(modulePath.toModuleName(), path));
                    }
                }
            }
        }
        if (parent != null && (parent.isExprResult() || !t.inGlobalHoistScope()) && n.isCall() && n.getFirstChild().matchesQualifiedName("goog.require") && n.getSecondChild() != null && n.getSecondChild().isString()) {
            String namespace = n.getSecondChild().getString();
            if (namespace.startsWith("goog.")) {
                t.getInput().addOrderedRequire(DependencyInfo.Require.BASE);
            }
            t.getInput().addOrderedRequire(DependencyInfo.Require.googRequireSymbol(namespace));
        }
    }

    @Override
    public void enterScope(NodeTraversal t) {
    }

    @Override
    public void exitScope(NodeTraversal t) {
        if (t.getScope() == this.dynamicImportScope) {
            this.dynamicImportScope = null;
        }
    }

    private void addEs6ModuleImportToGraph(NodeTraversal t, Node n) {
        String moduleName = this.getEs6ModuleNameFromImportNode(t, n);
        if (moduleName.startsWith("goog.")) {
            t.getInput().addOrderedRequire(DependencyInfo.Require.BASE);
        }
        t.getInput().addOrderedRequire(DependencyInfo.Require.es6Import(moduleName, n.getLastChild().getString()));
    }

    private String getEs6ModuleNameFromImportNode(NodeTraversal t, Node n) {
        String importName = n.getLastChild().getString();
        boolean isNamespaceImport = importName.startsWith("goog:");
        if (isNamespaceImport) {
            return importName.substring("goog:".length());
        }
        ModuleLoader.ModulePath modulePath = t.getInput().getPath().resolveJsModule(importName, n.getSourceFileName(), n.getLineno(), n.getCharno());
        if (modulePath == null) {
            modulePath = t.getInput().getPath().resolveModuleAsPath(importName);
        }
        return modulePath.toModuleName();
    }

    private boolean convertToEs6Module(Node root, boolean skipGoogProvideModuleCheck) {
        if (Es6RewriteModules.isEs6ModuleRoot(root)) {
            return true;
        }
        if (!skipGoogProvideModuleCheck) {
            FindGoogProvideOrGoogModule finder = new FindGoogProvideOrGoogModule();
            NodeTraversal.traverse(this.compiler, root, finder);
            if (finder.isFound()) {
                return false;
            }
        }
        Node moduleNode = new Node(Token.MODULE_BODY).srcref(root);
        moduleNode.addChildrenToBack(root.removeChildren());
        root.addChildToBack(moduleNode);
        return true;
    }

    private static class FindGoogProvideOrGoogModule
    extends NodeTraversal.AbstractPreOrderCallback {
        private boolean found;

        private FindGoogProvideOrGoogModule() {
        }

        boolean isFound() {
            return this.found;
        }

        @Override
        public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
            if (this.found) {
                return false;
            }
            if (parent == null || NodeUtil.isControlStructure(parent) || NodeUtil.isStatementBlock(parent)) {
                Node maybeGetProp;
                if (n.isExprResult() && (maybeGetProp = n.getFirstFirstChild()) != null && (maybeGetProp.matchesQualifiedName("goog.provide") || maybeGetProp.matchesQualifiedName("goog.module"))) {
                    this.found = true;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

