/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;

class Es6TemplateLiterals {
    private static final String TEMPLATELIT_VAR = "$jscomp$templatelit$";
    private final AstFactory astFactory;
    private final AbstractCompiler compiler;
    private final JSTypeRegistry registry;

    Es6TemplateLiterals(AbstractCompiler compiler) {
        this.compiler = compiler;
        this.astFactory = compiler.createAstFactory();
        this.registry = compiler.getTypeRegistry();
    }

    void visitTemplateLiteral(NodeTraversal t, Node n) {
        int length = n.getChildCount();
        if (length == 0) {
            n.replaceWith(this.astFactory.createString("\"\""));
        } else {
            Node first = n.removeFirstChild();
            Preconditions.checkState(first.isTemplateLitString() && first.getCookedString() != null);
            Node firstStr = this.astFactory.createString(first.getCookedString());
            if (length == 1) {
                n.replaceWith(firstStr);
            } else {
                Node add = Es6ToEs3Util.withType(IR.add(firstStr, n.removeFirstChild().removeFirstChild()), n.getJSType());
                for (int i = 2; i < length; ++i) {
                    Node child = n.removeFirstChild();
                    if (child.isTemplateLitString()) {
                        Preconditions.checkState(child.getCookedString() != null);
                        if (child.getCookedString().isEmpty()) continue;
                        if (i == 2 && first.getCookedString().isEmpty()) {
                            add = add.getSecondChild().detach();
                        }
                    }
                    add = Es6ToEs3Util.withType(IR.add(add, child.isTemplateLitString() ? this.astFactory.createString(child.getCookedString()) : child.removeFirstChild()), n.getJSType());
                }
                n.replaceWith(add.useSourceInfoIfMissingFromForTree(n));
            }
        }
        t.reportCodeChange();
    }

    void visitTaggedTemplateLiteral(NodeTraversal t, Node n, boolean addTypes) {
        Node defineRaw;
        JSType stringType = Es6ToEs3Util.createType(addTypes, this.registry, JSTypeNative.STRING_TYPE);
        JSType arrayType = Es6ToEs3Util.createGenericType(addTypes, this.registry, JSTypeNative.ARRAY_TYPE, stringType);
        JSType templateArrayType = Es6ToEs3Util.createType(addTypes, this.registry, JSTypeNative.I_TEMPLATE_ARRAY_TYPE);
        Node templateLit = n.getLastChild();
        Node cooked = this.createCookedStringArray(templateLit, templateArrayType);
        Node siteObject = Es6ToEs3Util.withType(cooked, templateArrayType);
        Node callsiteId = this.astFactory.createName(TEMPLATELIT_VAR + this.compiler.getUniqueNameIdSupplier().get(), templateArrayType);
        Node var = IR.var(callsiteId, siteObject).useSourceInfoIfMissingFromForTree(n);
        Node script = NodeUtil.getEnclosingScript(n);
        script.addChildToFront(var);
        t.reportCodeChange(var);
        if (Es6TemplateLiterals.cookedAndRawStringsSame(templateLit)) {
            defineRaw = IR.exprResult(this.astFactory.createAssign(this.astFactory.createGetProp(callsiteId.cloneNode(), "raw"), this.astFactory.createCall(this.astFactory.createGetProp(callsiteId.cloneNode(), "slice"), new Node[0]))).useSourceInfoIfMissingFromForTree(n);
        } else {
            Node raw = this.createRawStringArray(templateLit, arrayType);
            defineRaw = IR.exprResult(this.astFactory.createAssign(this.astFactory.createGetProp(callsiteId.cloneNode(), "raw"), raw)).useSourceInfoIfMissingFromForTree(n);
        }
        script.addChildAfter(defineRaw, var);
        Node call = Es6ToEs3Util.withType(IR.call(n.removeFirstChild(), callsiteId.cloneNode()), n.getJSType());
        for (Node child = templateLit.getFirstChild(); child != null; child = child.getNext()) {
            if (child.isTemplateLitString()) continue;
            call.addChildToBack(child.removeFirstChild());
        }
        call.useSourceInfoIfMissingFromForTree(templateLit);
        call.putBooleanProp(Node.FREE_CALL, !call.getFirstChild().isGetProp());
        n.replaceWith(call);
        t.reportCodeChange();
    }

    private Node createRawStringArray(Node n, JSType arrayType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), arrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            array.addChildToBack(this.astFactory.createString(child.getRawString()));
        }
        return array;
    }

    private Node createCookedStringArray(Node n, JSType templateArrayType) {
        Node array = Es6ToEs3Util.withType(IR.arraylit(new Node[0]), templateArrayType);
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString()) continue;
            if (child.getCookedString() != null) {
                array.addChildToBack(this.astFactory.createString(child.getCookedString()));
                continue;
            }
            array.addChildToBack(this.astFactory.createVoid(this.astFactory.createNumber(0.0)));
        }
        return array;
    }

    private static boolean cookedAndRawStringsSame(Node n) {
        for (Node child = n.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isTemplateLitString() || child.getCookedString() != null && child.getCookedString().equals(child.getRawString())) continue;
            return false;
        }
        return true;
    }
}

