/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.rhino.jstype;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.javascript.rhino.jstype.ObjectType;
import com.google.javascript.rhino.jstype.Property;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;

class PropertyMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final PropertyMap EMPTY_MAP = new PropertyMap(ImmutableMap.of());
    private ObjectType parentSource = null;
    private final Map<String, Property> properties;

    PropertyMap() {
        this(new TreeMap<String, Property>());
    }

    private PropertyMap(Map<String, Property> underlyingMap) {
        this.properties = underlyingMap;
    }

    static PropertyMap immutableEmptyMap() {
        return EMPTY_MAP;
    }

    void setParentSource(ObjectType ownerType) {
        if (this != EMPTY_MAP) {
            this.parentSource = ownerType;
        }
    }

    PropertyMap getPrimaryParent() {
        if (this.parentSource == null) {
            return null;
        }
        ObjectType iProto = this.parentSource.getImplicitPrototype();
        return iProto == null ? null : iProto.getPropertyMap();
    }

    private Iterable<ObjectType> getSecondaryParentObjects() {
        if (this.parentSource == null) {
            return ImmutableList.of();
        }
        if (this.parentSource.getConstructor() != null && this.parentSource.getConstructor().isAbstract()) {
            return this.parentSource.getConstructor().getOwnImplementedInterfaces();
        }
        return this.parentSource.getCtorExtendedInterfaces();
    }

    Property.OwnedProperty findTopMost(String name) {
        PropertyMap map;
        Property.OwnedProperty found = null;
        for (map = this; map != null; map = map.getPrimaryParent()) {
            Property prop = map.properties.get(name);
            if (prop == null) continue;
            found = new Property.OwnedProperty(map.parentSource, prop);
        }
        if (found != null) {
            return found;
        }
        for (map = this; map != null; map = map.getPrimaryParent()) {
            for (ObjectType o : map.getSecondaryParentObjects()) {
                Property.OwnedProperty e;
                PropertyMap parent = o.getPropertyMap();
                if (parent == null || (e = parent.findTopMost(name)) == null) continue;
                return e;
            }
        }
        return null;
    }

    Property.OwnedProperty findClosest(String name) {
        PropertyMap map;
        for (map = this; map != null; map = map.getPrimaryParent()) {
            Property prop = map.properties.get(name);
            if (prop == null) continue;
            return new Property.OwnedProperty(map.parentSource, prop);
        }
        for (map = this; map != null; map = map.getPrimaryParent()) {
            for (ObjectType o : map.getSecondaryParentObjects()) {
                Property.OwnedProperty e;
                PropertyMap parent = o.getPropertyMap();
                if (parent == null || (e = parent.findClosest(name)) == null) continue;
                return e;
            }
        }
        return null;
    }

    Property getOwnProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    int getPropertiesCount() {
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent == null) {
            return this.properties.size();
        }
        HashSet<String> props = new HashSet<String>();
        this.collectPropertyNames(props);
        return props.size();
    }

    Set<String> getOwnPropertyNames() {
        return this.properties.keySet();
    }

    void collectPropertyNames(Set<String> props) {
        Set<PropertyMap> identitySet = Sets.newIdentityHashSet();
        this.collectPropertyNamesHelper(props, identitySet);
    }

    private void collectPropertyNamesHelper(Set<String> props, Set<PropertyMap> cache) {
        if (!cache.add(this)) {
            return;
        }
        props.addAll(this.properties.keySet());
        PropertyMap primaryParent = this.getPrimaryParent();
        if (primaryParent != null) {
            primaryParent.collectPropertyNamesHelper(props, cache);
        }
        for (ObjectType o : this.getSecondaryParentObjects()) {
            PropertyMap p = o.getPropertyMap();
            if (p == null) continue;
            p.collectPropertyNamesHelper(props, cache);
        }
    }

    boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    void putProperty(String name, Property newProp) {
        Property oldProp = this.properties.get(name);
        if (oldProp != null) {
            newProp.setJSDocInfo(oldProp.getJSDocInfo());
        }
        this.properties.put(name, newProp);
    }

    Iterable<Property> values() {
        return this.properties.values();
    }

    public int hashCode() {
        return Objects.hashCode(this.properties.keySet());
    }
}

