/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp.lint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.HashSet;

public class CheckNullabilityModifiers
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    public static final DiagnosticType MISSING_NULLABILITY_MODIFIER_JSDOC = DiagnosticType.disabled("JSC_MISSING_NULLABILITY_MODIFIER_JSDOC", "{0} is a reference type with no nullability modifier, which is disallowed by the style guide.\nPlease add a '!' to make it explicitly non-nullable, or a '?' to make it explicitly nullable.");
    public static final DiagnosticType NULL_MISSING_NULLABILITY_MODIFIER_JSDOC = DiagnosticType.disabled("JSC_NULL_MISSING_NULLABILITY_MODIFIER_JSDOC", "{0} is a reference type with no nullability modifier that is explicitly set to null.\nAdd a '?' to make it explicitly nullable.");
    public static final DiagnosticType REDUNDANT_NULLABILITY_MODIFIER_JSDOC = DiagnosticType.disabled("JSC_REDUNDANT_NULLABILITY_MODIFIER_JSDOC", "{0} is a non-reference type which is already non-nullable.\nPlease remove the redundant '!', which is disallowed by the style guide.");
    private static final ImmutableSet<String> PRIMITIVE_TYPE_NAMES = ImmutableSet.of("boolean", "number", "string", "symbol", "undefined", "void", new String[]{"null"});
    private final AbstractCompiler compiler;
    private final HashSet<Node> redundantCandidates = new HashSet();
    private final HashSet<Node> missingCandidates = new HashSet();
    private final HashSet<Node> nullMissingCandidates = new HashSet();
    private final HashSet<String> templateTypeNames = new HashSet();

    public CheckNullabilityModifiers(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverseRoots(this.compiler, this, externs, root);
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        JSDocInfo info = n.getJSDocInfo();
        if (info != null) {
            this.templateTypeNames.addAll(info.getTemplateTypeNames());
            this.templateTypeNames.addAll(info.getTypeTransformations().keySet());
            if (info.hasType()) {
                this.handleHasType(info.getType(), n);
            }
            for (String param : info.getParameterNames()) {
                if (!info.hasParameterType(param)) continue;
                this.visitTypeExpression(info.getParameterType(param), false);
            }
            if (info.hasReturnType()) {
                this.visitTypeExpression(info.getReturnType(), false);
            }
            if (info.hasEnumParameterType()) {
                this.visitTypeExpression(info.getEnumParameterType(), false);
            }
            if (info.hasTypedefType()) {
                this.visitTypeExpression(info.getTypedefType(), false);
            }
            if (info.hasThisType()) {
                this.visitTypeExpression(info.getThisType(), true);
            }
            for (JSTypeExpression expr : info.getThrownTypes()) {
                this.visitTypeExpression(expr, false);
            }
        }
        if (n.isScript()) {
            this.report(t);
            this.redundantCandidates.clear();
            this.missingCandidates.clear();
            this.nullMissingCandidates.clear();
            this.templateTypeNames.clear();
            return;
        }
    }

    private void handleHasType(JSTypeExpression expr, Node n) {
        Node rValue;
        if (NodeUtil.isNameDeclOrSimpleAssignLhs(n.getFirstChild(), n) && (rValue = NodeUtil.getRValueOfLValue(n.getFirstChild())) != null && rValue.isNull()) {
            this.visitTypeExpression(expr, false, rValue);
            return;
        }
        this.visitTypeExpression(expr, false);
    }

    private void report(NodeTraversal t) {
        for (Node n : this.missingCandidates) {
            if (!this.shouldReport(n)) continue;
            t.report(n, MISSING_NULLABILITY_MODIFIER_JSDOC, CheckNullabilityModifiers.getReportedTypeName(n));
        }
        for (Node n : this.nullMissingCandidates) {
            if (!this.shouldReport(n)) continue;
            t.report(n, NULL_MISSING_NULLABILITY_MODIFIER_JSDOC, CheckNullabilityModifiers.getReportedTypeName(n));
        }
        for (Node n : this.redundantCandidates) {
            if (!this.shouldReport(n)) continue;
            t.report(n.getParent(), REDUNDANT_NULLABILITY_MODIFIER_JSDOC, CheckNullabilityModifiers.getReportedTypeName(n));
        }
    }

    private boolean shouldReport(Node n) {
        return !n.isString() || !this.templateTypeNames.contains(n.getString());
    }

    private void visitTypeExpression(JSTypeExpression expr, boolean hasArtificialTopLevelBang) {
        this.visitTypeExpression(expr, hasArtificialTopLevelBang, null);
    }

    private void visitTypeExpression(JSTypeExpression expr, boolean hasArtificialTopLevelBang, Node rValue) {
        Node root = expr.getRoot();
        NodeUtil.visitPreOrder(root, node -> {
            boolean isTypeOfType;
            Node parent = node.getParent();
            boolean isPrimitiveOrLiteral = CheckNullabilityModifiers.isPrimitiveType(node) || CheckNullabilityModifiers.isFunctionLiteral(node) || CheckNullabilityModifiers.isRecordLiteral(node);
            boolean isReference = CheckNullabilityModifiers.isReferenceType(node);
            boolean hasBang = parent != null && parent.getToken() == Token.BANG;
            boolean hasQmark = parent != null && parent.getToken() == Token.QMARK;
            boolean hasNonArtificialBang = hasBang && (!hasArtificialTopLevelBang || parent != root);
            boolean isNewOrThis = parent != null && (parent.isNew() || parent.isThis());
            boolean bl = isTypeOfType = parent != null && parent.isTypeOf();
            if (!(!isReference || hasBang || hasQmark || isNewOrThis || isTypeOfType)) {
                if (rValue != null && rValue.isNull()) {
                    this.nullMissingCandidates.add(node);
                } else {
                    this.missingCandidates.add(node);
                }
            } else if (isPrimitiveOrLiteral && hasNonArtificialBang) {
                this.redundantCandidates.add(node);
            }
        });
    }

    private static boolean isPrimitiveType(Node node) {
        return node.isString() && PRIMITIVE_TYPE_NAMES.contains(node.getString());
    }

    private static boolean isReferenceType(Node node) {
        return node.isString() && !PRIMITIVE_TYPE_NAMES.contains(node.getString());
    }

    private static boolean isFunctionLiteral(Node node) {
        return node.isFunction();
    }

    private static boolean isRecordLiteral(Node node) {
        return node.getToken() == Token.LC;
    }

    private static String getReportedTypeName(Node node) {
        if (CheckNullabilityModifiers.isFunctionLiteral(node)) {
            return "Function";
        }
        if (CheckNullabilityModifiers.isRecordLiteral(node)) {
            return "Record literal";
        }
        Preconditions.checkState(CheckNullabilityModifiers.isPrimitiveType(node) || CheckNullabilityModifiers.isReferenceType(node));
        return node.getString();
    }
}

