/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CodingConvention;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.ModuleRenaming;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PreprocessorSymbolTable;
import com.google.javascript.jscomp.ProcessClosurePrimitives;
import com.google.javascript.jscomp.Scope;
import com.google.javascript.jscomp.Var;
import com.google.javascript.jscomp.modules.ModuleMetadataMap;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;

final class RewriteClosureImports
implements HotSwapCompilerPass {
    private static final Node GOOG_REQUIRE = IR.getprop(IR.name("goog"), IR.string("require"));
    private static final Node GOOG_MODULE_GET = IR.getprop(IR.getprop(IR.name("goog"), IR.string("module")), IR.string("get"));
    private static final Node GOOG_FORWARD_DECLARE = IR.getprop(IR.name("goog"), IR.string("forwardDeclare"));
    private static final Node GOOG_REQUIRE_TYPE = IR.getprop(IR.name("goog"), IR.string("requireType"));
    private final AbstractCompiler compiler;
    @Nullable
    private final PreprocessorSymbolTable preprocessorSymbolTable;
    private final ImmutableSet<ModuleMetadataMap.ModuleType> typesToRewriteIn;
    private final Rewriter rewriter;

    RewriteClosureImports(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap, @Nullable PreprocessorSymbolTable preprocessorSymbolTable, ImmutableSet<ModuleMetadataMap.ModuleType> typesToRewriteIn) {
        this.compiler = compiler;
        this.preprocessorSymbolTable = preprocessorSymbolTable;
        this.typesToRewriteIn = typesToRewriteIn;
        this.rewriter = new Rewriter(compiler, moduleMetadataMap);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        if (this.typesToRewriteIn.isEmpty()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, scriptRoot, this.rewriter);
    }

    @Override
    public void process(Node externs, Node root) {
        if (this.typesToRewriteIn.isEmpty()) {
            return;
        }
        NodeTraversal.traverse(this.compiler, externs, this.rewriter);
        NodeTraversal.traverse(this.compiler, root, this.rewriter);
    }

    private class Rewriter
    extends NodeTraversal.AbstractModuleCallback {
        private final Table<String, Node, String> variablesToInline;
        private final Table<String, Node, String> typesToInline;
        private final Map<String, String> nonAliasedNamespaces;
        private final ModuleMetadataMap moduleMetadataMap;

        Rewriter(AbstractCompiler compiler, ModuleMetadataMap moduleMetadataMap) {
            super(compiler, moduleMetadataMap);
            this.variablesToInline = HashBasedTable.create();
            this.typesToInline = HashBasedTable.create();
            this.nonAliasedNamespaces = new HashMap<String, String>();
            this.moduleMetadataMap = moduleMetadataMap;
        }

        @Override
        protected void exitModule(ModuleMetadataMap.ModuleMetadata oldModule, Node moduleScopeRoot) {
            this.variablesToInline.clear();
            this.typesToInline.clear();
            this.nonAliasedNamespaces.clear();
        }

        @Override
        public void visit(NodeTraversal t, Node n, @Nullable ModuleMetadataMap.ModuleMetadata currentModule, @Nullable Node moduleScopeRoot) {
            if (currentModule == null || !RewriteClosureImports.this.typesToRewriteIn.contains((Object)currentModule.moduleType())) {
                return;
            }
            Node parent = n.getParent();
            switch (n.getToken()) {
                case CALL: {
                    if (n.getFirstChild().matchesQualifiedName(GOOG_REQUIRE) || n.getFirstChild().matchesQualifiedName(GOOG_REQUIRE_TYPE)) {
                        this.visitRequire(t, n, parent, currentModule);
                        break;
                    }
                    if (n.getFirstChild().matchesQualifiedName(GOOG_FORWARD_DECLARE)) {
                        this.visitForwardDeclare(t, n, parent, currentModule);
                        break;
                    }
                    if (!n.getFirstChild().matchesQualifiedName(GOOG_MODULE_GET)) break;
                    this.visitGoogModuleGet(t, n);
                    break;
                }
                case NAME: {
                    this.maybeInlineName(t, n);
                    break;
                }
            }
            if (n.getJSDocInfo() != null) {
                this.rewriteJsdoc(t, n.getJSDocInfo(), currentModule);
            }
        }

        private ModuleMetadataMap.ModuleMetadata getFallbackMetadataForNamespace(String namespace) {
            ModuleMetadataMap.ModuleMetadata.Builder builder = ModuleMetadataMap.ModuleMetadata.builder().moduleType(ModuleMetadataMap.ModuleType.GOOG_PROVIDE).usesClosure(true).isTestOnly(false);
            builder.googNamespacesBuilder().add((Object)namespace);
            return builder.build();
        }

        private void rewriteImport(NodeTraversal t, ModuleMetadataMap.ModuleMetadata currentModule, @Nullable ModuleMetadataMap.ModuleMetadata requiredModule, String requiredNamespace, Node callNode, Node parentNode) {
            Node callee = callNode.getFirstChild();
            this.maybeAddToSymbolTable(callee);
            Node statementNode = NodeUtil.getEnclosingStatement(callNode);
            Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(statementNode);
            String globalName = ModuleRenaming.getGlobalName(requiredModule, requiredNamespace);
            if (parentNode.isExprResult()) {
                if (requiredModule.isNonLegacyGoogModule() || requiredModule.isEs6Module()) {
                    this.nonAliasedNamespaces.put(requiredNamespace, globalName);
                }
                statementNode.detach();
                this.maybeAddToSymbolTable(callNode.getLastChild(), globalName);
            } else if (requiredModule.isEs6Module()) {
                Preconditions.checkState(NodeUtil.isNameDeclaration(parentNode.getParent()));
                callNode.replaceWith(NodeUtil.newQName(this.compiler, globalName).srcrefTree(callNode));
                this.maybeAddToSymbolTable(callNode.getLastChild(), globalName);
            } else if (parentNode.isName()) {
                String name = parentNode.getString();
                Node fromScope = ((Var)t.getScope().getVar(parentNode.getString())).getNameNode();
                Preconditions.checkState(fromScope == parentNode);
                this.variablesToInline.put(name, fromScope, globalName);
                this.typesToInline.put(parentNode.getString(), parentNode, globalName);
                statementNode.detach();
                this.maybeAddAliasToSymbolTable(statementNode.getFirstChild(), currentModule);
            } else {
                Preconditions.checkState(parentNode.isDestructuringLhs());
                for (Node importSpec : parentNode.getFirstChild().children()) {
                    Preconditions.checkState(importSpec.hasChildren(), importSpec);
                    String importedProperty = importSpec.getString();
                    Node aliasNode = importSpec.getFirstChild();
                    String aliasName = aliasNode.getString();
                    String fullName = globalName + "." + importedProperty;
                    Node fromScope = ((Var)t.getScope().getVar(aliasNode.getString())).getNameNode();
                    Preconditions.checkState(fromScope == aliasNode);
                    this.variablesToInline.put(aliasName, aliasNode, fullName);
                    this.typesToInline.put(aliasName, aliasNode, fullName);
                    this.maybeAddAliasToSymbolTable(aliasNode, currentModule);
                }
                statementNode.detach();
            }
            this.compiler.reportChangeToChangeScope(changeScope);
        }

        private void visitRequire(NodeTraversal t, Node callNode, Node parentNode, ModuleMetadataMap.ModuleMetadata currentModule) {
            String requiredNamespace = callNode.getLastChild().getString();
            ModuleMetadataMap.ModuleMetadata requiredModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(requiredNamespace);
            if (requiredModule == null) {
                requiredModule = this.getFallbackMetadataForNamespace(requiredNamespace);
            }
            this.rewriteImport(t, currentModule, requiredModule, requiredNamespace, callNode, parentNode);
        }

        private void rewriteGoogModuleGet(ModuleMetadataMap.ModuleMetadata requiredModule, String requiredNamespace, NodeTraversal t, Node callNode) {
            boolean isFillingAnAlias;
            Node maybeAssign = callNode.getParent();
            boolean bl = isFillingAnAlias = maybeAssign.isAssign() && maybeAssign.getParent().isExprResult();
            if (isFillingAnAlias) {
                maybeAssign.getParent().detach();
            } else {
                callNode.replaceWith(NodeUtil.newQName(this.compiler, ModuleRenaming.getGlobalName(requiredModule, requiredNamespace)).srcrefTree(callNode));
            }
            t.reportCodeChange();
        }

        private void visitGoogModuleGet(NodeTraversal t, Node callNode) {
            String requiredNamespace = callNode.getLastChild().getString();
            ModuleMetadataMap.ModuleMetadata requiredModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(requiredNamespace);
            if (requiredModule == null) {
                this.compiler.reportChangeToChangeScope(NodeUtil.getEnclosingChangeScopeRoot(callNode));
                NodeUtil.getEnclosingStatement(callNode).detach();
                return;
            }
            this.rewriteGoogModuleGet(requiredModule, requiredNamespace, t, callNode);
        }

        private void visitForwardDeclare(NodeTraversal t, Node n, Node parent, ModuleMetadataMap.ModuleMetadata currentModule) {
            String typeDeclaration;
            CodingConvention convention = this.compiler.getCodingConvention();
            try {
                typeDeclaration = Iterables.getOnlyElement(convention.identifyTypeDeclarationCall(n));
            }
            catch (IllegalArgumentException | NullPointerException | NoSuchElementException e) {
                this.compiler.report(JSError.make(n, ProcessClosurePrimitives.INVALID_FORWARD_DECLARE, "A single type could not identified for the goog.forwardDeclare statement"));
                return;
            }
            if (typeDeclaration != null) {
                this.compiler.forwardDeclareType(typeDeclaration);
            }
            String requiredNamespace = n.getLastChild().getString();
            ModuleMetadataMap.ModuleMetadata requiredModule = this.moduleMetadataMap.getModulesByGoogNamespace().get(requiredNamespace);
            if (requiredModule == null) {
                Preconditions.checkState(parent.isExprResult());
                parent.detach();
                t.reportCodeChange();
            } else {
                this.rewriteImport(t, currentModule, requiredModule, requiredNamespace, n, parent);
            }
        }

        private void maybeInlineName(NodeTraversal t, Node n) {
            if (this.variablesToInline.isEmpty()) {
                return;
            }
            Var var = (Var)t.getScope().getVar(n.getString());
            if (var == null) {
                return;
            }
            String newName = this.variablesToInline.get(n.getString(), var.getNameNode());
            if (newName == null) {
                return;
            }
            if (n.getParent().isExportSpec() && n.getParent().getFirstChild() == n) {
                n = this.splitExportSpec(t, n, n.getParent());
            }
            if (!newName.contains(".")) {
                this.safeSetString(n, newName);
            } else {
                Node changeScope = NodeUtil.getEnclosingChangeScopeRoot(n);
                n.replaceWith(NodeUtil.newQName(this.compiler, newName).srcrefTree(n));
                if (changeScope != null) {
                    this.compiler.reportChangeToChangeScope(changeScope);
                }
            }
        }

        private Node splitExportSpec(NodeTraversal t, Node nameNode, Node exportSpec) {
            Node oldExport = exportSpec.getGrandparent();
            Node newRHSNameNode = IR.name(nameNode.getString());
            Node newExport = IR.export(IR.constNode(IR.name(exportSpec.getSecondChild().getString()), newRHSNameNode)).srcrefTree(exportSpec);
            oldExport.getParent().addChildAfter(newExport, oldExport);
            exportSpec.detach();
            t.reportCodeChange();
            return newRHSNameNode;
        }

        private void safeSetString(Node n, String newString) {
            Node changeScope;
            if (n.getString().equals(newString)) {
                return;
            }
            String originalName = n.getString();
            n.setString(newString);
            if (n.getOriginalName() == null) {
                n.setOriginalName(originalName);
            }
            if ((changeScope = NodeUtil.getEnclosingChangeScopeRoot(n)) != null) {
                this.compiler.reportChangeToChangeScope(changeScope);
            }
        }

        private void rewriteJsdoc(NodeTraversal t, JSDocInfo info, ModuleMetadataMap.ModuleMetadata currentModule) {
            if (this.typesToInline.isEmpty() && this.nonAliasedNamespaces.isEmpty()) {
                return;
            }
            JsDocRefReplacer replacer = new JsDocRefReplacer(currentModule, t.getScope());
            for (Node typeNode : info.getTypeNodes()) {
                NodeUtil.visitPreOrder(typeNode, replacer);
            }
        }

        private void maybeAddToSymbolTable(Node n) {
            if (RewriteClosureImports.this.preprocessorSymbolTable != null) {
                RewriteClosureImports.this.preprocessorSymbolTable.addReference(n);
            }
        }

        private void maybeAddToSymbolTable(Node n, String name) {
            if (RewriteClosureImports.this.preprocessorSymbolTable != null) {
                RewriteClosureImports.this.preprocessorSymbolTable.addReference(n, name);
            }
        }

        private void maybeAddAliasToSymbolTable(Node n, ModuleMetadataMap.ModuleMetadata currentModule) {
            if (RewriteClosureImports.this.preprocessorSymbolTable != null) {
                n.putBooleanProp(Node.MODULE_ALIAS, true);
                String nodeName = n.isString() ? n.getString() : RewriteClosureImports.this.preprocessorSymbolTable.getQualifiedName(n);
                String module = ModuleRenaming.getGlobalName(currentModule, Iterables.getFirst(currentModule.googNamespaces(), null));
                String name = "alias_" + module + "_" + nodeName;
                this.maybeAddToSymbolTable(n, name);
            }
        }

        private final class JsDocRefReplacer
        implements NodeUtil.Visitor {
            private final ModuleMetadataMap.ModuleMetadata currentModule;
            private final Scope scope;

            JsDocRefReplacer(ModuleMetadataMap.ModuleMetadata currentModule, Scope scope) {
                this.currentModule = currentModule;
                this.scope = scope;
            }

            @Override
            public void visit(Node typeRefNode) {
                String typeName;
                if (!typeRefNode.isString()) {
                    return;
                }
                String prefixTypeName = typeName = typeRefNode.getString();
                String suffix = "";
                while (true) {
                    Var var;
                    String globalName = null;
                    if (!prefixTypeName.contains(".") && (var = (Var)this.scope.getVar(prefixTypeName)) != null) {
                        globalName = (String)Rewriter.this.typesToInline.get(prefixTypeName, var.getNameNode());
                    }
                    if (globalName == null) {
                        globalName = (String)Rewriter.this.nonAliasedNamespaces.get(prefixTypeName);
                    }
                    if (globalName != null) {
                        if (RewriteClosureImports.this.preprocessorSymbolTable != null) {
                            Node moduleOnlyNode = typeRefNode.cloneNode();
                            Rewriter.this.safeSetString(moduleOnlyNode, prefixTypeName);
                            moduleOnlyNode.setLength(prefixTypeName.length());
                            Rewriter.this.maybeAddAliasToSymbolTable(moduleOnlyNode, this.currentModule);
                        }
                        Rewriter.this.safeSetString(typeRefNode, globalName + suffix);
                        return;
                    }
                    if (!prefixTypeName.contains(".")) break;
                    prefixTypeName = prefixTypeName.substring(0, prefixTypeName.lastIndexOf(46));
                    suffix = typeName.substring(prefixTypeName.length());
                }
            }
        }
    }
}

