/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.AstFactory;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.Es6ToEs3Util;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.JsIterables;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.TranspilationPasses;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.JSTypeRegistry;
import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Set;

public final class RewriteAsyncIteration
implements NodeTraversal.Callback,
HotSwapCompilerPass {
    private static final FeatureSet transpiledFeatures = FeatureSet.BARE_MINIMUM.with(FeatureSet.Feature.ASYNC_GENERATORS, FeatureSet.Feature.FOR_AWAIT_OF);
    static final DiagnosticType CANNOT_CONVERT_ASYNCGEN = DiagnosticType.error("JSC_CANNOT_CONVERT_ASYNCGEN", "Cannot convert async generator. {0}");
    private static final String GENERATOR_WRAPPER_NAME = "$jscomp.AsyncGeneratorWrapper";
    private static final String ACTION_RECORD_NAME = "$jscomp.AsyncGeneratorWrapper$ActionRecord";
    private static final String ACTION_ENUM_AWAIT = "$jscomp.AsyncGeneratorWrapper$ActionEnum.AWAIT_VALUE";
    private static final String ACTION_ENUM_YIELD = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_VALUE";
    private static final String ACTION_ENUM_YIELD_STAR = "$jscomp.AsyncGeneratorWrapper$ActionEnum.YIELD_STAR";
    private static final String FOR_AWAIT_ITERATOR_TEMP_NAME = "$jscomp$forAwait$tempIterator";
    private static final String FOR_AWAIT_RESULT_TEMP_NAME = "$jscomp$forAwait$tempResult";
    private int nextForAwaitId = 0;
    private final AbstractCompiler compiler;
    private final ArrayDeque<LexicalContext> contextStack;
    private final String thisVarName = "$jscomp$asyncIter$this";
    private final String argumentsVarName = "$jscomp$asyncIter$arguments";
    private final String superPropGetterPrefix = "$jscomp$asyncIter$super$get$";
    private final JSTypeRegistry registry;
    private final AstFactory astFactory;
    private final JSType unknownType;
    private final boolean rewriteSuperPropertyReferencesWithoutSuper;

    private RewriteAsyncIteration(Builder builder) {
        this.compiler = builder.compiler;
        this.contextStack = new ArrayDeque();
        this.rewriteSuperPropertyReferencesWithoutSuper = builder.rewriteSuperPropertyReferencesWithoutSuper;
        this.registry = builder.registry;
        this.astFactory = builder.astFactory;
        this.unknownType = this.createType(() -> this.registry.getNativeType(JSTypeNative.UNKNOWN_TYPE));
    }

    private <T extends JSType> T createType(Supplier<T> fn) {
        if (this.astFactory.isAddingTypes()) {
            return (T)((JSType)fn.get());
        }
        return null;
    }

    private JSType createGenericType(JSTypeNative typeName, JSType typeArg) {
        return Es6ToEs3Util.createGenericType(this.astFactory.isAddingTypes(), this.registry, typeName, typeArg);
    }

    @Override
    public void hotSwapScript(Node scriptRoot, Node originalRoot) {
        this.process(scriptRoot, true);
    }

    @Override
    public void process(Node externs, Node root) {
        this.process(root, false);
    }

    private void process(Node root, boolean hotSwap) {
        Preconditions.checkState(this.contextStack.isEmpty());
        this.contextStack.push(LexicalContext.newGlobalContext(root));
        if (hotSwap) {
            TranspilationPasses.hotSwapTranspile(this.compiler, root, transpiledFeatures, this);
        } else {
            TranspilationPasses.processTranspile(this.compiler, root, transpiledFeatures, this);
        }
        TranspilationPasses.maybeMarkFeaturesAsTranspiledAway(this.compiler, transpiledFeatures);
        Preconditions.checkState(this.contextStack.element().function == null);
        this.contextStack.remove();
        Preconditions.checkState(this.contextStack.isEmpty());
    }

    @Override
    public boolean shouldTraverse(NodeTraversal nodeTraversal, Node n, Node parent) {
        if (n.isFunction()) {
            this.contextStack.push(LexicalContext.newContextForFunction(this.contextStack.element(), n));
        } else if (n.isParamList()) {
            this.contextStack.push(LexicalContext.newContextForParamList(this.contextStack.element(), n));
        }
        return true;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        LexicalContext ctx = this.contextStack.element();
        switch (n.getToken()) {
            case PARAM_LIST: {
                Preconditions.checkState(n.equals(ctx.contextRoot), n);
                this.contextStack.pop();
                break;
            }
            case FUNCTION: {
                Preconditions.checkState(n.equals(ctx.contextRoot));
                if (n.isAsyncGeneratorFunction()) {
                    this.convertAsyncGenerator(t, n);
                    this.prependTempVarDeclarations(ctx, t);
                }
                this.contextStack.pop();
                break;
            }
            case AWAIT: {
                Preconditions.checkNotNull(ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertAwaitOfAsyncGenerator(t, ctx, n);
                break;
            }
            case YIELD: {
                Preconditions.checkNotNull(ctx.function);
                if (!ctx.function.isAsyncGeneratorFunction()) break;
                this.convertYieldOfAsyncGenerator(t, ctx, n);
                break;
            }
            case FOR_AWAIT_OF: {
                Preconditions.checkNotNull(ctx.function);
                Preconditions.checkState(ctx.function.isAsyncFunction());
                this.replaceForAwaitOf(t, ctx, n);
                NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS);
                break;
            }
            case THIS: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceThis(t, ctx, n);
                break;
            }
            case NAME: {
                if (!ctx.mustReplaceThisSuperArgs() || !n.matchesName("arguments")) break;
                this.replaceArguments(t, ctx, n);
                break;
            }
            case SUPER: {
                if (!ctx.mustReplaceThisSuperArgs()) break;
                this.replaceSuper(t, ctx, n, parent);
                break;
            }
        }
    }

    private void convertAsyncGenerator(NodeTraversal t, Node originalFunction) {
        Preconditions.checkNotNull(originalFunction);
        Preconditions.checkState(originalFunction.isAsyncGeneratorFunction());
        Node asyncGeneratorWrapperRef = this.astFactory.createAsyncGeneratorWrapperReference(originalFunction.getJSType(), t.getScope());
        Node innerFunction = this.astFactory.createEmptyAsyncGeneratorWrapperArgument(asyncGeneratorWrapperRef.getJSType());
        Node innerBlock = originalFunction.getLastChild();
        originalFunction.removeChild(innerBlock);
        innerFunction.replaceChild(innerFunction.getLastChild(), innerBlock);
        Node outerBlock = this.astFactory.createBlock(this.astFactory.createReturn(this.astFactory.createNewNode(asyncGeneratorWrapperRef, this.astFactory.createCall(innerFunction, new Node[0]))));
        originalFunction.addChildToBack(outerBlock);
        originalFunction.setIsAsyncFunction(false);
        originalFunction.setIsGeneratorFunction(false);
        originalFunction.useSourceInfoIfMissingFromForTree(originalFunction);
        this.compiler.reportChangeToChangeScope(originalFunction);
        this.compiler.reportChangeToChangeScope(innerFunction);
    }

    private void convertAwaitOfAsyncGenerator(NodeTraversal t, LexicalContext ctx, Node awaitNode) {
        Preconditions.checkNotNull(awaitNode);
        Preconditions.checkState(awaitNode.isAwait());
        Preconditions.checkState(ctx != null && ctx.function != null);
        Preconditions.checkState(ctx.function.isAsyncGeneratorFunction());
        Node expression = awaitNode.removeFirstChild();
        Preconditions.checkNotNull(expression, "await needs an expression");
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(t.getScope(), ACTION_RECORD_NAME), this.astFactory.createQName(t.getScope(), ACTION_ENUM_AWAIT), expression);
        newActionRecord.useSourceInfoIfMissingFromForTree(awaitNode);
        awaitNode.addChildToFront(newActionRecord);
        awaitNode.setToken(Token.YIELD);
    }

    private void convertYieldOfAsyncGenerator(NodeTraversal t, LexicalContext ctx, Node yieldNode) {
        Preconditions.checkNotNull(yieldNode);
        Preconditions.checkState(yieldNode.isYield());
        Preconditions.checkState(ctx != null && ctx.function != null);
        Preconditions.checkState(ctx.function.isAsyncGeneratorFunction());
        Node expression = yieldNode.removeFirstChild();
        Node newActionRecord = this.astFactory.createNewNode(this.astFactory.createQName(t.getScope(), ACTION_RECORD_NAME), new Node[0]);
        if (yieldNode.isYieldAll()) {
            Preconditions.checkNotNull(expression);
            newActionRecord.addChildToBack(this.astFactory.createQName(t.getScope(), ACTION_ENUM_YIELD_STAR));
            newActionRecord.addChildToBack(expression);
        } else {
            if (expression == null) {
                expression = NodeUtil.newUndefinedNode(null);
            }
            newActionRecord.addChildToBack(this.astFactory.createQName(t.getScope(), ACTION_ENUM_YIELD));
            newActionRecord.addChildToBack(expression);
        }
        newActionRecord.useSourceInfoIfMissingFromForTree(yieldNode);
        yieldNode.addChildToFront(newActionRecord);
        yieldNode.removeProp(Node.YIELD_ALL);
    }

    private void replaceForAwaitOf(NodeTraversal t, LexicalContext ctx, Node forAwaitOf) {
        Node lhsAssignment;
        int forAwaitId = this.nextForAwaitId++;
        String iteratorTempName = FOR_AWAIT_ITERATOR_TEMP_NAME + forAwaitId;
        String resultTempName = FOR_AWAIT_RESULT_TEMP_NAME + forAwaitId;
        Preconditions.checkState(forAwaitOf.getParent() != null, "Cannot replace parentless for-await-of");
        Node lhs = forAwaitOf.removeFirstChild();
        Node rhs = forAwaitOf.removeFirstChild();
        Node originalBody = forAwaitOf.removeFirstChild();
        JSType typeParam = this.createType(() -> JsIterables.maybeBoxIterableOrAsyncIterable(rhs.getJSType(), this.registry).orElse(this.unknownType));
        Node initializer = this.astFactory.createSingleConstNameDeclaration(iteratorTempName, this.astFactory.createJSCompMakeAsyncIteratorCall(rhs, t.getScope())).useSourceInfoIfMissingFromForTree(rhs);
        JSType iterableResultType = this.createGenericType(JSTypeNative.I_ITERABLE_RESULT_TYPE, typeParam);
        Node resultDeclaration = this.astFactory.createSingleConstNameDeclaration(resultTempName, this.constructAwaitNextResult(t, ctx, iteratorTempName, initializer.getFirstChild().getJSType(), iterableResultType));
        Node breakIfDone = this.astFactory.createIf(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "done"), this.astFactory.createBlock(this.astFactory.createBreak()));
        if (lhs.isValidAssignmentTarget()) {
            lhsAssignment = this.astFactory.exprResult(this.astFactory.createAssign(lhs, this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value")));
        } else if (NodeUtil.isNameDeclaration(lhs)) {
            lhs.getFirstChild().addChildToBack(this.astFactory.createGetProp(this.astFactory.createName(resultTempName, iterableResultType), "value"));
            lhsAssignment = lhs;
        } else {
            throw new AssertionError((Object)"unexpected for-await-of lhs");
        }
        lhsAssignment.useSourceInfoIfMissingFromForTree(lhs);
        Node newForLoop = this.astFactory.createFor(initializer, this.astFactory.createEmpty(), this.astFactory.createEmpty(), this.astFactory.createBlock(resultDeclaration, breakIfDone, lhsAssignment, this.ensureBlock(originalBody)));
        forAwaitOf.replaceWith(newForLoop);
        newForLoop.useSourceInfoIfMissingFromForTree(forAwaitOf);
        this.compiler.reportChangeToEnclosingScope(newForLoop);
    }

    private Node ensureBlock(Node possiblyBlock) {
        return possiblyBlock.isBlock() ? possiblyBlock : this.astFactory.createBlock(possiblyBlock).useSourceInfoFrom(possiblyBlock);
    }

    private Node constructAwaitNextResult(NodeTraversal t, LexicalContext ctx, String iteratorTempName, JSType iteratorType, JSType iterableResultType) {
        Preconditions.checkNotNull(ctx.function);
        Node iteratorTemp = this.astFactory.createName(iteratorTempName, iteratorType);
        Node result = ctx.function.isAsyncGeneratorFunction() ? this.astFactory.createYield(iterableResultType, this.astFactory.createNewNode(this.astFactory.createQName(t.getScope(), ACTION_RECORD_NAME), this.astFactory.createQName(t.getScope(), ACTION_ENUM_AWAIT), this.astFactory.createCall(this.astFactory.createGetProp(iteratorTemp, "next"), new Node[0]))) : this.astFactory.createAwait(iterableResultType, this.astFactory.createCall(this.astFactory.createGetProp(iteratorTemp, "next"), new Node[0]));
        return result;
    }

    private void replaceThis(NodeTraversal t, LexicalContext ctx, Node n) {
        Preconditions.checkArgument(n.isThis());
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName(t.getScope(), "$jscomp$asyncIter$this").useSourceInfoFrom(n));
        ctx.thisSuperArgsContext.usedThis = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceArguments(NodeTraversal t, LexicalContext ctx, Node n) {
        Preconditions.checkArgument(n.isName() && "arguments".equals(n.getString()));
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        n.replaceWith(this.astFactory.createName(t.getScope(), "$jscomp$asyncIter$arguments").useSourceInfoFrom(n));
        ctx.thisSuperArgsContext.usedArguments = true;
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void replaceSuper(NodeTraversal t, LexicalContext ctx, Node n, Node parent) {
        if (!parent.isGetProp()) {
            this.compiler.report(JSError.make(parent, CANNOT_CONVERT_ASYNCGEN, "super only allowed with getprop (like super.foo(), not super['foo']())"));
            return;
        }
        Preconditions.checkArgument(n.isSuper());
        Preconditions.checkArgument(ctx != null && ctx.mustReplaceThisSuperArgs());
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        Node propertyName = n.getNext();
        String propertyReplacementNameText = "$jscomp$asyncIter$super$get$" + propertyName.getString();
        Node getPropReplacement = this.astFactory.createCall(this.astFactory.createName(t.getScope(), propertyReplacementNameText), new Node[0]);
        Node grandparent = parent.getParent();
        if (grandparent.isCall() && grandparent.getFirstChild() == parent) {
            getPropReplacement = this.astFactory.createGetProp(getPropReplacement, "call");
            grandparent.addChildAfter(this.astFactory.createName(t.getScope(), "$jscomp$asyncIter$this").useSourceInfoFrom(parent), parent);
            ctx.thisSuperArgsContext.usedThis = true;
        }
        getPropReplacement.useSourceInfoFromForTree(parent);
        grandparent.replaceChild(parent, getPropReplacement);
        ctx.thisSuperArgsContext.usedSuperProperties.add(propertyName.getString());
        this.compiler.reportChangeToChangeScope(ctx.function);
    }

    private void prependTempVarDeclarations(LexicalContext ctx, NodeTraversal t) {
        Preconditions.checkArgument(ctx != null);
        Preconditions.checkArgument(ctx.function != null, "Cannot prepend declarations to root scope");
        Preconditions.checkNotNull(ctx.thisSuperArgsContext);
        ThisSuperArgsContext thisSuperArgsCtx = ctx.thisSuperArgsContext;
        Node function = ctx.function;
        Node block = function.getLastChild();
        Preconditions.checkNotNull(block, function);
        Node prefixBlock = this.astFactory.createBlock(new Node[0]);
        if (thisSuperArgsCtx.usedThis) {
            prefixBlock.addChildToBack(this.astFactory.createThisAliasDeclarationForFunction("$jscomp$asyncIter$this", function).useSourceInfoFromForTree(block));
        }
        if (thisSuperArgsCtx.usedArguments) {
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration("$jscomp$asyncIter$arguments", this.astFactory.createName(t.getScope(), "arguments")).useSourceInfoFromForTree(block));
        }
        for (String replacedMethodName : thisSuperArgsCtx.usedSuperProperties) {
            Node superReference;
            if (this.rewriteSuperPropertyReferencesWithoutSuper) {
                superReference = this.astFactory.createObjectGetPrototypeOfCall(this.astFactory.createThisForFunction(function));
                if (!ctx.function.getParent().isStaticMember()) {
                    superReference = this.astFactory.createObjectGetPrototypeOfCall(superReference);
                }
            } else {
                superReference = this.astFactory.createSuperForFunction(function);
            }
            Node arrowFunction = this.astFactory.createZeroArgArrowFunctionForExpression(this.astFactory.createGetProp(superReference, replacedMethodName));
            this.compiler.reportChangeToChangeScope(arrowFunction);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.ARROW_FUNCTIONS);
            String superReplacementName = "$jscomp$asyncIter$super$get$" + replacedMethodName;
            prefixBlock.addChildToBack(this.astFactory.createSingleConstNameDeclaration(superReplacementName, arrowFunction));
        }
        prefixBlock.useSourceInfoIfMissingFromForTree(block);
        block.addChildrenToFront(prefixBlock.removeChildren());
        if (thisSuperArgsCtx.usedThis || thisSuperArgsCtx.usedArguments || !thisSuperArgsCtx.usedSuperProperties.isEmpty()) {
            this.compiler.reportChangeToChangeScope(function);
            NodeUtil.addFeatureToScript(t.getCurrentScript(), FeatureSet.Feature.CONST_DECLARATIONS);
        }
    }

    static class Builder {
        private final AbstractCompiler compiler;
        private boolean rewriteSuperPropertyReferencesWithoutSuper = false;
        private JSTypeRegistry registry;
        private AstFactory astFactory;

        Builder(AbstractCompiler compiler) {
            Preconditions.checkNotNull(compiler);
            this.compiler = compiler;
        }

        Builder rewriteSuperPropertyReferencesWithoutSuper(boolean value) {
            this.rewriteSuperPropertyReferencesWithoutSuper = value;
            return this;
        }

        RewriteAsyncIteration build() {
            this.astFactory = this.compiler.createAstFactory();
            this.registry = this.compiler.getTypeRegistry();
            return new RewriteAsyncIteration(this);
        }
    }

    private static final class ThisSuperArgsContext {
        private final LexicalContext ctx;
        private final Set<String> usedSuperProperties = new LinkedHashSet<String>();
        private boolean usedThis = false;
        private boolean usedArguments = false;

        ThisSuperArgsContext(LexicalContext ctx) {
            this.ctx = ctx;
        }
    }

    private static final class LexicalContext {
        private final Node contextRoot;
        private final Node function;
        private final ThisSuperArgsContext thisSuperArgsContext;

        private LexicalContext(Node contextRoot) {
            this.contextRoot = Preconditions.checkNotNull(contextRoot);
            this.function = null;
            this.thisSuperArgsContext = null;
        }

        private LexicalContext(LexicalContext parent, Node contextRoot, Node function) {
            Preconditions.checkNotNull(parent);
            Preconditions.checkNotNull(contextRoot);
            Preconditions.checkArgument(contextRoot == function || contextRoot.isParamList(), contextRoot);
            Preconditions.checkNotNull(function);
            Preconditions.checkArgument(function.isFunction(), function);
            this.contextRoot = contextRoot;
            this.function = function;
            this.thisSuperArgsContext = function.isArrowFunction() ? parent.thisSuperArgsContext : (contextRoot.isFunction() ? new ThisSuperArgsContext(this) : null);
        }

        static LexicalContext newGlobalContext(Node contextRoot) {
            return new LexicalContext(contextRoot);
        }

        static LexicalContext newContextForFunction(LexicalContext parent, Node function) {
            return new LexicalContext(parent, function, function);
        }

        static LexicalContext newContextForParamList(LexicalContext parent, Node paramList) {
            return new LexicalContext(parent, paramList, parent.function);
        }

        Node getFunctionDeclaringThisArgsSuper() {
            return ((ThisSuperArgsContext)this.thisSuperArgsContext).ctx.function;
        }

        boolean mustReplaceThisSuperArgs() {
            return this.thisSuperArgsContext != null && this.getFunctionDeclaringThisArgsSuper().isAsyncGeneratorFunction();
        }
    }
}

