/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DefaultNameGenerator;
import com.google.javascript.jscomp.GatherGetterAndSetterProperties;
import com.google.javascript.jscomp.InvalidatingTypes;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PropertyRenamingDiagnostics;
import com.google.javascript.jscomp.graph.AdjacencyGraph;
import com.google.javascript.jscomp.graph.Annotation;
import com.google.javascript.jscomp.graph.GraphColoring;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.SubGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import com.google.javascript.rhino.jstype.ObjectType;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class AmbiguateProperties
implements CompilerPass {
    private static final Logger logger = Logger.getLogger(AmbiguateProperties.class.getName());
    private final AbstractCompiler compiler;
    private final List<Node> stringNodesToRename = new ArrayList<Node>();
    private final char[] reservedFirstCharacters;
    private final char[] reservedNonFirstCharacters;
    private final Map<String, Property> propertyMap = new LinkedHashMap<String, Property>();
    private final ImmutableSet<String> externedNames;
    private final Set<String> quotedNames = new HashSet<String>();
    private Map<String, String> renamingMap = null;
    private static final Comparator<Property> FREQUENCY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property p1, Property p2) {
            if (p1.numOccurrences != p2.numOccurrences) {
                return p2.numOccurrences - p1.numOccurrences;
            }
            return p1.oldName.compareTo(p2.oldName);
        }
    };
    private final BiMap<JSType, Integer> intForType = HashBiMap.create();
    private final Map<JSType, JSTypeBitSet> relatedBitsets = new HashMap<JSType, JSTypeBitSet>();
    private final InvalidatingTypes invalidatingTypes;
    private static final String WRONG_ARGUMENT_COUNT = " Must be called with 1 or 2 arguments.";
    private static final String WANT_STRING_LITERAL = " The first argument must be a string literal.";
    private static final String DO_NOT_WANT_PATH = " The first argument must not be a property path.";

    AmbiguateProperties(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters) {
        Preconditions.checkState(compiler.getLifeCycleStage().isNormalized());
        this.compiler = compiler;
        this.reservedFirstCharacters = reservedFirstCharacters;
        this.reservedNonFirstCharacters = reservedNonFirstCharacters;
        this.invalidatingTypes = new InvalidatingTypes.Builder(compiler.getTypeRegistry()).addTypesInvalidForPropertyRenaming().addAllTypeMismatches(compiler.getTypeMismatches()).addAllTypeMismatches(compiler.getImplicitInterfaceUses()).build();
        this.externedNames = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().add("prototype")).addAll(compiler.getExternProperties())).build();
    }

    static AmbiguateProperties makePassForTesting(AbstractCompiler compiler, char[] reservedFirstCharacters, char[] reservedNonFirstCharacters) {
        AmbiguateProperties ap = new AmbiguateProperties(compiler, reservedFirstCharacters, reservedNonFirstCharacters);
        ap.renamingMap = new HashMap<String, String>();
        return ap;
    }

    Map<String, String> getRenamingMap() {
        Preconditions.checkNotNull(this.renamingMap);
        return this.renamingMap;
    }

    private int getIntForType(JSType type) {
        if (type != null && type.isGenericObjectType()) {
            type = type.toMaybeObjectType().getRawType();
        }
        if (this.intForType.containsKey(type)) {
            return (Integer)this.intForType.get(type);
        }
        int newInt = this.intForType.size() + 1;
        this.intForType.put(type, newInt);
        return newInt;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new ProcessProperties());
        ImmutableCollection.Builder reservedNames = ((ImmutableSet.Builder)ImmutableSet.builder().addAll(this.externedNames)).addAll(this.quotedNames);
        int numRenamedPropertyNames = 0;
        int numSkippedPropertyNames = 0;
        ArrayList<PropertyGraphNode> nodes = new ArrayList<PropertyGraphNode>(this.propertyMap.size());
        for (Property prop : this.propertyMap.values()) {
            if (prop.skipAmbiguating) {
                ++numSkippedPropertyNames;
                ((ImmutableSet.Builder)reservedNames).add(prop.oldName);
                continue;
            }
            ++numRenamedPropertyNames;
            nodes.add(new PropertyGraphNode(prop));
        }
        PropertyGraph graph = new PropertyGraph(nodes);
        GraphColoring.GreedyGraphColoring<Property, Void> coloring = new GraphColoring.GreedyGraphColoring<Property, Void>(graph, FREQUENCY_COMPARATOR);
        int numNewPropertyNames = ((GraphColoring)coloring).color();
        DefaultNameGenerator nameGen = new DefaultNameGenerator((Set<String>)((Object)((ImmutableSet.Builder)reservedNames).build()), "", this.reservedFirstCharacters, this.reservedNonFirstCharacters);
        String[] colorMap = new String[numNewPropertyNames];
        for (int i = 0; i < numNewPropertyNames; ++i) {
            colorMap[i] = nameGen.generateNextName();
        }
        for (PropertyGraphNode node : graph.getNodes()) {
            node.getValue().newName = colorMap[node.getAnnotation().hashCode()];
            if (this.renamingMap == null) continue;
            this.renamingMap.put(node.getValue().oldName, node.getValue().newName);
        }
        for (Node n : this.stringNodesToRename) {
            String oldName = n.getString();
            Property p = this.propertyMap.get(oldName);
            if (p == null || p.newName == null) continue;
            Preconditions.checkState(oldName.equals(p.oldName));
            if (p.newName.equals(oldName)) continue;
            n.setString(p.newName);
            this.compiler.reportChangeToEnclosingScope(n);
        }
        GatherGetterAndSetterProperties.update(this.compiler, externs, root);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Collapsed " + numRenamedPropertyNames + " properties into " + numNewPropertyNames + " and skipped renaming " + numSkippedPropertyNames + " properties.");
        }
    }

    private BitSet getRelatedTypesOnNonUnion(JSType type) {
        if (this.relatedBitsets.containsKey(type)) {
            return this.relatedBitsets.get(type);
        }
        throw new RuntimeException("Related types should have been computed for type: " + type + " but have not been.");
    }

    private void computeRelatedTypesForNonUnionType(JSType type) {
        FunctionType fnType;
        Preconditions.checkState(!type.isUnionType(), type);
        if (this.relatedBitsets.containsKey(type)) {
            return;
        }
        JSTypeBitSet related = new JSTypeBitSet(this.intForType.size());
        this.relatedBitsets.put(type, related);
        related.set(this.getIntForType(type));
        if (type.isFunctionPrototypeType()) {
            FunctionType maybeCtor = type.toMaybeObjectType().getOwnerFunction();
            if (maybeCtor.isConstructor() || maybeCtor.isInterface()) {
                this.addRelatedInstance(maybeCtor, related);
            }
            return;
        }
        FunctionType constructor = type.toMaybeObjectType().getConstructor();
        if (constructor != null) {
            for (FunctionType subType : constructor.getDirectSubTypes()) {
                this.addRelatedInstance(subType, related);
            }
        }
        if ((fnType = type.toMaybeFunctionType()) != null) {
            for (FunctionType subType : fnType.getDirectSubTypes()) {
                if (fnType != subType.getImplicitPrototype()) continue;
                this.addRelatedType(subType, related);
            }
        }
    }

    private void addRelatedInstance(FunctionType constructor, JSTypeBitSet related) {
        Preconditions.checkArgument(constructor.hasInstanceType(), "Constructor %s without instance type.", (Object)constructor);
        ObjectType instanceType = constructor.getInstanceType();
        this.addRelatedType(instanceType, related);
    }

    private void addRelatedType(JSType type, JSTypeBitSet related) {
        this.computeRelatedTypesForNonUnionType(type);
        related.or(this.relatedBitsets.get(type));
    }

    private void reportInvalidRenameFunction(Node n, String functionName, String message) {
        this.compiler.report(JSError.make(n, PropertyRenamingDiagnostics.INVALID_RENAME_FUNCTION, functionName, message));
    }

    private Property getProperty(String name) {
        Property prop = this.propertyMap.get(name);
        if (prop == null) {
            prop = new Property(name);
            this.propertyMap.put(name, prop);
        }
        return prop;
    }

    private JSType getJSType(Node n) {
        JSType type = n.getJSType();
        if (type == null) {
            return this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }
        return type;
    }

    private class JSTypeBitSet
    extends BitSet {
        private static final long serialVersionUID = 1L;

        private JSTypeBitSet(int size) {
            super(size);
        }

        @Override
        public String toString() {
            int from = 0;
            int current = 0;
            ArrayList<String> types = new ArrayList<String>();
            while (-1 != (current = this.nextSetBit(from))) {
                types.add(((JSType)AmbiguateProperties.this.intForType.inverse().get(current)).toString());
                from = current + 1;
            }
            return Joiner.on(" && ").join(types);
        }
    }

    private class Property {
        final String oldName;
        String newName;
        int numOccurrences;
        boolean skipAmbiguating;
        JSTypeBitSet relatedTypes;

        Property(String name) {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
            this.oldName = name;
        }

        void addType(JSType newType) {
            if (this.skipAmbiguating) {
                return;
            }
            ++this.numOccurrences;
            if (newType.isUnionType() && (newType = newType.restrictByNotNullOrUndefined()).isUnionType()) {
                for (JSType alt : newType.getUnionMembers()) {
                    this.addNonUnionType(alt);
                }
                return;
            }
            this.addNonUnionType(newType);
        }

        private void addNonUnionType(JSType newType) {
            if (this.skipAmbiguating || AmbiguateProperties.this.invalidatingTypes.isInvalidating(newType)) {
                this.skipAmbiguating = true;
                return;
            }
            if (!this.relatedTypes.get(AmbiguateProperties.this.getIntForType(newType))) {
                AmbiguateProperties.this.computeRelatedTypesForNonUnionType(newType);
                this.relatedTypes.or(AmbiguateProperties.this.getRelatedTypesOnNonUnion(newType));
            }
        }
    }

    private class ProcessProperties
    extends NodeTraversal.AbstractPostOrderCallback {
        private ProcessProperties() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            switch (n.getToken()) {
                case GETPROP: {
                    this.processGetProp(n);
                    return;
                }
                case CALL: {
                    this.processCall(n);
                    return;
                }
                case OBJECTLIT: 
                case OBJECT_PATTERN: {
                    this.processObjectLitOrPattern(n);
                    return;
                }
                case GETELEM: {
                    this.processGetElem(n);
                    return;
                }
                case CLASS: {
                    this.processClass(n);
                    return;
                }
            }
        }

        private void processGetProp(Node getProp) {
            Node propNode = getProp.getSecondChild();
            JSType type = AmbiguateProperties.this.getJSType(getProp.getFirstChild());
            this.maybeMarkCandidate(propNode, type);
        }

        private void processCall(Node call) {
            Node target = call.getFirstChild();
            if (!target.isQualifiedName()) {
                return;
            }
            String renameFunctionName = target.getOriginalQualifiedName();
            if (renameFunctionName != null && AmbiguateProperties.this.compiler.getCodingConvention().isPropertyRenameFunction(renameFunctionName)) {
                int childCount = call.getChildCount();
                if (childCount != 2 && childCount != 3) {
                    AmbiguateProperties.this.reportInvalidRenameFunction(call, renameFunctionName, AmbiguateProperties.WRONG_ARGUMENT_COUNT);
                    return;
                }
                Node propName = call.getSecondChild();
                if (!propName.isString()) {
                    AmbiguateProperties.this.reportInvalidRenameFunction(call, renameFunctionName, AmbiguateProperties.WANT_STRING_LITERAL);
                    return;
                }
                if (propName.getString().contains(".")) {
                    AmbiguateProperties.this.reportInvalidRenameFunction(call, renameFunctionName, AmbiguateProperties.DO_NOT_WANT_PATH);
                    return;
                }
                Property p = AmbiguateProperties.this.getProperty(propName.getString());
                p.skipAmbiguating = true;
            } else if (NodeUtil.isObjectDefinePropertiesDefinition(call)) {
                Node typeObj = call.getSecondChild();
                JSType type = AmbiguateProperties.this.getJSType(typeObj);
                Node objectLiteral = typeObj.getNext();
                if (!objectLiteral.isObjectLit()) {
                    return;
                }
                for (Node key : objectLiteral.children()) {
                    if (key.isQuotedString()) {
                        AmbiguateProperties.this.quotedNames.add(key.getString());
                        continue;
                    }
                    this.maybeMarkCandidate(key, type);
                }
            }
        }

        private void processObjectLitOrPattern(Node objectLit) {
            if (objectLit.getParent().isCall() && NodeUtil.isObjectDefinePropertiesDefinition(objectLit.getParent())) {
                return;
            }
            JSType type = AmbiguateProperties.this.getJSType(objectLit);
            block5: for (Node key = objectLit.getFirstChild(); key != null; key = key.getNext()) {
                switch (key.getToken()) {
                    case COMPUTED_PROP: {
                        if (!key.getFirstChild().isString()) continue block5;
                        AmbiguateProperties.this.quotedNames.add(key.getFirstChild().getString());
                        continue block5;
                    }
                    case MEMBER_FUNCTION_DEF: 
                    case GETTER_DEF: 
                    case SETTER_DEF: 
                    case STRING_KEY: {
                        if (key.isQuotedString()) {
                            AmbiguateProperties.this.quotedNames.add(key.getString());
                            continue block5;
                        }
                        this.maybeMarkCandidate(key, type);
                        continue block5;
                    }
                    case ITER_REST: 
                    case OBJECT_REST: 
                    case ITER_SPREAD: 
                    case OBJECT_SPREAD: {
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected child of " + (Object)((Object)objectLit.getToken()) + ": " + key.toStringTree());
                    }
                }
            }
        }

        private void processGetElem(Node n) {
            Node child = n.getLastChild();
            if (child.isString()) {
                AmbiguateProperties.this.quotedNames.add(child.getString());
            }
        }

        private void processClass(Node classNode) {
            JSType classConstructorType = AmbiguateProperties.this.getJSType(classNode);
            ObjectType classPrototype = classConstructorType.isFunctionType() ? classConstructorType.toMaybeFunctionType().getPrototype() : AmbiguateProperties.this.compiler.getTypeRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
            for (Node member : NodeUtil.getClassMembers(classNode).children()) {
                if (member.isQuotedString()) {
                    AmbiguateProperties.this.quotedNames.add(member.getString());
                    continue;
                }
                if (member.isComputedProp()) {
                    if (!member.getFirstChild().isString()) continue;
                    AmbiguateProperties.this.quotedNames.add(member.getFirstChild().getString());
                    continue;
                }
                if (NodeUtil.isEs6ConstructorMemberFunctionDef(member)) continue;
                JSType memberOwnerType = member.isStaticMember() ? classConstructorType : classPrototype;
                this.maybeMarkCandidate(member, memberOwnerType);
            }
        }

        private void maybeMarkCandidate(Node n, JSType type) {
            String name = n.getString();
            if (!AmbiguateProperties.this.externedNames.contains(name)) {
                AmbiguateProperties.this.stringNodesToRename.add(n);
                this.recordProperty(name, type);
            }
        }

        private Property recordProperty(String name, JSType type) {
            Property prop = AmbiguateProperties.this.getProperty(name);
            prop.addType(type);
            return prop;
        }
    }

    static class PropertyGraphNode
    implements GraphNode<Property, Void> {
        Property property;
        protected Annotation annotation;

        PropertyGraphNode(Property property) {
            this.property = property;
        }

        @Override
        public Property getValue() {
            return this.property;
        }

        @Override
        public <A extends Annotation> A getAnnotation() {
            return (A)this.annotation;
        }

        @Override
        public void setAnnotation(Annotation data) {
            this.annotation = data;
        }
    }

    class PropertySubGraph
    implements SubGraph<Property, Void> {
        JSTypeBitSet relatedTypes;

        PropertySubGraph() {
            this.relatedTypes = new JSTypeBitSet(AmbiguateProperties.this.intForType.size());
        }

        @Override
        public boolean isIndependentOf(Property prop) {
            return !this.relatedTypes.intersects(prop.relatedTypes);
        }

        @Override
        public void addNode(Property prop) {
            this.relatedTypes.or(prop.relatedTypes);
        }
    }

    class PropertyGraph
    implements AdjacencyGraph<Property, Void> {
        private final ArrayList<PropertyGraphNode> nodes;

        PropertyGraph(ArrayList<PropertyGraphNode> nodes) {
            this.nodes = nodes;
        }

        public List<PropertyGraphNode> getNodes() {
            return this.nodes;
        }

        @Override
        public int getNodeCount() {
            return this.nodes.size();
        }

        @Override
        public GraphNode<Property, Void> getNode(Property property) {
            throw new RuntimeException("PropertyGraph#getNode is never called.");
        }

        @Override
        public SubGraph<Property, Void> newSubGraph() {
            return new PropertySubGraph();
        }

        @Override
        public void clearNodeAnnotations() {
            for (PropertyGraphNode node : this.nodes) {
                node.setAnnotation(null);
            }
        }

        @Override
        public int getWeight(Property value) {
            return value.numOccurrences;
        }
    }
}

