/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.trove;

import com.squareup.haha.trove.THash;
import com.squareup.haha.trove.TObjectHashingStrategy;
import com.squareup.haha.trove.TObjectProcedure;

public abstract class TObjectHash<T>
extends THash
implements TObjectHashingStrategy<T> {
    protected transient Object[] _set;
    protected final TObjectHashingStrategy<T> _hashingStrategy = this;
    public static final Object REMOVED = new Object();
    public static final NULL NULL = new NULL();

    @Override
    public TObjectHash<T> clone() {
        TObjectHash h = (TObjectHash)super.clone();
        ((TObjectHash)super.clone())._set = (Object[])this._set.clone();
        return h;
    }

    @Override
    protected final int capacity() {
        return this._set.length;
    }

    @Override
    protected void removeAt(int index) {
        this._set[index] = REMOVED;
        super.removeAt(index);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._set = new Object[capacity];
        return capacity;
    }

    public final boolean forEach(TObjectProcedure<T> procedure) {
        Object[] set = this._set;
        int i = this._set.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object obj) {
        return this.index(obj) >= 0;
    }

    protected final int index(T obj) {
        Object[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
            int probe = 1 + hash % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while ((cur = set[index]) != null && (cur == REMOVED || !this._hashingStrategy.equals(cur, obj)));
        }
        if (cur == null) {
            return -1;
        }
        return index;
    }

    protected final int insertionIndex(T obj) {
        int firstRemoved;
        Object[] set = this._set;
        int length = this._set.length;
        int hash = this._hashingStrategy.computeHashCode(obj) & Integer.MAX_VALUE;
        int index = hash % length;
        Object cur = set[index];
        if (cur == null) {
            return index;
        }
        if (cur != REMOVED && this._hashingStrategy.equals(cur, obj)) {
            return -index - 1;
        }
        int probe = 1 + hash % (length - 2);
        int n = firstRemoved = cur == REMOVED ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            cur = set[index];
            if (firstRemoved != -1 || cur != REMOVED) continue;
            firstRemoved = index;
        } while (cur != null && cur != REMOVED && !this._hashingStrategy.equals(cur, obj));
        if (cur == REMOVED) {
            while (!(cur == null || cur != REMOVED && this._hashingStrategy.equals(cur, obj))) {
                if ((index -= probe) < 0) {
                    index += length;
                }
                cur = set[index];
            }
        }
        if (cur != null && cur != REMOVED) {
            return -index - 1;
        }
        if (firstRemoved == -1) {
            return index;
        }
        return firstRemoved;
    }

    @Override
    public final int computeHashCode(T o) {
        if (o != null) {
            return o.hashCode();
        }
        return 0;
    }

    @Override
    public final boolean equals(T o1, T o2) {
        if (o1 != null) {
            return o1.equals(o2);
        }
        return o2 == null;
    }

    protected final void throwObjectContractViolation(Object o1, Object o2) throws IllegalArgumentException {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals() or TObjectHashingStrategy.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + o1 + (o1 == null ? "" : " (" + o1.getClass() + ")") + ", hashCode=" + this._hashingStrategy.computeHashCode(o1) + "; object #2 =" + o2 + (o2 == null ? "" : " (" + o2.getClass() + ")") + ", hashCode=" + this._hashingStrategy.computeHashCode(o2));
    }

    static final class NULL {
        NULL() {
        }
    }
}

