/*
Open Asset Import Library (assimp)
----------------------------------------------------------------------

Copyright (c) 2006-2017, assimp team

All rights reserved.

Redistribution and use of this software in source and binary forms,
with or without modification, are permitted provided that the
following conditions are met:

* Redistributions of source code must retain the above
copyright notice, this list of conditions and the
following disclaimer.

* Redistributions in binary form must reproduce the above
copyright notice, this list of conditions and the
following disclaimer in the documentation and/or other
materials provided with the distribution.

* Neither the name of the assimp team, nor the names of its
contributors may be used to endorse or promote products
derived from this software without specific prior
written permission of the assimp team.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

----------------------------------------------------------------------
*/
/// \file   X3DVocabulary.cpp
/// \brief  Vocabulary for Fast Infoset encoded binary X3D files.
/// \date   2017
/// \author Patrick Daehne

#ifndef ASSIMP_BUILD_NO_X3D_IMPORTER

#include "FIReader.hpp"

namespace Assimp {

static const char *encodingAlgorithmTable_3_2[] = {
    "encoder://web3d.org/QuantizedFloatArrayEncoder",
    "encoder://web3d.org/DeltazlibIntArrayEncoder",
    "encoder://web3d.org/QuantizedzlibFloatArrayEncoder",
    "encoder://web3d.org/zlibFloatArrayEncoder",
    "encoder://web3d.org/QuantizedDoubleArrayEncoder",
    "encoder://web3d.org/zlibDoubleArrayEncoder",
    "encoder://web3d.org/QuantizedzlibDoubleArrayEncoder",
    "encoder://web3d.org/RangeIntArrayEncoder"
};

static const std::shared_ptr<const FIValue> attributeValueTable_3_2[] = {
    FIStringValue::create("false"),
    FIStringValue::create("true")
};

static const FIQName elementNameTable_3_2[] = {
    { "Shape", nullptr, nullptr },
    { "Appearance", nullptr, nullptr },
    { "Material", nullptr, nullptr },
    { "IndexedFaceSet", nullptr, nullptr },
    { "ProtoInstance", nullptr, nullptr },
    { "Transform", nullptr, nullptr },
    { "ImageTexture", nullptr, nullptr },
    { "TextureTransform", nullptr, nullptr },
    { "Coordinate", nullptr, nullptr },
    { "Normal", nullptr, nullptr },
    { "Color", nullptr, nullptr },
    { "ColorRGBA", nullptr, nullptr },
    { "TextureCoordinate", nullptr, nullptr },
    { "ROUTE", nullptr, nullptr },
    { "fieldValue", nullptr, nullptr },
    { "Group", nullptr, nullptr },
    { "LOD", nullptr, nullptr },
    { "Switch", nullptr, nullptr },
    { "Script", nullptr, nullptr },
    { "IndexedTriangleFanSet", nullptr, nullptr },
    { "IndexedTriangleSet", nullptr, nullptr },
    { "IndexedTriangleStripSet", nullptr, nullptr },
    { "MultiTexture", nullptr, nullptr },
    { "MultiTextureCoordinate", nullptr, nullptr },
    { "MultiTextureTransform", nullptr, nullptr },
    { "IndexedLineSet", nullptr, nullptr },
    { "PointSet", nullptr, nullptr },
    { "StaticGroup", nullptr, nullptr },
    { "Sphere", nullptr, nullptr },
    { "Box", nullptr, nullptr },
    { "Cone", nullptr, nullptr },
    { "Anchor", nullptr, nullptr },
    { "Arc2D", nullptr, nullptr },
    { "ArcClose2D", nullptr, nullptr },
    { "AudioClip", nullptr, nullptr },
    { "Background", nullptr, nullptr },
    { "Billboard", nullptr, nullptr },
    { "BooleanFilter", nullptr, nullptr },
    { "BooleanSequencer", nullptr, nullptr },
    { "BooleanToggle", nullptr, nullptr },
    { "BooleanTrigger", nullptr, nullptr },
    { "Circle2D", nullptr, nullptr },
    { "Collision", nullptr, nullptr },
    { "ColorInterpolator", nullptr, nullptr },
    { "Contour2D", nullptr, nullptr },
    { "ContourPolyline2D", nullptr, nullptr },
    { "CoordinateDouble", nullptr, nullptr },
    { "CoordinateInterpolator", nullptr, nullptr },
    { "CoordinateInterpolator2D", nullptr, nullptr },
    { "Cylinder", nullptr, nullptr },
    { "CylinderSensor", nullptr, nullptr },
    { "DirectionalLight", nullptr, nullptr },
    { "Disk2D", nullptr, nullptr },
    { "EXPORT", nullptr, nullptr },
    { "ElevationGrid", nullptr, nullptr },
    { "EspduTransform", nullptr, nullptr },
    { "ExternProtoDeclare", nullptr, nullptr },
    { "Extrusion", nullptr, nullptr },
    { "FillProperties", nullptr, nullptr },
    { "Fog", nullptr, nullptr },
    { "FontStyle", nullptr, nullptr },
    { "GeoCoordinate", nullptr, nullptr },
    { "GeoElevationGrid", nullptr, nullptr },
    { "GeoLOD", nullptr, nullptr },
    { "GeoLocation", nullptr, nullptr },
    { "GeoMetadata", nullptr, nullptr },
    { "GeoOrigin", nullptr, nullptr },
    { "GeoPositionInterpolator", nullptr, nullptr },
    { "GeoTouchSensor", nullptr, nullptr },
    { "GeoViewpoint", nullptr, nullptr },
    { "HAnimDisplacer", nullptr, nullptr },
    { "HAnimHumanoid", nullptr, nullptr },
    { "HAnimJoint", nullptr, nullptr },
    { "HAnimSegment", nullptr, nullptr },
    { "HAnimSite", nullptr, nullptr },
    { "IMPORT", nullptr, nullptr },
    { "IS", nullptr, nullptr },
    { "Inline", nullptr, nullptr },
    { "IntegerSequencer", nullptr, nullptr },
    { "IntegerTrigger", nullptr, nullptr },
    { "KeySensor", nullptr, nullptr },
    { "LineProperties", nullptr, nullptr },
    { "LineSet", nullptr, nullptr },
    { "LoadSensor", nullptr, nullptr },
    { "MetadataDouble", nullptr, nullptr },
    { "MetadataFloat", nullptr, nullptr },
    { "MetadataInteger", nullptr, nullptr },
    { "MetadataSet", nullptr, nullptr },
    { "MetadataString", nullptr, nullptr },
    { "MovieTexture", nullptr, nullptr },
    { "NavigationInfo", nullptr, nullptr },
    { "NormalInterpolator", nullptr, nullptr },
    { "NurbsCurve", nullptr, nullptr },
    { "NurbsCurve2D", nullptr, nullptr },
    { "NurbsOrientationInterpolator", nullptr, nullptr },
    { "NurbsPatchSurface", nullptr, nullptr },
    { "NurbsPositionInterpolator", nullptr, nullptr },
    { "NurbsSet", nullptr, nullptr },
    { "NurbsSurfaceInterpolator", nullptr, nullptr },
    { "NurbsSweptSurface", nullptr, nullptr },
    { "NurbsSwungSurface", nullptr, nullptr },
    { "NurbsTextureCoordinate", nullptr, nullptr },
    { "NurbsTrimmedSurface", nullptr, nullptr },
    { "OrientationInterpolator", nullptr, nullptr },
    { "PixelTexture", nullptr, nullptr },
    { "PlaneSensor", nullptr, nullptr },
    { "PointLight", nullptr, nullptr },
    { "Polyline2D", nullptr, nullptr },
    { "Polypoint2D", nullptr, nullptr },
    { "PositionInterpolator", nullptr, nullptr },
    { "PositionInterpolator2D", nullptr, nullptr },
    { "ProtoBody", nullptr, nullptr },
    { "ProtoDeclare", nullptr, nullptr },
    { "ProtoInterface", nullptr, nullptr },
    { "ProximitySensor", nullptr, nullptr },
    { "ReceiverPdu", nullptr, nullptr },
    { "Rectangle2D", nullptr, nullptr },
    { "ScalarInterpolator", nullptr, nullptr },
    { "Scene", nullptr, nullptr },
    { "SignalPdu", nullptr, nullptr },
    { "Sound", nullptr, nullptr },
    { "SphereSensor", nullptr, nullptr },
    { "SpotLight", nullptr, nullptr },
    { "StringSensor", nullptr, nullptr },
    { "Text", nullptr, nullptr },
    { "TextureBackground", nullptr, nullptr },
    { "TextureCoordinateGenerator", nullptr, nullptr },
    { "TimeSensor", nullptr, nullptr },
    { "TimeTrigger", nullptr, nullptr },
    { "TouchSensor", nullptr, nullptr },
    { "TransmitterPdu", nullptr, nullptr },
    { "TriangleFanSet", nullptr, nullptr },
    { "TriangleSet", nullptr, nullptr },
    { "TriangleSet2D", nullptr, nullptr },
    { "TriangleStripSet", nullptr, nullptr },
    { "Viewpoint", nullptr, nullptr },
    { "VisibilitySensor", nullptr, nullptr },
    { "WorldInfo", nullptr, nullptr },
    { "X3D", nullptr, nullptr },
    { "component", nullptr, nullptr },
    { "connect", nullptr, nullptr },
    { "field", nullptr, nullptr },
    { "head", nullptr, nullptr },
    { "humanoidBodyType", nullptr, nullptr },
    { "meta", nullptr, nullptr },
    { "CADAssembly", nullptr, nullptr },
    { "CADFace", nullptr, nullptr },
    { "CADLayer", nullptr, nullptr },
    { "CADPart", nullptr, nullptr },
    { "ComposedCubeMapTexture", nullptr, nullptr },
    { "ComposedShader", nullptr, nullptr },
    { "ComposedTexture3D", nullptr, nullptr },
    { "FloatVertexAttribute", nullptr, nullptr },
    { "FogCoordinate", nullptr, nullptr },
    { "GeneratedCubeMapTexture", nullptr, nullptr },
    { "ImageCubeMapTexture", nullptr, nullptr },
    { "ImageTexture3D", nullptr, nullptr },
    { "IndexedQuadSet", nullptr, nullptr },
    { "LocalFog", nullptr, nullptr },
    { "Matrix3VertexAttribute", nullptr, nullptr },
    { "Matrix4VertexAttribute", nullptr, nullptr },
    { "PackagedShader", nullptr, nullptr },
    { "PixelTexture3D", nullptr, nullptr },
    { "ProgramShader", nullptr, nullptr },
    { "QuadSet", nullptr, nullptr },
    { "ShaderPart", nullptr, nullptr },
    { "ShaderProgram", nullptr, nullptr },
    { "TextureCoordinate3D", nullptr, nullptr },
    { "TextureCoordinate4D", nullptr, nullptr },
    { "TextureTransform3D", nullptr, nullptr },
    { "TextureTransformMatrix3D", nullptr, nullptr },
    { "BallJoint", nullptr, nullptr },
    { "BoundedPhysicsModel", nullptr, nullptr },
    { "ClipPlane", nullptr, nullptr },
    { "CollidableOffset", nullptr, nullptr },
    { "CollidableShape", nullptr, nullptr },
    { "CollisionCollection", nullptr, nullptr },
    { "CollisionSensor", nullptr, nullptr },
    { "CollisionSpace", nullptr, nullptr },
    { "ColorDamper", nullptr, nullptr },
    { "ConeEmitter", nullptr, nullptr },
    { "Contact", nullptr, nullptr },
    { "CoordinateDamper", nullptr, nullptr },
    { "DISEntityManager", nullptr, nullptr },
    { "DISEntityTypeMapping", nullptr, nullptr },
    { "DoubleAxisHingeJoint", nullptr, nullptr },
    { "EaseInEaseOut", nullptr, nullptr },
    { "ExplosionEmitter", nullptr, nullptr },
    { "ForcePhysicsModel", nullptr, nullptr },
    { "GeoProximitySensor", nullptr, nullptr },
    { "GeoTransform", nullptr, nullptr },
    { "Layer", nullptr, nullptr },
    { "LayerSet", nullptr, nullptr },
    { "Layout", nullptr, nullptr },
    { "LayoutGroup", nullptr, nullptr },
    { "LayoutLayer", nullptr, nullptr },
    { "LinePickSensor", nullptr, nullptr },
    { "MotorJoint", nullptr, nullptr },
    { "OrientationChaser", nullptr, nullptr },
    { "OrientationDamper", nullptr, nullptr },
    { "OrthoViewpoint", nullptr, nullptr },
    { "ParticleSystem", nullptr, nullptr },
    { "PickableGroup", nullptr, nullptr },
    { "PointEmitter", nullptr, nullptr },
    { "PointPickSensor", nullptr, nullptr },
    { "PolylineEmitter", nullptr, nullptr },
    { "PositionChaser", nullptr, nullptr },
    { "PositionChaser2D", nullptr, nullptr },
    { "PositionDamper", nullptr, nullptr },
    { "PositionDamper2D", nullptr, nullptr },
    { "PrimitivePickSensor", nullptr, nullptr },
    { "RigidBody", nullptr, nullptr },
    { "RigidBodyCollection", nullptr, nullptr },
    { "ScalarChaser", nullptr, nullptr },
    { "ScreenFontStyle", nullptr, nullptr },
    { "ScreenGroup", nullptr, nullptr },
    { "SingleAxisHingeJoint", nullptr, nullptr },
    { "SliderJoint", nullptr, nullptr },
    { "SplinePositionInterpolator", nullptr, nullptr },
    { "SplinePositionInterpolator2D", nullptr, nullptr },
    { "SplineScalarInterpolator", nullptr, nullptr },
    { "SquadOrientationInterpolator", nullptr, nullptr },
    { "SurfaceEmitter", nullptr, nullptr },
    { "TexCoordDamper", nullptr, nullptr },
    { "TextureProperties", nullptr, nullptr },
    { "TransformSensor", nullptr, nullptr },
    { "TwoSidedMaterial", nullptr, nullptr },
    { "UniversalJoint", nullptr, nullptr },
    { "ViewpointGroup", nullptr, nullptr },
    { "Viewport", nullptr, nullptr },
    { "VolumeEmitter", nullptr, nullptr },
    { "VolumePickSensor", nullptr, nullptr },
    { "WindPhysicsModel", nullptr, nullptr }
};

static const FIQName attributeNameTable_3_2[] = {
    { "DEF", nullptr, nullptr },
    { "USE", nullptr, nullptr },
    { "containerField", nullptr, nullptr },
    { "fromNode", nullptr, nullptr },
    { "fromField", nullptr, nullptr },
    { "toNode", nullptr, nullptr },
    { "toField", nullptr, nullptr },
    { "name", nullptr, nullptr },
    { "value", nullptr, nullptr },
    { "color", nullptr, nullptr },
    { "colorIndex", nullptr, nullptr },
    { "coordIndex", nullptr, nullptr },
    { "texCoordIndex", nullptr, nullptr },
    { "normalIndex", nullptr, nullptr },
    { "colorPerVertex", nullptr, nullptr },
    { "normalPerVertex", nullptr, nullptr },
    { "rotation", nullptr, nullptr },
    { "scale", nullptr, nullptr },
    { "center", nullptr, nullptr },
    { "scaleOrientation", nullptr, nullptr },
    { "translation", nullptr, nullptr },
    { "url", nullptr, nullptr },
    { "repeatS", nullptr, nullptr },
    { "repeatT", nullptr, nullptr },
    { "point", nullptr, nullptr },
    { "vector", nullptr, nullptr },
    { "range", nullptr, nullptr },
    { "ambientIntensity", nullptr, nullptr },
    { "diffuseColor", nullptr, nullptr },
    { "emissiveColor", nullptr, nullptr },
    { "shininess", nullptr, nullptr },
    { "specularColor", nullptr, nullptr },
    { "transparency", nullptr, nullptr },
    { "whichChoice", nullptr, nullptr },
    { "index", nullptr, nullptr },
    { "mode", nullptr, nullptr },
    { "source", nullptr, nullptr },
    { "function", nullptr, nullptr },
    { "alpha", nullptr, nullptr },
    { "vertexCount", nullptr, nullptr },
    { "radius", nullptr, nullptr },
    { "size", nullptr, nullptr },
    { "height", nullptr, nullptr },
    { "solid", nullptr, nullptr },
    { "ccw", nullptr, nullptr },
    { "key", nullptr, nullptr },
    { "keyValue", nullptr, nullptr },
    { "enabled", nullptr, nullptr },
    { "direction", nullptr, nullptr },
    { "position", nullptr, nullptr },
    { "orientation", nullptr, nullptr },
    { "bboxCenter", nullptr, nullptr },
    { "bboxSize", nullptr, nullptr },
    { "AS", nullptr, nullptr },
    { "InlineDEF", nullptr, nullptr },
    { "accessType", nullptr, nullptr },
    { "actionKeyPress", nullptr, nullptr },
    { "actionKeyRelease", nullptr, nullptr },
    { "address", nullptr, nullptr },
    { "altKey", nullptr, nullptr },
    { "antennaLocation", nullptr, nullptr },
    { "antennaPatternLength", nullptr, nullptr },
    { "antennaPatternType", nullptr, nullptr },
    { "applicationID", nullptr, nullptr },
    { "articulationParameterArray", nullptr, nullptr },
    { "articulationParameterChangeIndicatorArray", nullptr, nullptr },
    { "articulationParameterCount", nullptr, nullptr },
    { "articulationParameterDesignatorArray", nullptr, nullptr },
    { "articulationParameterIdPartAttachedArray", nullptr, nullptr },
    { "articulationParameterTypeArray", nullptr, nullptr },
    { "attenuation", nullptr, nullptr },
    { "autoOffset", nullptr, nullptr },
    { "avatarSize", nullptr, nullptr },
    { "axisOfRotation", nullptr, nullptr },
    { "backUrl", nullptr, nullptr },
    { "beamWidth", nullptr, nullptr },
    { "beginCap", nullptr, nullptr },
    { "bindTime", nullptr, nullptr },
    { "bottom", nullptr, nullptr },
    { "bottomRadius", nullptr, nullptr },
    { "bottomUrl", nullptr, nullptr },
    { "centerOfMass", nullptr, nullptr },
    { "centerOfRotation", nullptr, nullptr },
    { "child1Url", nullptr, nullptr },
    { "child2Url", nullptr, nullptr },
    { "child3Url", nullptr, nullptr },
    { "child4Url", nullptr, nullptr },
    { "class", nullptr, nullptr },
    { "closureType", nullptr, nullptr },
    { "collideTime", nullptr, nullptr },
    { "content", nullptr, nullptr },
    { "controlKey", nullptr, nullptr },
    { "controlPoint", nullptr, nullptr },
    { "convex", nullptr, nullptr },
    { "coordinateSystem", nullptr, nullptr },
    { "copyright", nullptr, nullptr },
    { "creaseAngle", nullptr, nullptr },
    { "crossSection", nullptr, nullptr },
    { "cryptoKeyID", nullptr, nullptr },
    { "cryptoSystem", nullptr, nullptr },
    { "cutOffAngle", nullptr, nullptr },
    { "cycleInterval", nullptr, nullptr },
    { "cycleTime", nullptr, nullptr },
    { "data", nullptr, nullptr },
    { "dataFormat", nullptr, nullptr },
    { "dataLength", nullptr, nullptr },
    { "dataUrl", nullptr, nullptr },
    { "date", nullptr, nullptr },
    { "deadReckoning", nullptr, nullptr },
    { "deletionAllowed", nullptr, nullptr },
    { "description", nullptr, nullptr },
    { "detonateTime", nullptr, nullptr },
    { "dir", nullptr, nullptr },
    { "directOutput", nullptr, nullptr },
    { "diskAngle", nullptr, nullptr },
    { "displacements", nullptr, nullptr },
    { "documentation", nullptr, nullptr },
    { "elapsedTime", nullptr, nullptr },
    { "ellipsoid", nullptr, nullptr },
    { "encodingScheme", nullptr, nullptr },
    { "endAngle", nullptr, nullptr },
    { "endCap", nullptr, nullptr },
    { "enterTime", nullptr, nullptr },
    { "enteredText", nullptr, nullptr },
    { "entityCategory", nullptr, nullptr },
    { "entityCountry", nullptr, nullptr },
    { "entityDomain", nullptr, nullptr },
    { "entityExtra", nullptr, nullptr },
    { "entityID", nullptr, nullptr },
    { "entityKind", nullptr, nullptr },
    { "entitySpecific", nullptr, nullptr },
    { "entitySubCategory", nullptr, nullptr },
    { "exitTime", nullptr, nullptr },
    { "extent", nullptr, nullptr },
    { "family", nullptr, nullptr },
    { "fanCount", nullptr, nullptr },
    { "fieldOfView", nullptr, nullptr },
    { "filled", nullptr, nullptr },
    { "finalText", nullptr, nullptr },
    { "fireMissionIndex", nullptr, nullptr },
    { "fired1", nullptr, nullptr },
    { "fired2", nullptr, nullptr },
    { "firedTime", nullptr, nullptr },
    { "firingRange", nullptr, nullptr },
    { "firingRate", nullptr, nullptr },
    { "fogType", nullptr, nullptr },
    { "forceID", nullptr, nullptr },
    { "frequency", nullptr, nullptr },
    { "frontUrl", nullptr, nullptr },
    { "fuse", nullptr, nullptr },
    { "geoCoords", nullptr, nullptr },
    { "geoGridOrigin", nullptr, nullptr },
    { "geoSystem", nullptr, nullptr },
    { "groundAngle", nullptr, nullptr },
    { "groundColor", nullptr, nullptr },
    { "hatchColor", nullptr, nullptr },
    { "hatchStyle", nullptr, nullptr },
    { "hatched", nullptr, nullptr },
    { "headlight", nullptr, nullptr },
    { "horizontal", nullptr, nullptr },
    { "horizontalDatum", nullptr, nullptr },
    { "http-equiv", nullptr, nullptr },
    { "image", nullptr, nullptr },
    { "importedDEF", nullptr, nullptr },
    { "info", nullptr, nullptr },
    { "innerRadius", nullptr, nullptr },
    { "inputFalse", nullptr, nullptr },
    { "inputNegate", nullptr, nullptr },
    { "inputSource", nullptr, nullptr },
    { "inputTrue", nullptr, nullptr },
    { "integerKey", nullptr, nullptr },
    { "intensity", nullptr, nullptr },
    { "jump", nullptr, nullptr },
    { "justify", nullptr, nullptr },
    { "keyPress", nullptr, nullptr },
    { "keyRelease", nullptr, nullptr },
    { "knot", nullptr, nullptr },
    { "lang", nullptr, nullptr },
    { "language", nullptr, nullptr },
    { "leftToRight", nullptr, nullptr },
    { "leftUrl", nullptr, nullptr },
    { "length", nullptr, nullptr },
    { "lengthOfModulationParameters", nullptr, nullptr },
    { "level", nullptr, nullptr },
    { "limitOrientation", nullptr, nullptr },
    { "lineSegments", nullptr, nullptr },
    { "linearAcceleration", nullptr, nullptr },
    { "linearVelocity", nullptr, nullptr },
    { "linetype", nullptr, nullptr },
    { "linewidthScaleFactor", nullptr, nullptr },
    { "llimit", nullptr, nullptr },
    { "load", nullptr, nullptr },
    { "loadTime", nullptr, nullptr },
    { "localDEF", nullptr, nullptr },
    { "location", nullptr, nullptr },
    { "loop", nullptr, nullptr },
    { "marking", nullptr, nullptr },
    { "mass", nullptr, nullptr },
    { "maxAngle", nullptr, nullptr },
    { "maxBack", nullptr, nullptr },
    { "maxExtent", nullptr, nullptr },
    { "maxFront", nullptr, nullptr },
    { "maxPosition", nullptr, nullptr },
    { "metadataFormat", nullptr, nullptr },
    { "minAngle", nullptr, nullptr },
    { "minBack", nullptr, nullptr },
    { "minFront", nullptr, nullptr },
    { "minPosition", nullptr, nullptr },
    { "modulationTypeDetail", nullptr, nullptr },
    { "modulationTypeMajor", nullptr, nullptr },
    { "modulationTypeSpreadSpectrum", nullptr, nullptr },
    { "modulationTypeSystem", nullptr, nullptr },
    { "momentsOfInertia", nullptr, nullptr },
    { "multicastRelayHost", nullptr, nullptr },
    { "multicastRelayPort", nullptr, nullptr },
    { "munitionApplicationID", nullptr, nullptr },
    { "munitionEndPoint", nullptr, nullptr },
    { "munitionEntityID", nullptr, nullptr },
    { "munitionQuantity", nullptr, nullptr },
    { "munitionSiteID", nullptr, nullptr },
    { "munitionStartPoint", nullptr, nullptr },
    { "mustEvaluate", nullptr, nullptr },
    { "navType", nullptr, nullptr },
    { "networkMode", nullptr, nullptr },
    { "next", nullptr, nullptr },
    { "nodeField", nullptr, nullptr },
    { "offset", nullptr, nullptr },
    { "on", nullptr, nullptr },
    { "order", nullptr, nullptr },
    { "originator", nullptr, nullptr },
    { "outerRadius", nullptr, nullptr },
    { "parameter", nullptr, nullptr },
    { "pauseTime", nullptr, nullptr },
    { "pitch", nullptr, nullptr },
    { "points", nullptr, nullptr },
    { "port", nullptr, nullptr },
    { "power", nullptr, nullptr },
    { "previous", nullptr, nullptr },
    { "priority", nullptr, nullptr },
    { "profile", nullptr, nullptr },
    { "progress", nullptr, nullptr },
    { "protoField", nullptr, nullptr },
    { "radioEntityTypeCategory", nullptr, nullptr },
    { "radioEntityTypeCountry", nullptr, nullptr },
    { "radioEntityTypeDomain", nullptr, nullptr },
    { "radioEntityTypeKind", nullptr, nullptr },
    { "radioEntityTypeNomenclature", nullptr, nullptr },
    { "radioEntityTypeNomenclatureVersion", nullptr, nullptr },
    { "radioID", nullptr, nullptr },
    { "readInterval", nullptr, nullptr },
    { "receivedPower", nullptr, nullptr },
    { "receiverState", nullptr, nullptr },
    { "reference", nullptr, nullptr },
    { "relativeAntennaLocation", nullptr, nullptr },
    { "resolution", nullptr, nullptr },
    { "resumeTime", nullptr, nullptr },
    { "rightUrl", nullptr, nullptr },
    { "rootUrl", nullptr, nullptr },
    { "rotateYUp", nullptr, nullptr },
    { "rtpHeaderExpected", nullptr, nullptr },
    { "sampleRate", nullptr, nullptr },
    { "samples", nullptr, nullptr },
    { "shiftKey", nullptr, nullptr },
    { "side", nullptr, nullptr },
    { "siteID", nullptr, nullptr },
    { "skinCoordIndex", nullptr, nullptr },
    { "skinCoordWeight", nullptr, nullptr },
    { "skyAngle", nullptr, nullptr },
    { "skyColor", nullptr, nullptr },
    { "spacing", nullptr, nullptr },
    { "spatialize", nullptr, nullptr },
    { "speed", nullptr, nullptr },
    { "speedFactor", nullptr, nullptr },
    { "spine", nullptr, nullptr },
    { "startAngle", nullptr, nullptr },
    { "startTime", nullptr, nullptr },
    { "stiffness", nullptr, nullptr },
    { "stopTime", nullptr, nullptr },
    { "string", nullptr, nullptr },
    { "stripCount", nullptr, nullptr },
    { "style", nullptr, nullptr },
    { "summary", nullptr, nullptr },
    { "tdlType", nullptr, nullptr },
    { "tessellation", nullptr, nullptr },
    { "tessellationScale", nullptr, nullptr },
    { "time", nullptr, nullptr },
    { "timeOut", nullptr, nullptr },
    { "timestamp", nullptr, nullptr },
    { "title", nullptr, nullptr },
    { "toggle", nullptr, nullptr },
    { "top", nullptr, nullptr },
    { "topToBottom", nullptr, nullptr },
    { "topUrl", nullptr, nullptr },
    { "touchTime", nullptr, nullptr },
    { "transmitFrequencyBandwidth", nullptr, nullptr },
    { "transmitState", nullptr, nullptr },
    { "transmitterApplicationID", nullptr, nullptr },
    { "transmitterEntityID", nullptr, nullptr },
    { "transmitterRadioID", nullptr, nullptr },
    { "transmitterSiteID", nullptr, nullptr },
    { "transparent", nullptr, nullptr },
    { "triggerTime", nullptr, nullptr },
    { "triggerTrue", nullptr, nullptr },
    { "triggerValue", nullptr, nullptr },
    { "type", nullptr, nullptr },
    { "uDimension", nullptr, nullptr },
    { "uKnot", nullptr, nullptr },
    { "uOrder", nullptr, nullptr },
    { "uTessellation", nullptr, nullptr },
    { "ulimit", nullptr, nullptr },
    { "vDimension", nullptr, nullptr },
    { "vKnot", nullptr, nullptr },
    { "vOrder", nullptr, nullptr },
    { "vTessellation", nullptr, nullptr },
    { "version", nullptr, nullptr },
    { "verticalDatum", nullptr, nullptr },
    { "vertices", nullptr, nullptr },
    { "visibilityLimit", nullptr, nullptr },
    { "visibilityRange", nullptr, nullptr },
    { "warhead", nullptr, nullptr },
    { "weight", nullptr, nullptr },
    { "whichGeometry", nullptr, nullptr },
    { "writeInterval", nullptr, nullptr },
    { "xDimension", nullptr, nullptr },
    { "xSpacing", nullptr, nullptr },
    { "yScale", nullptr, nullptr },
    { "zDimension", nullptr, nullptr },
    { "zSpacing", nullptr, nullptr },
    { "visible", nullptr, nullptr },
    { "repeatR", nullptr, nullptr },
    { "texture", nullptr, nullptr },
    { "back", nullptr, nullptr },
    { "front", nullptr, nullptr },
    { "left", nullptr, nullptr },
    { "right", nullptr, nullptr },
    { "parts", nullptr, nullptr },
    { "isSelected", nullptr, nullptr },
    { "isValid", nullptr, nullptr },
    { "numComponents", nullptr, nullptr },
    { "depth", nullptr, nullptr },
    { "update", nullptr, nullptr },
    { "fogCoord", nullptr, nullptr },
    { "texCoord", nullptr, nullptr },
    { "activate", nullptr, nullptr },
    { "programs", nullptr, nullptr },
    { "matrix", nullptr, nullptr },
    { "anchorPoint", nullptr, nullptr },
    { "body1", nullptr, nullptr },
    { "body2", nullptr, nullptr },
    { "mustOutput", nullptr, nullptr },
    { "body1AnchorPoint", nullptr, nullptr },
    { "body2AnchorPoint", nullptr, nullptr },
    { "plane", nullptr, nullptr },
    { "appliedParameters", nullptr, nullptr },
    { "bounce", nullptr, nullptr },
    { "frictionCoefficients", nullptr, nullptr },
    { "minBounceSpeed", nullptr, nullptr },
    { "slipFactors", nullptr, nullptr },
    { "softnessConstantForceMix", nullptr, nullptr },
    { "softnessErrorCorrection", nullptr, nullptr },
    { "surfaceSpeed", nullptr, nullptr },
    { "isActive", nullptr, nullptr },
    { "useGeometry", nullptr, nullptr },
    { "set_destination", nullptr, nullptr },
    { "set_value", nullptr, nullptr },
    { "tau", nullptr, nullptr },
    { "tolerance", nullptr, nullptr },
    { "value_changed", nullptr, nullptr },
    { "initialDestination", nullptr, nullptr },
    { "initialValue", nullptr, nullptr },
    { "angle", nullptr, nullptr },
    { "variation", nullptr, nullptr },
    { "surfaceArea", nullptr, nullptr },
    { "frictionDirection", nullptr, nullptr },
    { "slipCoefficients", nullptr, nullptr },
    { "category", nullptr, nullptr },
    { "country", nullptr, nullptr },
    { "domain", nullptr, nullptr },
    { "extra", nullptr, nullptr },
    { "kind", nullptr, nullptr },
    { "specific", nullptr, nullptr },
    { "subcategory", nullptr, nullptr },
    { "axis1", nullptr, nullptr },
    { "axis2", nullptr, nullptr },
    { "desiredAngularVelocity1", nullptr, nullptr },
    { "desiredAngularVelocity2", nullptr, nullptr },
    { "maxAngle1", nullptr, nullptr },
    { "maxTorque1", nullptr, nullptr },
    { "maxTorque2", nullptr, nullptr },
    { "minAngle1", nullptr, nullptr },
    { "stopBounce1", nullptr, nullptr },
    { "stopConstantForceMix1", nullptr, nullptr },
    { "stopErrorCorrection1", nullptr, nullptr },
    { "suspensionErrorCorrection", nullptr, nullptr },
    { "suspensionForce", nullptr, nullptr },
    { "body1Axis", nullptr, nullptr },
    { "body2Axis", nullptr, nullptr },
    { "hinge1Angle", nullptr, nullptr },
    { "hinge1AngleRate", nullptr, nullptr },
    { "hinge2Angle", nullptr, nullptr },
    { "hinge2AngleRate", nullptr, nullptr },
    { "set_fraction", nullptr, nullptr },
    { "easeInEaseOut", nullptr, nullptr },
    { "modifiedFraction_changed", nullptr, nullptr },
    { "force", nullptr, nullptr },
    { "geoCenter", nullptr, nullptr },
    { "centerOfRotation_changed", nullptr, nullptr },
    { "geoCoord_changed", nullptr, nullptr },
    { "orientation_changed", nullptr, nullptr },
    { "position_changed", nullptr, nullptr },
    { "isPickable", nullptr, nullptr },
    { "viewport", nullptr, nullptr },
    { "activeLayer", nullptr, nullptr },
    { "align", nullptr, nullptr },
    { "offsetUnits", nullptr, nullptr },
    { "scaleMode", nullptr, nullptr },
    { "sizeUnits", nullptr, nullptr },
    { "layout", nullptr, nullptr },
    { "objectType", nullptr, nullptr },
    { "pickedNormal", nullptr, nullptr },
    { "pickedPoint", nullptr, nullptr },
    { "pickedTextureCoordinate", nullptr, nullptr },
    { "intersectionType", nullptr, nullptr },
    { "sortOrder", nullptr, nullptr },
    { "axis1Angle", nullptr, nullptr },
    { "axis1Torque", nullptr, nullptr },
    { "axis2Angle", nullptr, nullptr },
    { "axis2Torque", nullptr, nullptr },
    { "axis3Angle", nullptr, nullptr },
    { "axis3Torque", nullptr, nullptr },
    { "enabledAxies", nullptr, nullptr },
    { "motor1Axis", nullptr, nullptr },
    { "motor2Axis", nullptr, nullptr },
    { "motor3Axis", nullptr, nullptr },
    { "stop1Bounce", nullptr, nullptr },
    { "stop1ErrorCorrection", nullptr, nullptr },
    { "stop2Bounce", nullptr, nullptr },
    { "stop2ErrorCorrection", nullptr, nullptr },
    { "stop3Bounce", nullptr, nullptr },
    { "stop3ErrorCorrection", nullptr, nullptr },
    { "motor1Angle", nullptr, nullptr },
    { "motor1AngleRate", nullptr, nullptr },
    { "motor2Angle", nullptr, nullptr },
    { "motor2AngleRate", nullptr, nullptr },
    { "motor3Angle", nullptr, nullptr },
    { "motor3AngleRate", nullptr, nullptr },
    { "autoCalc", nullptr, nullptr },
    { "duration", nullptr, nullptr },
    { "retainUserOffsets", nullptr, nullptr },
    { "isBound", nullptr, nullptr },
    { "appearance", nullptr, nullptr },
    { "createParticles", nullptr, nullptr },
    { "lifetimeVariation", nullptr, nullptr },
    { "maxParticles", nullptr, nullptr },
    { "particleLifetime", nullptr, nullptr },
    { "particleSize", nullptr, nullptr },
    { "colorKey", nullptr, nullptr },
    { "geometryType", nullptr, nullptr },
    { "texCoordKey", nullptr, nullptr },
    { "pickable", nullptr, nullptr },
    { "angularDampingFactor", nullptr, nullptr },
    { "angularVelocity", nullptr, nullptr },
    { "autoDamp", nullptr, nullptr },
    { "autoDisable", nullptr, nullptr },
    { "disableAngularSpeed", nullptr, nullptr },
    { "disableLinearSpeed", nullptr, nullptr },
    { "disableTime", nullptr, nullptr },
    { "finiteRotationAxis", nullptr, nullptr },
    { "fixed", nullptr, nullptr },
    { "forces", nullptr, nullptr },
    { "inertia", nullptr, nullptr },
    { "linearDampingFactor", nullptr, nullptr },
    { "torques", nullptr, nullptr },
    { "useFiniteRotation", nullptr, nullptr },
    { "useGlobalForce", nullptr, nullptr },
    { "constantForceMix", nullptr, nullptr },
    { "constantSurfaceThickness", nullptr, nullptr },
    { "errorCorrection", nullptr, nullptr },
    { "iterations", nullptr, nullptr },
    { "maxCorrectionSpeed", nullptr, nullptr },
    { "preferAccuracy", nullptr, nullptr },
    { "pointSize", nullptr, nullptr },
    { "stopBounce", nullptr, nullptr },
    { "stopErrorCorrection", nullptr, nullptr },
    { "angleRate", nullptr, nullptr },
    { "maxSeparation", nullptr, nullptr },
    { "minSeparation", nullptr, nullptr },
    { "separation", nullptr, nullptr },
    { "separationRate", nullptr, nullptr },
    { "closed", nullptr, nullptr },
    { "keyVelocity", nullptr, nullptr },
    { "normalizeVelocity", nullptr, nullptr },
    { "surface", nullptr, nullptr },
    { "anisotropicDegree", nullptr, nullptr },
    { "borderColor", nullptr, nullptr },
    { "borderWidth", nullptr, nullptr },
    { "boundaryModeS", nullptr, nullptr },
    { "boundaryModeT", nullptr, nullptr },
    { "boundaryModeR", nullptr, nullptr },
    { "magnificationFilter", nullptr, nullptr },
    { "minificationFilter", nullptr, nullptr },
    { "textureCompression", nullptr, nullptr },
    { "texturePriority", nullptr, nullptr },
    { "generateMipMaps", nullptr, nullptr },
    { "targetObject", nullptr, nullptr },
    { "backAmbientIntensity", nullptr, nullptr },
    { "backDiffuseColor", nullptr, nullptr },
    { "backEmissiveColor", nullptr, nullptr },
    { "backShininess", nullptr, nullptr },
    { "backSpecularColor", nullptr, nullptr },
    { "separateBackColor", nullptr, nullptr },
    { "displayed", nullptr, nullptr },
    { "clipBoundary", nullptr, nullptr },
    { "internal", nullptr, nullptr },
    { "gustiness", nullptr, nullptr },
    { "turbulence", nullptr, nullptr }
};

FIVocabulary X3D_vocabulary_3_2 = {
    nullptr, 0,
    encodingAlgorithmTable_3_2, 8,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    attributeValueTable_3_2, 2,
    nullptr, 0,
    nullptr, 0,
    elementNameTable_3_2, 233,
    attributeNameTable_3_2, 516
};

static const char *encodingAlgorithmTable_3_3[] = {
    "encoder://web3d.org/QuantizedFloatArrayEncoder",
    "encoder://web3d.org/DeltazlibIntArrayEncoder",
    "encoder://web3d.org/QuantizedzlibFloatArrayEncoder",
    "encoder://web3d.org/zlibFloatArrayEncoder",
    "encoder://web3d.org/QuantizedDoubleArrayEncoder",
    "encoder://web3d.org/zlibDoubleArrayEncoder",
    "encoder://web3d.org/QuantizedzlibDoubleArrayEncoder",
    "encoder://web3d.org/RangeIntArrayEncoder"
};

static const std::shared_ptr<const FIValue> attributeValueTable_3_3[] = {
    FIStringValue::create("false"),
    FIStringValue::create("true")
};

static const FIQName elementNameTable_3_3[] = {
    { "Shape", nullptr, nullptr },
    { "Appearance", nullptr, nullptr },
    { "Material", nullptr, nullptr },
    { "IndexedFaceSet", nullptr, nullptr },
    { "ProtoInstance", nullptr, nullptr },
    { "Transform", nullptr, nullptr },
    { "ImageTexture", nullptr, nullptr },
    { "TextureTransform", nullptr, nullptr },
    { "Coordinate", nullptr, nullptr },
    { "Normal", nullptr, nullptr },
    { "Color", nullptr, nullptr },
    { "ColorRGBA", nullptr, nullptr },
    { "TextureCoordinate", nullptr, nullptr },
    { "ROUTE", nullptr, nullptr },
    { "fieldValue", nullptr, nullptr },
    { "Group", nullptr, nullptr },
    { "LOD", nullptr, nullptr },
    { "Switch", nullptr, nullptr },
    { "Script", nullptr, nullptr },
    { "IndexedTriangleFanSet", nullptr, nullptr },
    { "IndexedTriangleSet", nullptr, nullptr },
    { "IndexedTriangleStripSet", nullptr, nullptr },
    { "MultiTexture", nullptr, nullptr },
    { "MultiTextureCoordinate", nullptr, nullptr },
    { "MultiTextureTransform", nullptr, nullptr },
    { "IndexedLineSet", nullptr, nullptr },
    { "PointSet", nullptr, nullptr },
    { "StaticGroup", nullptr, nullptr },
    { "Sphere", nullptr, nullptr },
    { "Box", nullptr, nullptr },
    { "Cone", nullptr, nullptr },
    { "Anchor", nullptr, nullptr },
    { "Arc2D", nullptr, nullptr },
    { "ArcClose2D", nullptr, nullptr },
    { "AudioClip", nullptr, nullptr },
    { "Background", nullptr, nullptr },
    { "Billboard", nullptr, nullptr },
    { "BooleanFilter", nullptr, nullptr },
    { "BooleanSequencer", nullptr, nullptr },
    { "BooleanToggle", nullptr, nullptr },
    { "BooleanTrigger", nullptr, nullptr },
    { "Circle2D", nullptr, nullptr },
    { "Collision", nullptr, nullptr },
    { "ColorInterpolator", nullptr, nullptr },
    { "Contour2D", nullptr, nullptr },
    { "ContourPolyline2D", nullptr, nullptr },
    { "CoordinateDouble", nullptr, nullptr },
    { "CoordinateInterpolator", nullptr, nullptr },
    { "CoordinateInterpolator2D", nullptr, nullptr },
    { "Cylinder", nullptr, nullptr },
    { "CylinderSensor", nullptr, nullptr },
    { "DirectionalLight", nullptr, nullptr },
    { "Disk2D", nullptr, nullptr },
    { "EXPORT", nullptr, nullptr },
    { "ElevationGrid", nullptr, nullptr },
    { "EspduTransform", nullptr, nullptr },
    { "ExternProtoDeclare", nullptr, nullptr },
    { "Extrusion", nullptr, nullptr },
    { "FillProperties", nullptr, nullptr },
    { "Fog", nullptr, nullptr },
    { "FontStyle", nullptr, nullptr },
    { "GeoCoordinate", nullptr, nullptr },
    { "GeoElevationGrid", nullptr, nullptr },
    { "GeoLOD", nullptr, nullptr },
    { "GeoLocation", nullptr, nullptr },
    { "GeoMetadata", nullptr, nullptr },
    { "GeoOrigin", nullptr, nullptr },
    { "GeoPositionInterpolator", nullptr, nullptr },
    { "GeoTouchSensor", nullptr, nullptr },
    { "GeoViewpoint", nullptr, nullptr },
    { "HAnimDisplacer", nullptr, nullptr },
    { "HAnimHumanoid", nullptr, nullptr },
    { "HAnimJoint", nullptr, nullptr },
    { "HAnimSegment", nullptr, nullptr },
    { "HAnimSite", nullptr, nullptr },
    { "IMPORT", nullptr, nullptr },
    { "IS", nullptr, nullptr },
    { "Inline", nullptr, nullptr },
    { "IntegerSequencer", nullptr, nullptr },
    { "IntegerTrigger", nullptr, nullptr },
    { "KeySensor", nullptr, nullptr },
    { "LineProperties", nullptr, nullptr },
    { "LineSet", nullptr, nullptr },
    { "LoadSensor", nullptr, nullptr },
    { "MetadataDouble", nullptr, nullptr },
    { "MetadataFloat", nullptr, nullptr },
    { "MetadataInteger", nullptr, nullptr },
    { "MetadataSet", nullptr, nullptr },
    { "MetadataString", nullptr, nullptr },
    { "MovieTexture", nullptr, nullptr },
    { "NavigationInfo", nullptr, nullptr },
    { "NormalInterpolator", nullptr, nullptr },
    { "NurbsCurve", nullptr, nullptr },
    { "NurbsCurve2D", nullptr, nullptr },
    { "NurbsOrientationInterpolator", nullptr, nullptr },
    { "NurbsPatchSurface", nullptr, nullptr },
    { "NurbsPositionInterpolator", nullptr, nullptr },
    { "NurbsSet", nullptr, nullptr },
    { "NurbsSurfaceInterpolator", nullptr, nullptr },
    { "NurbsSweptSurface", nullptr, nullptr },
    { "NurbsSwungSurface", nullptr, nullptr },
    { "NurbsTextureCoordinate", nullptr, nullptr },
    { "NurbsTrimmedSurface", nullptr, nullptr },
    { "OrientationInterpolator", nullptr, nullptr },
    { "PixelTexture", nullptr, nullptr },
    { "PlaneSensor", nullptr, nullptr },
    { "PointLight", nullptr, nullptr },
    { "Polyline2D", nullptr, nullptr },
    { "Polypoint2D", nullptr, nullptr },
    { "PositionInterpolator", nullptr, nullptr },
    { "PositionInterpolator2D", nullptr, nullptr },
    { "ProtoBody", nullptr, nullptr },
    { "ProtoDeclare", nullptr, nullptr },
    { "ProtoInterface", nullptr, nullptr },
    { "ProximitySensor", nullptr, nullptr },
    { "ReceiverPdu", nullptr, nullptr },
    { "Rectangle2D", nullptr, nullptr },
    { "ScalarInterpolator", nullptr, nullptr },
    { "Scene", nullptr, nullptr },
    { "SignalPdu", nullptr, nullptr },
    { "Sound", nullptr, nullptr },
    { "SphereSensor", nullptr, nullptr },
    { "SpotLight", nullptr, nullptr },
    { "StringSensor", nullptr, nullptr },
    { "Text", nullptr, nullptr },
    { "TextureBackground", nullptr, nullptr },
    { "TextureCoordinateGenerator", nullptr, nullptr },
    { "TimeSensor", nullptr, nullptr },
    { "TimeTrigger", nullptr, nullptr },
    { "TouchSensor", nullptr, nullptr },
    { "TransmitterPdu", nullptr, nullptr },
    { "TriangleFanSet", nullptr, nullptr },
    { "TriangleSet", nullptr, nullptr },
    { "TriangleSet2D", nullptr, nullptr },
    { "TriangleStripSet", nullptr, nullptr },
    { "Viewpoint", nullptr, nullptr },
    { "VisibilitySensor", nullptr, nullptr },
    { "WorldInfo", nullptr, nullptr },
    { "X3D", nullptr, nullptr },
    { "component", nullptr, nullptr },
    { "connect", nullptr, nullptr },
    { "field", nullptr, nullptr },
    { "head", nullptr, nullptr },
    { "humanoidBodyType", nullptr, nullptr },
    { "meta", nullptr, nullptr },
    { "CADAssembly", nullptr, nullptr },
    { "CADFace", nullptr, nullptr },
    { "CADLayer", nullptr, nullptr },
    { "CADPart", nullptr, nullptr },
    { "ComposedCubeMapTexture", nullptr, nullptr },
    { "ComposedShader", nullptr, nullptr },
    { "ComposedTexture3D", nullptr, nullptr },
    { "FloatVertexAttribute", nullptr, nullptr },
    { "FogCoordinate", nullptr, nullptr },
    { "GeneratedCubeMapTexture", nullptr, nullptr },
    { "ImageCubeMapTexture", nullptr, nullptr },
    { "ImageTexture3D", nullptr, nullptr },
    { "IndexedQuadSet", nullptr, nullptr },
    { "LocalFog", nullptr, nullptr },
    { "Matrix3VertexAttribute", nullptr, nullptr },
    { "Matrix4VertexAttribute", nullptr, nullptr },
    { "PackagedShader", nullptr, nullptr },
    { "PixelTexture3D", nullptr, nullptr },
    { "ProgramShader", nullptr, nullptr },
    { "QuadSet", nullptr, nullptr },
    { "ShaderPart", nullptr, nullptr },
    { "ShaderProgram", nullptr, nullptr },
    { "TextureCoordinate3D", nullptr, nullptr },
    { "TextureCoordinate4D", nullptr, nullptr },
    { "TextureTransform3D", nullptr, nullptr },
    { "TextureTransformMatrix3D", nullptr, nullptr },
    { "BallJoint", nullptr, nullptr },
    { "BoundedPhysicsModel", nullptr, nullptr },
    { "ClipPlane", nullptr, nullptr },
    { "CollidableOffset", nullptr, nullptr },
    { "CollidableShape", nullptr, nullptr },
    { "CollisionCollection", nullptr, nullptr },
    { "CollisionSensor", nullptr, nullptr },
    { "CollisionSpace", nullptr, nullptr },
    { "ColorDamper", nullptr, nullptr },
    { "ConeEmitter", nullptr, nullptr },
    { "Contact", nullptr, nullptr },
    { "CoordinateDamper", nullptr, nullptr },
    { "DISEntityManager", nullptr, nullptr },
    { "DISEntityTypeMapping", nullptr, nullptr },
    { "DoubleAxisHingeJoint", nullptr, nullptr },
    { "EaseInEaseOut", nullptr, nullptr },
    { "ExplosionEmitter", nullptr, nullptr },
    { "ForcePhysicsModel", nullptr, nullptr },
    { "GeoProximitySensor", nullptr, nullptr },
    { "GeoTransform", nullptr, nullptr },
    { "Layer", nullptr, nullptr },
    { "LayerSet", nullptr, nullptr },
    { "Layout", nullptr, nullptr },
    { "LayoutGroup", nullptr, nullptr },
    { "LayoutLayer", nullptr, nullptr },
    { "LinePickSensor", nullptr, nullptr },
    { "MotorJoint", nullptr, nullptr },
    { "OrientationChaser", nullptr, nullptr },
    { "OrientationDamper", nullptr, nullptr },
    { "OrthoViewpoint", nullptr, nullptr },
    { "ParticleSystem", nullptr, nullptr },
    { "PickableGroup", nullptr, nullptr },
    { "PointEmitter", nullptr, nullptr },
    { "PointPickSensor", nullptr, nullptr },
    { "PolylineEmitter", nullptr, nullptr },
    { "PositionChaser", nullptr, nullptr },
    { "PositionChaser2D", nullptr, nullptr },
    { "PositionDamper", nullptr, nullptr },
    { "PositionDamper2D", nullptr, nullptr },
    { "PrimitivePickSensor", nullptr, nullptr },
    { "RigidBody", nullptr, nullptr },
    { "RigidBodyCollection", nullptr, nullptr },
    { "ScalarChaser", nullptr, nullptr },
    { "ScreenFontStyle", nullptr, nullptr },
    { "ScreenGroup", nullptr, nullptr },
    { "SingleAxisHingeJoint", nullptr, nullptr },
    { "SliderJoint", nullptr, nullptr },
    { "SplinePositionInterpolator", nullptr, nullptr },
    { "SplinePositionInterpolator2D", nullptr, nullptr },
    { "SplineScalarInterpolator", nullptr, nullptr },
    { "SquadOrientationInterpolator", nullptr, nullptr },
    { "SurfaceEmitter", nullptr, nullptr },
    { "TexCoordDamper2D", nullptr, nullptr },
    { "TextureProperties", nullptr, nullptr },
    { "TransformSensor", nullptr, nullptr },
    { "TwoSidedMaterial", nullptr, nullptr },
    { "UniversalJoint", nullptr, nullptr },
    { "ViewpointGroup", nullptr, nullptr },
    { "Viewport", nullptr, nullptr },
    { "VolumeEmitter", nullptr, nullptr },
    { "VolumePickSensor", nullptr, nullptr },
    { "WindPhysicsModel", nullptr, nullptr },
    { "BlendedVolumeStyle", nullptr, nullptr },
    { "BoundaryEnhancementVolumeStyle", nullptr, nullptr },
    { "CartoonVolumeStyle", nullptr, nullptr },
    { "ComposedVolumeStyle", nullptr, nullptr },
    { "EdgeEnhancementVolumeStyle", nullptr, nullptr },
    { "IsoSurfaceVolumeData", nullptr, nullptr },
    { "MetadataBoolean", nullptr, nullptr },
    { "OpacityMapVolumeStyle", nullptr, nullptr },
    { "ProjectionVolumeStyle", nullptr, nullptr },
    { "SegmentedVolumeData", nullptr, nullptr },
    { "ShadedVolumeStyle", nullptr, nullptr },
    { "SilhouetteEnhancementVolumeStyle", nullptr, nullptr },
    { "ToneMappedVolumeStyle", nullptr, nullptr },
    { "VolumeData", nullptr, nullptr },
    { "ColorChaser", nullptr, nullptr },
    { "CoordinateChaser", nullptr, nullptr },
    { "ScalarDamper", nullptr, nullptr },
    { "TexCoordChaser2D", nullptr, nullptr },
    { "unit", nullptr, nullptr }
};

static const FIQName attributeNameTable_3_3[] = {
    { "DEF", nullptr, nullptr },
    { "USE", nullptr, nullptr },
    { "containerField", nullptr, nullptr },
    { "fromNode", nullptr, nullptr },
    { "fromField", nullptr, nullptr },
    { "toNode", nullptr, nullptr },
    { "toField", nullptr, nullptr },
    { "name", nullptr, nullptr },
    { "value", nullptr, nullptr },
    { "color", nullptr, nullptr },
    { "colorIndex", nullptr, nullptr },
    { "coordIndex", nullptr, nullptr },
    { "texCoordIndex", nullptr, nullptr },
    { "normalIndex", nullptr, nullptr },
    { "colorPerVertex", nullptr, nullptr },
    { "normalPerVertex", nullptr, nullptr },
    { "rotation", nullptr, nullptr },
    { "scale", nullptr, nullptr },
    { "center", nullptr, nullptr },
    { "scaleOrientation", nullptr, nullptr },
    { "translation", nullptr, nullptr },
    { "url", nullptr, nullptr },
    { "repeatS", nullptr, nullptr },
    { "repeatT", nullptr, nullptr },
    { "point", nullptr, nullptr },
    { "vector", nullptr, nullptr },
    { "range", nullptr, nullptr },
    { "ambientIntensity", nullptr, nullptr },
    { "diffuseColor", nullptr, nullptr },
    { "emissiveColor", nullptr, nullptr },
    { "shininess", nullptr, nullptr },
    { "specularColor", nullptr, nullptr },
    { "transparency", nullptr, nullptr },
    { "whichChoice", nullptr, nullptr },
    { "index", nullptr, nullptr },
    { "mode", nullptr, nullptr },
    { "source", nullptr, nullptr },
    { "function", nullptr, nullptr },
    { "alpha", nullptr, nullptr },
    { "vertexCount", nullptr, nullptr },
    { "radius", nullptr, nullptr },
    { "size", nullptr, nullptr },
    { "height", nullptr, nullptr },
    { "solid", nullptr, nullptr },
    { "ccw", nullptr, nullptr },
    { "key", nullptr, nullptr },
    { "keyValue", nullptr, nullptr },
    { "enabled", nullptr, nullptr },
    { "direction", nullptr, nullptr },
    { "position", nullptr, nullptr },
    { "orientation", nullptr, nullptr },
    { "bboxCenter", nullptr, nullptr },
    { "bboxSize", nullptr, nullptr },
    { "AS", nullptr, nullptr },
    { "InlineDEF", nullptr, nullptr },
    { "accessType", nullptr, nullptr },
    { "actionKeyPress", nullptr, nullptr },
    { "actionKeyRelease", nullptr, nullptr },
    { "address", nullptr, nullptr },
    { "altKey", nullptr, nullptr },
    { "antennaLocation", nullptr, nullptr },
    { "antennaPatternLength", nullptr, nullptr },
    { "antennaPatternType", nullptr, nullptr },
    { "applicationID", nullptr, nullptr },
    { "articulationParameterArray", nullptr, nullptr },
    { "articulationParameterChangeIndicatorArray", nullptr, nullptr },
    { "articulationParameterCount", nullptr, nullptr },
    { "articulationParameterDesignatorArray", nullptr, nullptr },
    { "articulationParameterIdPartAttachedArray", nullptr, nullptr },
    { "articulationParameterTypeArray", nullptr, nullptr },
    { "attenuation", nullptr, nullptr },
    { "autoOffset", nullptr, nullptr },
    { "avatarSize", nullptr, nullptr },
    { "axisOfRotation", nullptr, nullptr },
    { "backUrl", nullptr, nullptr },
    { "beamWidth", nullptr, nullptr },
    { "beginCap", nullptr, nullptr },
    { "bindTime", nullptr, nullptr },
    { "bottom", nullptr, nullptr },
    { "bottomRadius", nullptr, nullptr },
    { "bottomUrl", nullptr, nullptr },
    { "centerOfMass", nullptr, nullptr },
    { "centerOfRotation", nullptr, nullptr },
    { "child1Url", nullptr, nullptr },
    { "child2Url", nullptr, nullptr },
    { "child3Url", nullptr, nullptr },
    { "child4Url", nullptr, nullptr },
    { "class", nullptr, nullptr },
    { "closureType", nullptr, nullptr },
    { "collideTime", nullptr, nullptr },
    { "content", nullptr, nullptr },
    { "controlKey", nullptr, nullptr },
    { "controlPoint", nullptr, nullptr },
    { "convex", nullptr, nullptr },
    { "coordinateSystem", nullptr, nullptr },
    { "copyright", nullptr, nullptr },
    { "creaseAngle", nullptr, nullptr },
    { "crossSection", nullptr, nullptr },
    { "cryptoKeyID", nullptr, nullptr },
    { "cryptoSystem", nullptr, nullptr },
    { "cutOffAngle", nullptr, nullptr },
    { "cycleInterval", nullptr, nullptr },
    { "cycleTime", nullptr, nullptr },
    { "data", nullptr, nullptr },
    { "dataFormat", nullptr, nullptr },
    { "dataLength", nullptr, nullptr },
    { "dataUrl", nullptr, nullptr },
    { "date", nullptr, nullptr },
    { "deadReckoning", nullptr, nullptr },
    { "deletionAllowed", nullptr, nullptr },
    { "description", nullptr, nullptr },
    { "detonateTime", nullptr, nullptr },
    { "dir", nullptr, nullptr },
    { "directOutput", nullptr, nullptr },
    { "diskAngle", nullptr, nullptr },
    { "displacements", nullptr, nullptr },
    { "documentation", nullptr, nullptr },
    { "elapsedTime", nullptr, nullptr },
    { "ellipsoid", nullptr, nullptr },
    { "encodingScheme", nullptr, nullptr },
    { "endAngle", nullptr, nullptr },
    { "endCap", nullptr, nullptr },
    { "enterTime", nullptr, nullptr },
    { "enteredText", nullptr, nullptr },
    { "entityCategory", nullptr, nullptr },
    { "entityCountry", nullptr, nullptr },
    { "entityDomain", nullptr, nullptr },
    { "entityExtra", nullptr, nullptr },
    { "entityID", nullptr, nullptr },
    { "entityKind", nullptr, nullptr },
    { "entitySpecific", nullptr, nullptr },
    { "entitySubCategory", nullptr, nullptr },
    { "exitTime", nullptr, nullptr },
    { "extent", nullptr, nullptr },
    { "family", nullptr, nullptr },
    { "fanCount", nullptr, nullptr },
    { "fieldOfView", nullptr, nullptr },
    { "filled", nullptr, nullptr },
    { "finalText", nullptr, nullptr },
    { "fireMissionIndex", nullptr, nullptr },
    { "fired1", nullptr, nullptr },
    { "fired2", nullptr, nullptr },
    { "firedTime", nullptr, nullptr },
    { "firingRange", nullptr, nullptr },
    { "firingRate", nullptr, nullptr },
    { "fogType", nullptr, nullptr },
    { "forceID", nullptr, nullptr },
    { "frequency", nullptr, nullptr },
    { "frontUrl", nullptr, nullptr },
    { "fuse", nullptr, nullptr },
    { "geoCoords", nullptr, nullptr },
    { "geoGridOrigin", nullptr, nullptr },
    { "geoSystem", nullptr, nullptr },
    { "groundAngle", nullptr, nullptr },
    { "groundColor", nullptr, nullptr },
    { "hatchColor", nullptr, nullptr },
    { "hatchStyle", nullptr, nullptr },
    { "hatched", nullptr, nullptr },
    { "headlight", nullptr, nullptr },
    { "horizontal", nullptr, nullptr },
    { "horizontalDatum", nullptr, nullptr },
    { "http-equiv", nullptr, nullptr },
    { "image", nullptr, nullptr },
    { "importedDEF", nullptr, nullptr },
    { "info", nullptr, nullptr },
    { "innerRadius", nullptr, nullptr },
    { "inputFalse", nullptr, nullptr },
    { "inputNegate", nullptr, nullptr },
    { "inputSource", nullptr, nullptr },
    { "inputTrue", nullptr, nullptr },
    { "integerKey", nullptr, nullptr },
    { "intensity", nullptr, nullptr },
    { "jump", nullptr, nullptr },
    { "justify", nullptr, nullptr },
    { "keyPress", nullptr, nullptr },
    { "keyRelease", nullptr, nullptr },
    { "knot", nullptr, nullptr },
    { "lang", nullptr, nullptr },
    { "language", nullptr, nullptr },
    { "leftToRight", nullptr, nullptr },
    { "leftUrl", nullptr, nullptr },
    { "length", nullptr, nullptr },
    { "lengthOfModulationParameters", nullptr, nullptr },
    { "level", nullptr, nullptr },
    { "limitOrientation", nullptr, nullptr },
    { "lineSegments", nullptr, nullptr },
    { "linearAcceleration", nullptr, nullptr },
    { "linearVelocity", nullptr, nullptr },
    { "linetype", nullptr, nullptr },
    { "linewidthScaleFactor", nullptr, nullptr },
    { "llimit", nullptr, nullptr },
    { "load", nullptr, nullptr },
    { "loadTime", nullptr, nullptr },
    { "localDEF", nullptr, nullptr },
    { "location", nullptr, nullptr },
    { "loop", nullptr, nullptr },
    { "marking", nullptr, nullptr },
    { "mass", nullptr, nullptr },
    { "maxAngle", nullptr, nullptr },
    { "maxBack", nullptr, nullptr },
    { "maxExtent", nullptr, nullptr },
    { "maxFront", nullptr, nullptr },
    { "maxPosition", nullptr, nullptr },
    { "metadataFormat", nullptr, nullptr },
    { "minAngle", nullptr, nullptr },
    { "minBack", nullptr, nullptr },
    { "minFront", nullptr, nullptr },
    { "minPosition", nullptr, nullptr },
    { "modulationTypeDetail", nullptr, nullptr },
    { "modulationTypeMajor", nullptr, nullptr },
    { "modulationTypeSpreadSpectrum", nullptr, nullptr },
    { "modulationTypeSystem", nullptr, nullptr },
    { "momentsOfInertia", nullptr, nullptr },
    { "multicastRelayHost", nullptr, nullptr },
    { "multicastRelayPort", nullptr, nullptr },
    { "munitionApplicationID", nullptr, nullptr },
    { "munitionEndPoint", nullptr, nullptr },
    { "munitionEntityID", nullptr, nullptr },
    { "munitionQuantity", nullptr, nullptr },
    { "munitionSiteID", nullptr, nullptr },
    { "munitionStartPoint", nullptr, nullptr },
    { "mustEvaluate", nullptr, nullptr },
    { "navType", nullptr, nullptr },
    { "networkMode", nullptr, nullptr },
    { "next", nullptr, nullptr },
    { "nodeField", nullptr, nullptr },
    { "offset", nullptr, nullptr },
    { "on", nullptr, nullptr },
    { "order", nullptr, nullptr },
    { "originator", nullptr, nullptr },
    { "outerRadius", nullptr, nullptr },
    { "parameter", nullptr, nullptr },
    { "pauseTime", nullptr, nullptr },
    { "pitch", nullptr, nullptr },
    { "points", nullptr, nullptr },
    { "port", nullptr, nullptr },
    { "power", nullptr, nullptr },
    { "previous", nullptr, nullptr },
    { "priority", nullptr, nullptr },
    { "profile", nullptr, nullptr },
    { "progress", nullptr, nullptr },
    { "protoField", nullptr, nullptr },
    { "radioEntityTypeCategory", nullptr, nullptr },
    { "radioEntityTypeCountry", nullptr, nullptr },
    { "radioEntityTypeDomain", nullptr, nullptr },
    { "radioEntityTypeKind", nullptr, nullptr },
    { "radioEntityTypeNomenclature", nullptr, nullptr },
    { "radioEntityTypeNomenclatureVersion", nullptr, nullptr },
    { "radioID", nullptr, nullptr },
    { "readInterval", nullptr, nullptr },
    { "receivedPower", nullptr, nullptr },
    { "receiverState", nullptr, nullptr },
    { "reference", nullptr, nullptr },
    { "relativeAntennaLocation", nullptr, nullptr },
    { "resolution", nullptr, nullptr },
    { "resumeTime", nullptr, nullptr },
    { "rightUrl", nullptr, nullptr },
    { "rootUrl", nullptr, nullptr },
    { "rotateYUp", nullptr, nullptr },
    { "rtpHeaderExpected", nullptr, nullptr },
    { "sampleRate", nullptr, nullptr },
    { "samples", nullptr, nullptr },
    { "shiftKey", nullptr, nullptr },
    { "side", nullptr, nullptr },
    { "siteID", nullptr, nullptr },
    { "skinCoordIndex", nullptr, nullptr },
    { "skinCoordWeight", nullptr, nullptr },
    { "skyAngle", nullptr, nullptr },
    { "skyColor", nullptr, nullptr },
    { "spacing", nullptr, nullptr },
    { "spatialize", nullptr, nullptr },
    { "speed", nullptr, nullptr },
    { "speedFactor", nullptr, nullptr },
    { "spine", nullptr, nullptr },
    { "startAngle", nullptr, nullptr },
    { "startTime", nullptr, nullptr },
    { "stiffness", nullptr, nullptr },
    { "stopTime", nullptr, nullptr },
    { "string", nullptr, nullptr },
    { "stripCount", nullptr, nullptr },
    { "style", nullptr, nullptr },
    { "summary", nullptr, nullptr },
    { "tdlType", nullptr, nullptr },
    { "tessellation", nullptr, nullptr },
    { "tessellationScale", nullptr, nullptr },
    { "time", nullptr, nullptr },
    { "timeOut", nullptr, nullptr },
    { "timestamp", nullptr, nullptr },
    { "title", nullptr, nullptr },
    { "toggle", nullptr, nullptr },
    { "top", nullptr, nullptr },
    { "topToBottom", nullptr, nullptr },
    { "topUrl", nullptr, nullptr },
    { "touchTime", nullptr, nullptr },
    { "transmitFrequencyBandwidth", nullptr, nullptr },
    { "transmitState", nullptr, nullptr },
    { "transmitterApplicationID", nullptr, nullptr },
    { "transmitterEntityID", nullptr, nullptr },
    { "transmitterRadioID", nullptr, nullptr },
    { "transmitterSiteID", nullptr, nullptr },
    { "transparent", nullptr, nullptr },
    { "triggerTime", nullptr, nullptr },
    { "triggerTrue", nullptr, nullptr },
    { "triggerValue", nullptr, nullptr },
    { "type", nullptr, nullptr },
    { "uDimension", nullptr, nullptr },
    { "uKnot", nullptr, nullptr },
    { "uOrder", nullptr, nullptr },
    { "uTessellation", nullptr, nullptr },
    { "ulimit", nullptr, nullptr },
    { "vDimension", nullptr, nullptr },
    { "vKnot", nullptr, nullptr },
    { "vOrder", nullptr, nullptr },
    { "vTessellation", nullptr, nullptr },
    { "version", nullptr, nullptr },
    { "verticalDatum", nullptr, nullptr },
    { "vertices", nullptr, nullptr },
    { "visibilityLimit", nullptr, nullptr },
    { "visibilityRange", nullptr, nullptr },
    { "warhead", nullptr, nullptr },
    { "weight", nullptr, nullptr },
    { "whichGeometry", nullptr, nullptr },
    { "writeInterval", nullptr, nullptr },
    { "xDimension", nullptr, nullptr },
    { "xSpacing", nullptr, nullptr },
    { "yScale", nullptr, nullptr },
    { "zDimension", nullptr, nullptr },
    { "zSpacing", nullptr, nullptr },
    { "visible", nullptr, nullptr },
    { "repeatR", nullptr, nullptr },
    { "texture", nullptr, nullptr },
    { "back", nullptr, nullptr },
    { "front", nullptr, nullptr },
    { "left", nullptr, nullptr },
    { "right", nullptr, nullptr },
    { "parts", nullptr, nullptr },
    { "isSelected", nullptr, nullptr },
    { "isValid", nullptr, nullptr },
    { "numComponents", nullptr, nullptr },
    { "depth", nullptr, nullptr },
    { "update", nullptr, nullptr },
    { "fogCoord", nullptr, nullptr },
    { "texCoord", nullptr, nullptr },
    { "activate", nullptr, nullptr },
    { "programs", nullptr, nullptr },
    { "matrix", nullptr, nullptr },
    { "anchorPoint", nullptr, nullptr },
    { "body1", nullptr, nullptr },
    { "body2", nullptr, nullptr },
    { "forceOutput", nullptr, nullptr },
    { "body1AnchorPoint", nullptr, nullptr },
    { "body2AnchorPoint", nullptr, nullptr },
    { "plane", nullptr, nullptr },
    { "appliedParameters", nullptr, nullptr },
    { "bounce", nullptr, nullptr },
    { "frictionCoefficients", nullptr, nullptr },
    { "minBounceSpeed", nullptr, nullptr },
    { "slipFactors", nullptr, nullptr },
    { "softnessConstantForceMix", nullptr, nullptr },
    { "softnessErrorCorrection", nullptr, nullptr },
    { "surfaceSpeed", nullptr, nullptr },
    { "isActive", nullptr, nullptr },
    { "useGeometry", nullptr, nullptr },
    { "set_destination", nullptr, nullptr },
    { "set_value", nullptr, nullptr },
    { "tau", nullptr, nullptr },
    { "tolerance", nullptr, nullptr },
    { "value_changed", nullptr, nullptr },
    { "initialDestination", nullptr, nullptr },
    { "initialValue", nullptr, nullptr },
    { "angle", nullptr, nullptr },
    { "variation", nullptr, nullptr },
    { "surfaceArea", nullptr, nullptr },
    { "frictionDirection", nullptr, nullptr },
    { "slipCoefficients", nullptr, nullptr },
    { "category", nullptr, nullptr },
    { "country", nullptr, nullptr },
    { "domain", nullptr, nullptr },
    { "extra", nullptr, nullptr },
    { "kind", nullptr, nullptr },
    { "specific", nullptr, nullptr },
    { "subcategory", nullptr, nullptr },
    { "axis1", nullptr, nullptr },
    { "axis2", nullptr, nullptr },
    { "desiredAngularVelocity1", nullptr, nullptr },
    { "desiredAngularVelocity2", nullptr, nullptr },
    { "maxAngle1", nullptr, nullptr },
    { "maxTorque1", nullptr, nullptr },
    { "maxTorque2", nullptr, nullptr },
    { "minAngle1", nullptr, nullptr },
    { "stopBounce1", nullptr, nullptr },
    { "stopConstantForceMix1", nullptr, nullptr },
    { "stopErrorCorrection1", nullptr, nullptr },
    { "suspensionErrorCorrection", nullptr, nullptr },
    { "suspensionForce", nullptr, nullptr },
    { "body1Axis", nullptr, nullptr },
    { "body2Axis", nullptr, nullptr },
    { "hinge1Angle", nullptr, nullptr },
    { "hinge1AngleRate", nullptr, nullptr },
    { "hinge2Angle", nullptr, nullptr },
    { "hinge2AngleRate", nullptr, nullptr },
    { "set_fraction", nullptr, nullptr },
    { "easeInEaseOut", nullptr, nullptr },
    { "modifiedFraction_changed", nullptr, nullptr },
    { "force", nullptr, nullptr },
    { "geoCenter", nullptr, nullptr },
    { "centerOfRotation_changed", nullptr, nullptr },
    { "geoCoord_changed", nullptr, nullptr },
    { "orientation_changed", nullptr, nullptr },
    { "position_changed", nullptr, nullptr },
    { "isPickable", nullptr, nullptr },
    { "viewport", nullptr, nullptr },
    { "activeLayer", nullptr, nullptr },
    { "align", nullptr, nullptr },
    { "offsetUnits", nullptr, nullptr },
    { "scaleMode", nullptr, nullptr },
    { "sizeUnits", nullptr, nullptr },
    { "layout", nullptr, nullptr },
    { "objectType", nullptr, nullptr },
    { "pickedNormal", nullptr, nullptr },
    { "pickedPoint", nullptr, nullptr },
    { "pickedTextureCoordinate", nullptr, nullptr },
    { "intersectionType", nullptr, nullptr },
    { "sortOrder", nullptr, nullptr },
    { "axis1Angle", nullptr, nullptr },
    { "axis1Torque", nullptr, nullptr },
    { "axis2Angle", nullptr, nullptr },
    { "axis2Torque", nullptr, nullptr },
    { "axis3Angle", nullptr, nullptr },
    { "axis3Torque", nullptr, nullptr },
    { "enabledAxies", nullptr, nullptr },
    { "motor1Axis", nullptr, nullptr },
    { "motor2Axis", nullptr, nullptr },
    { "motor3Axis", nullptr, nullptr },
    { "stop1Bounce", nullptr, nullptr },
    { "stop1ErrorCorrection", nullptr, nullptr },
    { "stop2Bounce", nullptr, nullptr },
    { "stop2ErrorCorrection", nullptr, nullptr },
    { "stop3Bounce", nullptr, nullptr },
    { "stop3ErrorCorrection", nullptr, nullptr },
    { "motor1Angle", nullptr, nullptr },
    { "motor1AngleRate", nullptr, nullptr },
    { "motor2Angle", nullptr, nullptr },
    { "motor2AngleRate", nullptr, nullptr },
    { "motor3Angle", nullptr, nullptr },
    { "motor3AngleRate", nullptr, nullptr },
    { "autoCalc", nullptr, nullptr },
    { "duration", nullptr, nullptr },
    { "retainUserOffsets", nullptr, nullptr },
    { "isBound", nullptr, nullptr },
    { "appearance", nullptr, nullptr },
    { "createParticles", nullptr, nullptr },
    { "lifetimeVariation", nullptr, nullptr },
    { "maxParticles", nullptr, nullptr },
    { "particleLifetime", nullptr, nullptr },
    { "particleSize", nullptr, nullptr },
    { "colorKey", nullptr, nullptr },
    { "geometryType", nullptr, nullptr },
    { "texCoordKey", nullptr, nullptr },
    { "pickable", nullptr, nullptr },
    { "angularDampingFactor", nullptr, nullptr },
    { "angularVelocity", nullptr, nullptr },
    { "autoDamp", nullptr, nullptr },
    { "autoDisable", nullptr, nullptr },
    { "disableAngularSpeed", nullptr, nullptr },
    { "disableLinearSpeed", nullptr, nullptr },
    { "disableTime", nullptr, nullptr },
    { "finiteRotationAxis", nullptr, nullptr },
    { "fixed", nullptr, nullptr },
    { "forces", nullptr, nullptr },
    { "inertia", nullptr, nullptr },
    { "linearDampingFactor", nullptr, nullptr },
    { "torques", nullptr, nullptr },
    { "useFiniteRotation", nullptr, nullptr },
    { "useGlobalForce", nullptr, nullptr },
    { "constantForceMix", nullptr, nullptr },
    { "constantSurfaceThickness", nullptr, nullptr },
    { "errorCorrection", nullptr, nullptr },
    { "iterations", nullptr, nullptr },
    { "maxCorrectionSpeed", nullptr, nullptr },
    { "preferAccuracy", nullptr, nullptr },
    { "pointSize", nullptr, nullptr },
    { "stopBounce", nullptr, nullptr },
    { "stopErrorCorrection", nullptr, nullptr },
    { "angleRate", nullptr, nullptr },
    { "maxSeparation", nullptr, nullptr },
    { "minSeparation", nullptr, nullptr },
    { "separation", nullptr, nullptr },
    { "separationRate", nullptr, nullptr },
    { "closed", nullptr, nullptr },
    { "keyVelocity", nullptr, nullptr },
    { "normalizeVelocity", nullptr, nullptr },
    { "surface", nullptr, nullptr },
    { "anisotropicDegree", nullptr, nullptr },
    { "borderColor", nullptr, nullptr },
    { "borderWidth", nullptr, nullptr },
    { "boundaryModeS", nullptr, nullptr },
    { "boundaryModeT", nullptr, nullptr },
    { "boundaryModeR", nullptr, nullptr },
    { "magnificationFilter", nullptr, nullptr },
    { "minificationFilter", nullptr, nullptr },
    { "textureCompression", nullptr, nullptr },
    { "texturePriority", nullptr, nullptr },
    { "generateMipMaps", nullptr, nullptr },
    { "targetObject", nullptr, nullptr },
    { "backAmbientIntensity", nullptr, nullptr },
    { "backDiffuseColor", nullptr, nullptr },
    { "backEmissiveColor", nullptr, nullptr },
    { "backShininess", nullptr, nullptr },
    { "backSpecularColor", nullptr, nullptr },
    { "separateBackColor", nullptr, nullptr },
    { "displayed", nullptr, nullptr },
    { "clipBoundary", nullptr, nullptr },
    { "internal", nullptr, nullptr },
    { "gustiness", nullptr, nullptr },
    { "turbulence", nullptr, nullptr },
    { "unitCategory", nullptr, nullptr },
    { "unitName", nullptr, nullptr },
    { "unitConversionFactor", nullptr, nullptr },
    { "weightConstant1", nullptr, nullptr },
    { "weightConstant2", nullptr, nullptr },
    { "weightFunction1", nullptr, nullptr },
    { "weightFunction2", nullptr, nullptr },
    { "boundaryOpacity", nullptr, nullptr },
    { "opacityFactor", nullptr, nullptr },
    { "retainedOpacity", nullptr, nullptr },
    { "colorSteps", nullptr, nullptr },
    { "orthogonalColor", nullptr, nullptr },
    { "parallelColor", nullptr, nullptr },
    { "ordered", nullptr, nullptr },
    { "edgeColor", nullptr, nullptr },
    { "gradientThreshold", nullptr, nullptr },
    { "contourStepSize", nullptr, nullptr },
    { "dimensions", nullptr, nullptr },
    { "surfaceTolerance", nullptr, nullptr },
    { "surfaceValues", nullptr, nullptr },
    { "intensityThreshold", nullptr, nullptr },
    { "segmentEnabled", nullptr, nullptr },
    { "lighting", nullptr, nullptr },
    { "shadows", nullptr, nullptr },
    { "phaseFunction", nullptr, nullptr },
    { "silhouetteBoundaryOpacity", nullptr, nullptr },
    { "silhouetteRetainedOpacity", nullptr, nullptr },
    { "silhouetteSharpness", nullptr, nullptr },
    { "coolColor", nullptr, nullptr },
    { "warmColor", nullptr, nullptr }
};

FIVocabulary X3D_vocabulary_3_3 = {
    nullptr, 0,
    encodingAlgorithmTable_3_3, 8,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    nullptr, 0,
    attributeValueTable_3_3, 2,
    nullptr, 0,
    nullptr, 0,
    elementNameTable_3_3, 252,
    attributeNameTable_3_3, 546
};

}// namespace Assimp

#endif // !ASSIMP_BUILD_NO_X3D_IMPORTER
