/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.content.Context;
import android.view.MotionEvent;
import android.widget.ImageView;
import org.qtproject.qt5.android.CursorHandle;

class CursorView
extends ImageView {
    private CursorHandle mHandle;
    private int m_offsetX;
    private int m_offsetY;

    CursorView(Context context, CursorHandle cursorHandle) {
        super(context);
        this.mHandle = cursorHandle;
    }

    public void adjusted(int n, int n2) {
        this.m_offsetX += n;
        this.m_offsetY += n2;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.m_offsetX = Math.round(motionEvent.getRawX());
                this.m_offsetY = Math.round(motionEvent.getRawY());
                break;
            }
            case 2: {
                this.mHandle.updatePosition(Math.round(motionEvent.getRawX()) - this.m_offsetX, Math.round(motionEvent.getRawY()) - this.m_offsetY);
                break;
            }
            case 1: {
                break;
            }
        }
        return true;
    }
}

