/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Wasm is 'TP' before Qt 6.4.0 (in Qt6 series)

    if (typeof(663) == 'number' && 663 < 640) {
        var dynamicDisplayName = component.value("DisplayName");
        var dynamicDescription = component.value("Description") + "&lt;br&gt;&lt;br&gt;The release of " + dynamicDisplayName + " with Qt 6.6 is a Technology Preview.";
        dynamicDisplayName = dynamicDisplayName + " (TP)";
        component.setValue("DisplayName", dynamicDisplayName);
        component.setValue("Description", dynamicDescription);
    }

    // Wasm requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        // Linux on ARM supported from Qt 6.7 onward
        if ("663" == "dev" || 66 >= 67) {
            if (systemInfo.currentCpuArchitecture == "arm64") {
                hostDependencyStr = "qt.qt6.663.linux_gcc_arm64"
            }
            else {
                hostDependencyStr = "qt.qt6.663.linux_gcc_64"
            }
        }
        else {
            hostDependencyStr = "qt.qt6.663.gcc_64"
        }
    }
    else if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.663.clang_64"
    }
    else if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.663.win64_mingw"
    }
    component.addDependency(hostDependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    // Set path to QT to a variable
    var pathToQt = qtPathUnixSeparators("/6.6.3/wasm_singlethread");

    // patch qmake (.bat)
    component.addOperation("Replace", pathToQt + qmakeScript_663(), originalQmakePath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQmakePath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", pathToQt + qtCMakeScript_663(), originalSetCmakePath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newSetCMakePath_663(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", pathToQt + qtCMakePrivateScript_663(), originalSetCmakePath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newSetCMakePath_663(), "regex");

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64") == true) {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_663());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_663());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_663());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_663());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_663());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_663());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("663" == "dev" || 66 >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_663());
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_663());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", pathToQt + targetQtConf_663(), originalHostPrefix_663(), newHostPrefix_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

    component.addOperation("Replace", pathToQt + targetQtConf_663(), originalHostData_663(), newHostData_663("singlethread"));

    component.addOperation("Replace", pathToQt + targetQtConf_663(), originalHostSpec_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newHostSpec_663());

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", pathToQt + targetQtConf_663(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_663());

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", pathToQt + targetQtConf_663(), targetQtConfDocumentation_663("6.6.3"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", pathToQt + targetQtConf_663(), "\r\n");

        // Patch Qt install paths from QtBuildInternalsExtra.cmake
        component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_663(), originalHostTargetPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), qtPathWinSeparators("/6.6.3/wasm_singlethread"));
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", pathToQt + targetQtConf_663(), "\n");

        // Patch Qt install paths from QtBuildInternalsExtra.cmake
        component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_663(), originalHostTargetPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), pathToQt);
    }
    component.addOperation("AppendFile", pathToQt + targetQtConf_663(), targetQtConfExamples_663("6.6.3"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", pathToQt + qtToolchainCmake_663(), originalQtHostPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQtHostPath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_663(), originalBIPrefix_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), installer.value("TargetDir"));

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", pathToQt + qtPathsScript_663(), originalQtPathsPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQtPathsPath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

    if ("663" == "dev" || 66 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_663(), originalQtHostPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQtHostPath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qmake6Script_663(), originalQmakePath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQmakePath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qtPaths6Script_663(), originalQtPathsPath_663("Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"), newQtPathsPath_663("6.6.3", "Windows-Windows_10_22H2-Clang-Windows-WebAssembly-X86_64"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", pathToQt + qdeviceFile_663(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_663());

    addInitQtPatchOperation(component, platformIdentification_663(), pathToQt, pathToQt + qmakeScript_663(), "qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} WebAssembly (single-threaded)",
                            "--type", "Qt4ProjectManager.QtVersion.WebAssembly",
                            "--qmake", pathToQt + qmakeScript_663(),
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    var kitName = component.name + "_kit";
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addKit",
                            "--id", kitName,
                            "--name", "WebAssembly Qt %{Qt:Version} (single-threaded)",
                            "--Ctoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--Cxxtoolchain", "asmjs-unknown-unknown-emscripten-32bit",
                            "--qt", component.name,
                            "--devicetype", "WebAssemblyDeviceType",
                            "UNDOEXECUTE", "{0,2}",
                            "@SDKToolBinary@", "rmKit", "--id", kitName]);

    // enable WebAssembly Qt Creator plugin
    var settingsFile = installer.value("QtCreatorInstallerSettingsFile");
    component.addOperation("Settings", "path="+settingsFile, "method=add_array_value", "key=Plugins/ForceEnabled", "value=WebAssembly");

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.6.3/wasm_singlethread", "Qt-6.6.3");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", pathToQt + qconfigFile_663(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

