/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.JSDocInfo;
import com.google.javascript.rhino.Node;
import java.util.ArrayList;
import java.util.List;
import org.chromium.devtools.jsdoc.checks.TypeRecord;

public class FunctionRecord {
    final Node functionNode;
    final JSDocInfo info;
    final String name;
    final List<String> parameterNames;
    final TypeRecord enclosingType;
    final FunctionRecord enclosingFunctionRecord;

    public FunctionRecord(Node node, String string, List<String> list, TypeRecord typeRecord, FunctionRecord functionRecord) {
        this.functionNode = node;
        this.info = NodeUtil.getBestJSDocInfo(node);
        this.name = string;
        this.parameterNames = list;
        this.enclosingType = typeRecord;
        this.enclosingFunctionRecord = functionRecord;
    }

    public FunctionRecord() {
        this.functionNode = null;
        this.info = null;
        this.name = "";
        this.parameterNames = new ArrayList<String>();
        this.enclosingType = null;
        this.enclosingFunctionRecord = null;
    }

    public boolean isConstructor() {
        return this.info != null && this.info.isConstructor();
    }

    public boolean isTopLevelFunction() {
        return this.enclosingFunctionRecord == null;
    }

    public boolean hasReturnAnnotation() {
        return this.info != null && this.info.getReturnType() != null;
    }

    public boolean hasThisAnnotation() {
        return this.info != null && this.info.getThisType() != null;
    }

    public boolean suppressesReceiverCheck() {
        return this.info != null && this.info.getOriginalCommentString().contains("@suppressReceiverCheck");
    }

    public boolean suppressesGlobalPropertiesCheck() {
        return this.info != null && this.info.getOriginalCommentString().contains("@suppressGlobalPropertiesCheck");
    }

    public String toString() {
        String string = String.valueOf(String.valueOf(this.info == null ? "" : String.valueOf(this.info.getOriginalCommentString()).concat("\n")));
        String string2 = String.valueOf(String.valueOf(this.name == null ? "<anonymous>" : this.name));
        int n = this.functionNode.getLineno();
        return new StringBuilder(15 + string.length() + string2.length()).append(string).append(string2).append("() @").append(n).toString();
    }
}

