// Copyright 2021 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef WEBLAYER_BROWSER_BLUETOOTH_WEBLAYER_BLUETOOTH_CHOOSER_ANDROID_DELEGATE_H_
#define WEBLAYER_BROWSER_BLUETOOTH_WEBLAYER_BLUETOOTH_CHOOSER_ANDROID_DELEGATE_H_

#include "components/permissions/android/bluetooth_chooser_android_delegate.h"

#include "base/android/scoped_java_ref.h"

namespace weblayer {

// The implementation of BluetoothChooserAndroidDelegate for WebLayer.
class WebLayerBluetoothChooserAndroidDelegate
    : public permissions::BluetoothChooserAndroidDelegate {
 public:
  WebLayerBluetoothChooserAndroidDelegate();

  WebLayerBluetoothChooserAndroidDelegate(
      const WebLayerBluetoothChooserAndroidDelegate&) = delete;
  WebLayerBluetoothChooserAndroidDelegate& operator=(
      const WebLayerBluetoothChooserAndroidDelegate&) = delete;

  ~WebLayerBluetoothChooserAndroidDelegate() override;

  // BluetoothChooserAndroidDelegate implementation:
  base::android::ScopedJavaLocalRef<jobject> GetJavaObject() override;
  security_state::SecurityLevel GetSecurityLevel(
      content::WebContents* web_contents) override;

 private:
  base::android::ScopedJavaGlobalRef<jobject> java_delegate_;
};

}  // namespace weblayer

#endif  // WEBLAYER_BROWSER_BLUETOOTH_WEBLAYER_BLUETOOTH_CHOOSER_ANDROID_DELEGATE_H_
