// Copyright 2020 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_AX_COMMON_H_
#define UI_ACCESSIBILITY_AX_COMMON_H_

#if (!defined(NDEBUG) || defined(ADDRESS_SANITIZER) ||            \
     defined(LEAK_SANITIZER) || defined(MEMORY_SANITIZER) ||      \
     defined(THREAD_SANITIZER) || defined(UNDEFINED_SANITIZER) || \
     DCHECK_IS_ON()) &&                                           \
    !defined(OS_IOS)
// Enable fast fails on clusterfuzz and other builds used to debug Chrome,
// in order to help narrow down illegal states more quickly.
#define AX_FAIL_FAST_BUILD
#endif

// SANITIZER_CHECK's use case is severe, but recoverable situations that need
// priority debugging. They trigger on Clusterfuzz, debug and sanitizer builds.
#if defined(AX_FAIL_FAST_BUILD)
#define SANITIZER_CHECK(val) CHECK(val)
#define SANITIZER_CHECK_EQ(val1, val2) CHECK_EQ(val1, val2)
#define SANITIZER_CHECK_NE(val1, val2) CHECK_NE(val1, val2)
#define SANITIZER_CHECK_LE(val1, val2) CHECK_LE(val1, val2)
#define SANITIZER_CHECK_LT(val1, val2) CHECK_LT(val1, val2)
#define SANITIZER_CHECK_GE(val1, val2) CHECK_GE(val1, val2)
#define SANITIZER_CHECK_GT(val1, val2) CHECK_GT(val1, val2)
#define SANITIZER_NOTREACHED() SANITIZER_CHECK(false)
#else
// Fall back on an ordinary DCHECK.
#define SANITIZER_CHECK(val) DCHECK(val)
#define SANITIZER_CHECK_EQ(val1, val2) DCHECK_EQ(val1, val2)
#define SANITIZER_CHECK_NE(val1, val2) DCHECK_NE(val1, val2)
#define SANITIZER_CHECK_LE(val1, val2) DCHECK_LE(val1, val2)
#define SANITIZER_CHECK_LT(val1, val2) DCHECK_LT(val1, val2)
#define SANITIZER_CHECK_GE(val1, val2) DCHECK_GE(val1, val2)
#define SANITIZER_CHECK_GT(val1, val2) DCHECK_GT(val1, val2)
#define SANITIZER_NOTREACHED() NOTREACHED()
#endif  // AX_FAIL_FAST_BUIL

#endif  // UI_ACCESSIBILITY_AX_COMMON_H_
