# Useful URLs

Chromium has a lot of different pages for a lot of different things.
This page aims to be a repository of useful links that people may find useful.

## Build Status

* [Main buildbot waterfall](http://build.chromium.org/p/chromium/console)
* [Last Known Good Revision](http://chromium-status.appspot.com/lkgr) : Trybots pull this revision from trunk
* [List of the last 100 potential LKGRs](http://chromium-status.appspot.com/revisions)
* [Status dashboard for LKGR](http://build.chromium.org/p/chromium/lkgr-status/)
* http://build.chromium.org/p/tryserver.chromium/waterfall?committer=developer@chromium.org : Trybot runs, by developer
* [Tree uptime stats](http://chromium-status.appspot.com/status_viewer)
* [Commit queue status](http://chromium-cq-status.appspot.com)
* [Pending commit queue jobs](http://codereview.chromium.org/search?closed=3&commit=2&limit=50)
* [Search for historical test failures by test name](http://chromium-build-logs.appspot.com/)
* [Filterable list of most recent build logs](http://chromium-build-logs.appspot.com/list)

## For Sheriffs

* http://build.chromium.org/p/chromium.chromiumos/waterfall?show_events=true&reload=120&failures_only=true : List of failing bots for a waterfall(chromium.chromiumos as an example)
* http://build.chromium.org/p/chromium.linux/waterfall?show_events=true&reload=120&builder=Linux%20Builder%20x64&builder=Linux%20Builder%20(dbg) : Monitor one or multiple bots(Linux Builder x64 and Linux Builder (dbg) on chromium.linux as an example)
* http://build.chromium.org/p/chromium.win/waterfall/help : Customize the waterfall view for a waterfall(using chromium.win as an example)
* [Alternate waterfall view that helps with test failure triage](http://chromium-sheriffing.appspot.com)
* [Lists historical test results for the bots](http://test-results.appspot.com/dashboards/flakiness_dashboard.html)

## Release Information

* [Current release versions of Chrome on all channels](https://omahaproxy.appspot.com/viewer)
* [Looks up the revision of a build/release version](https://omahaproxy.appspot.com/)

## Source Information

* [Code Search](http://cs.chromium.org/)
* http://cs.chromium.org/SEARCH_TERM : Code Search for a specific SEARCH\_TERM 
* [Gitiles Source Code Browser](https://chromium.googlesource.com/chromium/src/)
* https://chromium.googlesource.com/chromium/src/+log/b6cfa6a..9a2e0a8?pretty=fuller : Git changes in revision range(also works for build numbers)
* http://build.chromium.org/f/chromium/perf/dashboard/ui/changelog.html?url=/trunk/src&mode=html&range=SUCCESS_REV:FAILURE_REV : SVN changes in revision range 
* http://build.chromium.org/f/chromium/perf/dashboard/ui/changelog_blink.html?url=/trunk&mode=html&range=SUCCESS_REV:FAILURE_REV : Blink changes in revision range

## Communication

* [Chromium Developers List](http://groups.google.com/a/chromium.org/group/chromium-dev/topics)
* [Chromium Users List](http://groups.google.com/a/chromium.org/group/chromium-discuss/topics)
