/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.perflib;

import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.HprofParser;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.Queries;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.io.MemoryMappedFileBuffer;
import java.io.File;
import java.util.Map;
import java.util.Set;

public class Main {
    public static void main(String[] argv) {
        try {
            long start = System.nanoTime();
            MemoryMappedFileBuffer buffer = new MemoryMappedFileBuffer(new File(argv[0]));
            Snapshot snapshot = new HprofParser(buffer).parse();
            Main.testClassesQuery(snapshot);
            Main.testAllClassesQuery(snapshot);
            Main.testFindInstancesOf(snapshot);
            Main.testFindAllInstancesOf(snapshot);
            System.out.println("Memory stats: free=" + Runtime.getRuntime().freeMemory() + " / total=" + Runtime.getRuntime().totalMemory());
            System.out.println("Time: " + (System.nanoTime() - start) / 1000000L + "ms");
            return;
        }
        catch (Exception exception) {
            Exception e = exception;
            exception.printStackTrace();
            return;
        }
    }

    private static void testClassesQuery(Snapshot snapshot) {
        String[] x = new String[]{"char[", "javax.", "org.xml.sax"};
        Map<String, Set<ClassObj>> someClasses = Queries.classes(snapshot, x);
        for (String thePackage : someClasses.keySet()) {
            System.out.println("------------------- " + thePackage);
            Set<ClassObj> classes = someClasses.get(thePackage);
            for (ClassObj theClass : classes) {
                System.out.println("     " + theClass.mClassName);
            }
        }
    }

    private static void testAllClassesQuery(Snapshot snapshot) {
        Map<String, Set<ClassObj>> allClasses = Queries.allClasses(snapshot);
        for (String thePackage : allClasses.keySet()) {
            System.out.println("------------------- " + thePackage);
            Set<ClassObj> classes = allClasses.get(thePackage);
            for (ClassObj theClass : classes) {
                System.out.println("     " + theClass.mClassName);
            }
        }
    }

    private static void testFindInstancesOf(Snapshot snapshot) {
        Instance[] instances = Queries.instancesOf(snapshot, "java.lang.String");
        System.out.println("There are " + instances.length + " Strings.");
    }

    private static void testFindAllInstancesOf(Snapshot snapshot) {
        Instance[] instances = Queries.allInstancesOf(snapshot, "android.graphics.drawable.Drawable");
        System.out.println("There are " + instances.length + " instances of Drawables and its subclasses.");
    }
}

