/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.DiagnosticType;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSDocInfoBuilder;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChromePass
extends NodeTraversal.AbstractPostOrderCallback
implements CompilerPass {
    final AbstractCompiler compiler;
    private Set<String> createdObjects;
    private static final String CR_DEFINE = "cr.define";
    private static final String CR_EXPORT_PATH = "cr.exportPath";
    private static final String OBJECT_DEFINE_PROPERTY = "Object.defineProperty";
    private static final String CR_DEFINE_PROPERTY = "cr.defineProperty";
    private static final String CR_MAKE_PUBLIC = "cr.makePublic";
    private static final String CR_DEFINE_COMMON_EXPLANATION = "It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');";
    static final DiagnosticType CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS = DiagnosticType.error("JSC_CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS", "cr.define() should have exactly 2 arguments. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_EXPORT_PATH_TOO_FEW_ARGUMENTS = DiagnosticType.error("JSC_CR_EXPORT_PATH_TOO_FEW_ARGUMENTS", "cr.exportPath() should have at least 1 argument: path name.");
    static final DiagnosticType CR_DEFINE_INVALID_FIRST_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_FIRST_ARGUMENT", "Invalid first argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_SECOND_ARGUMENT = DiagnosticType.error("JSC_CR_DEFINE_INVALID_SECOND_ARGUMENT", "Invalid second argument for cr.define(). It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_INVALID_RETURN_IN_FUNCTION = DiagnosticType.error("JSC_CR_DEFINE_INVALID_RETURN_IN_SECOND_ARGUMENT", "Function passed as second argument of cr.define() should return the dictionary in its last statement. It should be called like this: cr.define('name.space', function() '{ ... return {Export: Internal}; }');");
    static final DiagnosticType CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND = DiagnosticType.error("JSC_CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND", "Invalid cr.PropertyKind passed to cr.defineProperty(): expected ATTR, BOOL_ATTR or JS, found \"{0}\".");
    static final DiagnosticType CR_MAKE_PUBLIC_HAS_NO_JSDOC = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_HAS_NO_JSDOC", "Private method exported by cr.makePublic() has no JSDoc.");
    static final DiagnosticType CR_MAKE_PUBLIC_MISSED_DECLARATION = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_MISSED_DECLARATION", "Method \"{1}_\" exported by cr.makePublic() on \"{0}\" has no declaration.");
    static final DiagnosticType CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT = DiagnosticType.error("JSC_CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT", "Invalid second argument passed to cr.makePublic(): should be array of strings.");

    public ChromePass(AbstractCompiler abstractCompiler) {
        this.compiler = abstractCompiler;
        this.createdObjects = new HashSet<String>(Arrays.asList("cr"));
    }

    @Override
    public void process(Node node, Node node2) {
        NodeTraversal.traverse(this.compiler, node2, this);
    }

    @Override
    public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
        if (node.isCall()) {
            Node node3 = node.getFirstChild();
            if (node3.matchesQualifiedName(CR_DEFINE)) {
                this.visitNamespaceDefinition(node, node2);
                this.compiler.reportCodeChange();
            } else if (node3.matchesQualifiedName(CR_EXPORT_PATH)) {
                this.visitExportPath(node, node2);
                this.compiler.reportCodeChange();
            } else if (node3.matchesQualifiedName(OBJECT_DEFINE_PROPERTY) || node3.matchesQualifiedName(CR_DEFINE_PROPERTY)) {
                this.visitPropertyDefinition(node, node2);
                this.compiler.reportCodeChange();
            } else if (node3.matchesQualifiedName(CR_MAKE_PUBLIC) && this.visitMakePublic(node, node2)) {
                this.compiler.reportCodeChange();
            }
        }
    }

    private void visitPropertyDefinition(Node node, Node node2) {
        Node node3 = node.getFirstChild();
        String string = node.getChildAtIndex(1).getQualifiedName();
        if (node3.matchesQualifiedName(CR_DEFINE_PROPERTY) && !string.endsWith(".prototype")) {
            string = string + ".prototype";
        }
        Node node4 = node.getChildAtIndex(2);
        Node node5 = NodeUtil.newQName(this.compiler, string + "." + node4.getString()).srcrefTree(node);
        if (node3.matchesQualifiedName(CR_DEFINE_PROPERTY)) {
            this.setJsDocWithType(node5, this.getTypeByCrPropertyKind(node.getChildAtIndex(3)));
        } else {
            this.setJsDocWithType(node5, new Node(Token.QMARK));
        }
        Node node6 = IR.exprResult(node5).srcref(node2);
        node2.getParent().addChildAfter(node6, node2);
    }

    private Node getTypeByCrPropertyKind(Node node) {
        if (node == null || node.matchesQualifiedName("cr.PropertyKind.JS")) {
            return new Node(Token.QMARK);
        }
        if (node.matchesQualifiedName("cr.PropertyKind.ATTR")) {
            return IR.string("string");
        }
        if (node.matchesQualifiedName("cr.PropertyKind.BOOL_ATTR")) {
            return IR.string("boolean");
        }
        this.compiler.report(JSError.make(node, CR_DEFINE_PROPERTY_INVALID_PROPERTY_KIND, node.getQualifiedName()));
        return null;
    }

    private void setJsDocWithType(Node node, Node node2) {
        JSDocInfoBuilder jSDocInfoBuilder = new JSDocInfoBuilder(false);
        jSDocInfoBuilder.recordType(new JSTypeExpression(node2, ""));
        node.setJSDocInfo(jSDocInfoBuilder.build());
    }

    private boolean visitMakePublic(Node node, Node node2) {
        boolean bl = false;
        Node node3 = node2.getParent();
        String string = node.getChildAtIndex(1).getQualifiedName();
        String string2 = string + ".prototype";
        Node node4 = node.getChildAtIndex(2);
        if (node4 == null || !node4.isArrayLit()) {
            this.compiler.report(JSError.make(node2, CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT, new String[0]));
            return bl;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Node object : node4.children()) {
            if (!object.isString()) {
                this.compiler.report(JSError.make(object, CR_MAKE_PUBLIC_INVALID_SECOND_ARGUMENT, new String[0]));
                return bl;
            }
            hashSet.add(object.getString());
        }
        for (Node node5 : node3.children()) {
            Object object;
            Object object2;
            if (this.isAssignmentToPrototype(node5, string2)) {
                object2 = node5.getFirstChild().getChildAtIndex(1);
                for (Node node6 : ((Node)object2).children()) {
                    String string3 = node6.getString();
                    bl |= this.maybeAddPublicDeclaration(string3, hashSet, string, node6, node3, node2);
                }
                continue;
            }
            if (this.isAssignmentToPrototypeMethod(node5, string2)) {
                object2 = node5.getFirstChild();
                object = ((Node)object2).getFirstChild().getQualifiedName();
                String string4 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
                bl |= this.maybeAddPublicDeclaration(string4, hashSet, string, (Node)object2, node3, node2);
                continue;
            }
            if (!this.isDummyPrototypeMethodDeclaration(node5, string2)) continue;
            object2 = node5.getFirstChild().getQualifiedName();
            object = ((String)object2).substring(((String)object2).lastIndexOf(46) + 1);
            bl |= this.maybeAddPublicDeclaration((String)object, hashSet, string, node5.getFirstChild(), node3, node2);
        }
        for (String string5 : hashSet) {
            this.compiler.report(JSError.make(node2, CR_MAKE_PUBLIC_MISSED_DECLARATION, string, string5));
        }
        return bl;
    }

    private boolean isAssignmentToPrototype(Node node, String string) {
        Node node2;
        return node.isExprResult() && (node2 = node.getFirstChild()).isAssign() && node2.getFirstChild().getQualifiedName().equals(string);
    }

    private boolean isAssignmentToPrototypeMethod(Node node, String string) {
        Node node2;
        return node.isExprResult() && (node2 = node.getFirstChild()).isAssign() && node2.getFirstChild().getQualifiedName().startsWith(string + ".");
    }

    private boolean isDummyPrototypeMethodDeclaration(Node node, String string) {
        Node node2;
        return node.isExprResult() && (node2 = node.getFirstChild()).isGetProp() && node2.getQualifiedName().startsWith(string + ".");
    }

    private boolean maybeAddPublicDeclaration(String string, Set<String> set, String string2, Node node, Node node2, Node node3) {
        String string3;
        boolean bl = false;
        if (string.endsWith("_") && set.contains(string3 = string.substring(0, string.length() - 1))) {
            Node node4 = NodeUtil.newQName(this.compiler, string2 + "." + string3);
            if (node.getJSDocInfo() != null) {
                node4.setJSDocInfo(node.getJSDocInfo());
                node2.addChildBefore(IR.exprResult(node4).srcrefTree(node3), node3);
                bl = true;
            } else {
                this.compiler.report(JSError.make(node, CR_MAKE_PUBLIC_HAS_NO_JSDOC, new String[0]));
            }
            set.remove(string3);
        }
        return bl;
    }

    private void visitExportPath(Node node, Node node2) {
        if (node.getChildCount() < 2) {
            this.compiler.report(JSError.make(node, CR_EXPORT_PATH_TOO_FEW_ARGUMENTS, new String[0]));
            return;
        }
        Node node3 = node.getChildAtIndex(1);
        if (node3.isString()) {
            this.createAndInsertObjectsForQualifiedName(node2, node3.getString());
        }
    }

    private void createAndInsertObjectsForQualifiedName(Node node, String string) {
        List<Node> list = this.createObjectsForQualifiedName(string);
        for (Node node2 : list) {
            node.getParent().addChildBefore(node2, node);
        }
    }

    private void visitNamespaceDefinition(Node node, Node node2) {
        Node node3;
        if (node.getChildCount() != 3) {
            this.compiler.report(JSError.make(node, CR_DEFINE_WRONG_NUMBER_OF_ARGUMENTS, new String[0]));
        }
        Node node4 = node.getChildAtIndex(1);
        Node node5 = node.getChildAtIndex(2);
        if (!node4.isString()) {
            this.compiler.report(JSError.make(node4, CR_DEFINE_INVALID_FIRST_ARGUMENT, new String[0]));
            return;
        }
        String string = node4.getString();
        this.createAndInsertObjectsForQualifiedName(node2, string);
        if (!node5.isFunction()) {
            this.compiler.report(JSError.make(node4, CR_DEFINE_INVALID_SECOND_ARGUMENT, new String[0]));
            return;
        }
        Node node6 = node5.getLastChild();
        Node node7 = node6.getLastChild();
        if (node7 == null || !node7.isReturn() || (node3 = node7.getFirstChild()) == null || !node3.isObjectLit()) {
            this.compiler.report(JSError.make(node4, CR_DEFINE_INVALID_RETURN_IN_FUNCTION, new String[0]));
            return;
        }
        Map<String, String> map = this.objectLitToMap(node3);
        NodeTraversal.traverse(this.compiler, node6, new RenameInternalsToExternalsCallback(string, map, node6));
    }

    private Map<String, String> objectLitToMap(Node node) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Node node2 : node.children()) {
            String string = node2.getString();
            Node node3 = node2.getFirstChild();
            if (!node3.isName()) continue;
            String string2 = node2.getFirstChild().getString();
            hashMap.put(string2, string);
        }
        return hashMap;
    }

    private List<Node> createObjectsForQualifiedName(String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        String[] stringArray = string.split("\\.");
        this.createObjectIfNew(arrayList, stringArray[0], true);
        if (stringArray.length >= 2) {
            StringBuilder stringBuilder = new StringBuilder().append(stringArray[0]);
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuilder.append(".").append(stringArray[i]);
                this.createObjectIfNew(arrayList, stringBuilder.toString(), false);
            }
        }
        return arrayList;
    }

    private void createObjectIfNew(List<Node> list, String string, boolean bl) {
        if (!this.createdObjects.contains(string)) {
            list.add(this.createJsNode((bl ? "var " : "") + string + " = " + string + " || {};"));
            this.createdObjects.add(string);
        }
    }

    private Node createJsNode(String string) {
        return this.compiler.parseSyntheticCode(string).removeFirstChild();
    }

    private class RenameInternalsToExternalsCallback
    extends NodeTraversal.AbstractPostOrderCallback {
        private final String namespaceName;
        private final Map<String, String> exports;
        private final Node namespaceBlock;

        public RenameInternalsToExternalsCallback(String string, Map<String, String> map, Node node) {
            this.namespaceName = string;
            this.exports = map;
            this.namespaceBlock = node;
        }

        @Override
        public void visit(NodeTraversal nodeTraversal, Node node, Node node2) {
            if (node.isFunction() && node2 == this.namespaceBlock && this.exports.containsKey(node.getFirstChild().getString())) {
                Node node3 = node.cloneTree();
                Node node4 = IR.exprResult(IR.assign(this.buildQualifiedName(node.getFirstChild()), node3).srcref(node)).srcref(node);
                if (node.getJSDocInfo() != null) {
                    node4.getFirstChild().setJSDocInfo(node.getJSDocInfo());
                    node3.removeProp(29);
                }
                this.namespaceBlock.replaceChild(node, node4);
            } else if (node.isName() && this.exports.containsKey(node.getString()) && !node2.isFunction()) {
                if (node2.isVar()) {
                    if (node2.getParent() == this.namespaceBlock) {
                        Node node5 = node.removeFirstChild();
                        Node node6 = node5 == null ? IR.exprResult(this.buildQualifiedName(node)).srcref(node2) : IR.exprResult(IR.assign(this.buildQualifiedName(node), node5).srcref(node2)).srcref(node2);
                        if (node2.getJSDocInfo() != null) {
                            node6.getFirstChild().setJSDocInfo(node2.getJSDocInfo().clone());
                        }
                        this.namespaceBlock.replaceChild(node2, node6);
                    }
                } else {
                    Node node7 = this.buildQualifiedName(node);
                    if (node.getJSDocInfo() != null) {
                        node7.setJSDocInfo(node.getJSDocInfo().clone());
                    }
                    if (node2.isCall()) {
                        node2.putBooleanProp(50, false);
                    }
                    node2.replaceChild(node, node7);
                }
            }
        }

        private Node buildQualifiedName(Node node) {
            String string = this.exports.get(node.getString());
            return NodeUtil.newQName(ChromePass.this.compiler, this.namespaceName + "." + string).srcrefTree(node);
        }
    }
}

