// Autogenerated by generate_tests.py, do not edit

// Hack to allow disabling type parameterized test cases.
// See https://github.com/google/googletest/issues/389
#define WRAPPED_TYPED_TEST_P(CaseName, TestName) \
  TYPED_TEST_P(CaseName, TestName)
#define WRAPPED_REGISTER_TYPED_TEST_CASE_P(CaseName, ...) \
  REGISTER_TYPED_TEST_CASE_P(CaseName, __VA_ARGS__)

template <typename PkitsTestDelegate>
class PkitsTest01SignatureVerification : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest01SignatureVerification);

// 4.1.1 Valid Signatures Test1
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1ValidSignaturesTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidCertificatePathTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.1.2 Invalid CA Signature Test2
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1InvalidCASignatureTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "BadSignedCACert",
                               "InvalidCASignatureTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "BadSignedCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.1.3 Invalid EE Signature Test3
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1InvalidEESignatureTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "InvalidEESignatureTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.1.4 Valid DSA Signatures Test4
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1ValidDSASignaturesTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "DSACACert",
                               "ValidDSASignaturesTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "DSACACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.1.5 Valid DSA Parameter Inheritance Test5
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1ValidDSAParameterInheritanceTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "DSACACert",
                               "DSAParametersInheritedCACert",
                               "ValidDSAParameterInheritanceTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "DSACACRL",
                              "DSAParametersInheritedCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.1.6 Invalid DSA Signature Test6
WRAPPED_TYPED_TEST_P(PkitsTest01SignatureVerification,
                     Section1InvalidDSASignatureTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "DSACACert",
                               "InvalidDSASignatureTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "DSACACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(PkitsTest01SignatureVerification,
                                   Section1ValidSignaturesTest1,
                                   Section1InvalidCASignatureTest2,
                                   Section1InvalidEESignatureTest3,
                                   Section1ValidDSASignaturesTest4,
                                   Section1ValidDSAParameterInheritanceTest5,
                                   Section1InvalidDSASignatureTest6);

template <typename PkitsTestDelegate>
class PkitsTest02ValidityPeriods : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest02ValidityPeriods);

// 4.2.1 Invalid CA notBefore Date Test1
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2InvalidCAnotBeforeDateTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BadnotBeforeDateCACert",
                               "InvalidCAnotBeforeDateTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "BadnotBeforeDateCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.2.2 Invalid EE notBefore Date Test2
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2InvalidEEnotBeforeDateTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "InvalidEEnotBeforeDateTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.2.3 Valid pre2000 UTC notBefore Date Test3
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2Validpre2000UTCnotBeforeDateTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "Validpre2000UTCnotBeforeDateTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.2.4 Valid GeneralizedTime notBefore Date Test4
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2ValidGeneralizedTimenotBeforeDateTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidGeneralizedTimenotBeforeDateTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.2.5 Invalid CA notAfter Date Test5
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2InvalidCAnotAfterDateTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BadnotAfterDateCACert",
                               "InvalidCAnotAfterDateTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "BadnotAfterDateCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.2.6 Invalid EE notAfter Date Test6
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2InvalidEEnotAfterDateTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "InvalidEEnotAfterDateTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.2.7 Invalid pre2000 UTC EE notAfter Date Test7
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2Invalidpre2000UTCEEnotAfterDateTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "Invalidpre2000UTCEEnotAfterDateTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.2.8 Valid GeneralizedTime notAfter Date Test8
WRAPPED_TYPED_TEST_P(PkitsTest02ValidityPeriods,
                     Section2ValidGeneralizedTimenotAfterDateTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidGeneralizedTimenotAfterDateTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest02ValidityPeriods,
    Section2InvalidCAnotBeforeDateTest1,
    Section2InvalidEEnotBeforeDateTest2,
    Section2Validpre2000UTCnotBeforeDateTest3,
    Section2ValidGeneralizedTimenotBeforeDateTest4,
    Section2InvalidCAnotAfterDateTest5,
    Section2InvalidEEnotAfterDateTest6,
    Section2Invalidpre2000UTCEEnotAfterDateTest7,
    Section2ValidGeneralizedTimenotAfterDateTest8);

template <typename PkitsTestDelegate>
class PkitsTest03VerifyingNameChaining : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest03VerifyingNameChaining);

// 4.3.1 Invalid Name Chaining EE Test1
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3InvalidNameChainingEETest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "InvalidNameChainingTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.3.2 Invalid Name Chaining Order Test2
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3InvalidNameChainingOrderTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "NameOrderingCACert",
                               "InvalidNameChainingOrderTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "NameOrderCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.3.3 Valid Name Chaining Whitespace Test3
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidNameChainingWhitespaceTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidNameChainingWhitespaceTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.4 Valid Name Chaining Whitespace Test4
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidNameChainingWhitespaceTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidNameChainingWhitespaceTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.5 Valid Name Chaining Capitalization Test5
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidNameChainingCapitalizationTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "ValidNameChainingCapitalizationTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.6 Valid Name Chaining UIDs Test6
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidNameChainingUIDsTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "UIDCACert",
                               "ValidNameUIDsTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "UIDCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.7 Valid RFC3280 Mandatory Attribute Types Test7
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidRFC3280MandatoryAttributeTypesTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "RFC3280MandatoryAttributeTypesCACert",
                               "ValidRFC3280MandatoryAttributeTypesTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "RFC3280MandatoryAttributeTypesCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.8 Valid RFC3280 Optional Attribute Types Test8
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidRFC3280OptionalAttributeTypesTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "RFC3280OptionalAttributeTypesCACert",
                               "ValidRFC3280OptionalAttributeTypesTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "RFC3280OptionalAttributeTypesCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.9 Valid UTF8String Encoded Names Test9
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidUTF8StringEncodedNamesTest9) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "UTF8StringEncodedNamesCACert",
                               "ValidUTF8StringEncodedNamesTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "UTF8StringEncodedNamesCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.10 Valid Rollover from PrintableString to UTF8String Test10
WRAPPED_TYPED_TEST_P(
    PkitsTest03VerifyingNameChaining,
    Section3ValidRolloverfromPrintableStringtoUTF8StringTest10) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "RolloverfromPrintableStringtoUTF8StringCACert",
      "ValidRolloverfromPrintableStringtoUTF8StringTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "RolloverfromPrintableStringtoUTF8StringCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.3.11 Valid UTF8String Case Insensitive Match Test11
WRAPPED_TYPED_TEST_P(PkitsTest03VerifyingNameChaining,
                     Section3ValidUTF8StringCaseInsensitiveMatchTest11) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "UTF8StringCaseInsensitiveMatchCACert",
                               "ValidUTF8StringCaseInsensitiveMatchTest11EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "UTF8StringCaseInsensitiveMatchCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest03VerifyingNameChaining,
    Section3InvalidNameChainingEETest1,
    Section3InvalidNameChainingOrderTest2,
    Section3ValidNameChainingWhitespaceTest3,
    Section3ValidNameChainingWhitespaceTest4,
    Section3ValidNameChainingCapitalizationTest5,
    Section3ValidNameChainingUIDsTest6,
    Section3ValidRFC3280MandatoryAttributeTypesTest7,
    Section3ValidRFC3280OptionalAttributeTypesTest8,
    Section3ValidUTF8StringEncodedNamesTest9,
    Section3ValidRolloverfromPrintableStringtoUTF8StringTest10,
    Section3ValidUTF8StringCaseInsensitiveMatchTest11);

template <typename PkitsTestDelegate>
class PkitsTest04BasicCertificateRevocationTests
    : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest04BasicCertificateRevocationTests);

// 4.4.1 Missing CRL Test1
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4MissingCRLTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "NoCRLCACert",
                               "InvalidMissingCRLTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.2 Invalid Revoked CA Test2
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidRevokedCATest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "RevokedsubCACert", "InvalidRevokedCATest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL",
                              "RevokedsubCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.3 Invalid Revoked EE Test3
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidRevokedEETest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "GoodCACert",
                               "InvalidRevokedEETest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.4 Invalid Bad CRL Signature Test4
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidBadCRLSignatureTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BadCRLSignatureCACert",
                               "InvalidBadCRLSignatureTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "BadCRLSignatureCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.5 Invalid Bad CRL Issuer Name Test5
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidBadCRLIssuerNameTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BadCRLIssuerNameCACert",
                               "InvalidBadCRLIssuerNameTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "BadCRLIssuerNameCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.6 Invalid Wrong CRL Test6
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidWrongCRLTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "WrongCRLCACert",
                               "InvalidWrongCRLTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "WrongCRLCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.7 Valid Two CRLs Test7
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidTwoCRLsTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "TwoCRLsCACert",
                               "ValidTwoCRLsTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "TwoCRLsCAGoodCRL",
                              "TwoCRLsCABadCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.8 Invalid Unknown CRL Entry Extension Test8
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidUnknownCRLEntryExtensionTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "UnknownCRLEntryExtensionCACert",
                               "InvalidUnknownCRLEntryExtensionTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "UnknownCRLEntryExtensionCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.9 Invalid Unknown CRL Extension Test9
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidUnknownCRLExtensionTest9) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "UnknownCRLExtensionCACert",
                               "InvalidUnknownCRLExtensionTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "UnknownCRLExtensionCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.10 Invalid Unknown CRL Extension Test10
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidUnknownCRLExtensionTest10) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "UnknownCRLExtensionCACert",
                               "InvalidUnknownCRLExtensionTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "UnknownCRLExtensionCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.11 Invalid Old CRL nextUpdate Test11
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidOldCRLnextUpdateTest11) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "OldCRLnextUpdateCACert",
                               "InvalidOldCRLnextUpdateTest11EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "OldCRLnextUpdateCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.12 Invalid pre2000 CRL nextUpdate Test12
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4Invalidpre2000CRLnextUpdateTest12) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pre2000CRLnextUpdateCACert",
                               "Invalidpre2000CRLnextUpdateTest12EESeetheintrod"
                               "uctiontoSection4.4formoreinformation."};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "pre2000CRLnextUpdateCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.13 Valid GeneralizedTime CRL nextUpdate Test13
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidGeneralizedTimeCRLnextUpdateTest13) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "GeneralizedTimeCRLnextUpdateCACert",
                               "ValidGeneralizedTimeCRLnextUpdateTest13EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "GeneralizedTimeCRLnextUpdateCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.14 Valid Negative Serial Number Test14
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidNegativeSerialNumberTest14) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "NegativeSerialNumberCACert",
                               "ValidNegativeSerialNumberTest14EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "NegativeSerialNumberCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.15 Invalid Negative Serial Number Test15
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidNegativeSerialNumberTest15) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "NegativeSerialNumberCACert",
                               "InvalidNegativeSerialNumberTest15EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "NegativeSerialNumberCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.16 Valid Long Serial Number Test16
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidLongSerialNumberTest16) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "LongSerialNumberCACert",
                               "ValidLongSerialNumberTest16EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "LongSerialNumberCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.17 Valid Long Serial Number Test17
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidLongSerialNumberTest17) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "LongSerialNumberCACert",
                               "ValidLongSerialNumberTest17EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "LongSerialNumberCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.18 Invalid Long Serial Number Test18
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidLongSerialNumberTest18) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "LongSerialNumberCACert",
                               "InvalidLongSerialNumberTest18EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "LongSerialNumberCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.19 Valid Separate Certificate and CRL Keys Test19
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4ValidSeparateCertificateandCRLKeysTest19) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "SeparateCertificateandCRLKeysCertificateSigningCACert",
      "SeparateCertificateandCRLKeysCRLSigningCert",
      "ValidSeparateCertificateandCRLKeysTest19EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "SeparateCertificateandCRLKeysCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.4.20 Invalid Separate Certificate and CRL Keys Test20
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidSeparateCertificateandCRLKeysTest20) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "SeparateCertificateandCRLKeysCertificateSigningCACert",
      "SeparateCertificateandCRLKeysCRLSigningCert",
      "InvalidSeparateCertificateandCRLKeysTest20EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "SeparateCertificateandCRLKeysCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.4.21 Invalid Separate Certificate and CRL Keys Test21
WRAPPED_TYPED_TEST_P(PkitsTest04BasicCertificateRevocationTests,
                     Section4InvalidSeparateCertificateandCRLKeysTest21) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "SeparateCertificateandCRLKeysCA2CertificateSigningCACert",
      "SeparateCertificateandCRLKeysCA2CRLSigningCert",
      "InvalidSeparateCertificateandCRLKeysTest21EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "SeparateCertificateandCRLKeysCA2CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest04BasicCertificateRevocationTests,
    Section4MissingCRLTest1,
    Section4InvalidRevokedCATest2,
    Section4InvalidRevokedEETest3,
    Section4InvalidBadCRLSignatureTest4,
    Section4InvalidBadCRLIssuerNameTest5,
    Section4InvalidWrongCRLTest6,
    Section4ValidTwoCRLsTest7,
    Section4InvalidUnknownCRLEntryExtensionTest8,
    Section4InvalidUnknownCRLExtensionTest9,
    Section4InvalidUnknownCRLExtensionTest10,
    Section4InvalidOldCRLnextUpdateTest11,
    Section4Invalidpre2000CRLnextUpdateTest12,
    Section4ValidGeneralizedTimeCRLnextUpdateTest13,
    Section4ValidNegativeSerialNumberTest14,
    Section4InvalidNegativeSerialNumberTest15,
    Section4ValidLongSerialNumberTest16,
    Section4ValidLongSerialNumberTest17,
    Section4InvalidLongSerialNumberTest18,
    Section4ValidSeparateCertificateandCRLKeysTest19,
    Section4InvalidSeparateCertificateandCRLKeysTest20,
    Section4InvalidSeparateCertificateandCRLKeysTest21);

template <typename PkitsTestDelegate>
class PkitsTest05VerifyingPathswithSelfIssuedCertificates
    : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates);

// 4.5.1 Valid Basic Self-Issued Old With New Test1
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5ValidBasicSelfIssuedOldWithNewTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedNewKeyCACert",
                               "BasicSelfIssuedNewKeyOldWithNewCACert",
                               "ValidBasicSelfIssuedOldWithNewTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedNewKeyCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.5.2 Invalid Basic Self-Issued Old With New Test2
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5InvalidBasicSelfIssuedOldWithNewTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedNewKeyCACert",
                               "BasicSelfIssuedNewKeyOldWithNewCACert",
                               "InvalidBasicSelfIssuedOldWithNewTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedNewKeyCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.5.3 Valid Basic Self-Issued New With Old Test3
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5ValidBasicSelfIssuedNewWithOldTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedOldKeyCACert",
                               "BasicSelfIssuedOldKeyNewWithOldCACert",
                               "ValidBasicSelfIssuedNewWithOldTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedOldKeySelfIssuedCertCRL",
                              "BasicSelfIssuedOldKeyCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.5.4 Valid Basic Self-Issued New With Old Test4
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5ValidBasicSelfIssuedNewWithOldTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedOldKeyCACert",
                               "BasicSelfIssuedOldKeyNewWithOldCACert",
                               "ValidBasicSelfIssuedNewWithOldTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedOldKeySelfIssuedCertCRL",
                              "BasicSelfIssuedOldKeyCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.5.5 Invalid Basic Self-Issued New With Old Test5
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5InvalidBasicSelfIssuedNewWithOldTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedOldKeyCACert",
                               "BasicSelfIssuedOldKeyNewWithOldCACert",
                               "InvalidBasicSelfIssuedNewWithOldTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedOldKeySelfIssuedCertCRL",
                              "BasicSelfIssuedOldKeyCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.5.6 Valid Basic Self-Issued CRL Signing Key Test6
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5ValidBasicSelfIssuedCRLSigningKeyTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedCRLSigningKeyCACert",
                               "BasicSelfIssuedCRLSigningKeyCRLCert",
                               "ValidBasicSelfIssuedCRLSigningKeyTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedCRLSigningKeyCRLCertCRL",
                              "BasicSelfIssuedCRLSigningKeyCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.5.7 Invalid Basic Self-Issued CRL Signing Key Test7
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5InvalidBasicSelfIssuedCRLSigningKeyTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedCRLSigningKeyCACert",
                               "BasicSelfIssuedCRLSigningKeyCRLCert",
                               "InvalidBasicSelfIssuedCRLSigningKeyTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedCRLSigningKeyCRLCertCRL",
                              "BasicSelfIssuedCRLSigningKeyCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.5.8 Invalid Basic Self-Issued CRL Signing Key Test8
WRAPPED_TYPED_TEST_P(PkitsTest05VerifyingPathswithSelfIssuedCertificates,
                     Section5InvalidBasicSelfIssuedCRLSigningKeyTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "BasicSelfIssuedCRLSigningKeyCACert",
                               "BasicSelfIssuedCRLSigningKeyCRLCert",
                               "InvalidBasicSelfIssuedCRLSigningKeyTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "BasicSelfIssuedCRLSigningKeyCRLCertCRL",
                              "BasicSelfIssuedCRLSigningKeyCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest05VerifyingPathswithSelfIssuedCertificates,
    Section5ValidBasicSelfIssuedOldWithNewTest1,
    Section5InvalidBasicSelfIssuedOldWithNewTest2,
    Section5ValidBasicSelfIssuedNewWithOldTest3,
    Section5ValidBasicSelfIssuedNewWithOldTest4,
    Section5InvalidBasicSelfIssuedNewWithOldTest5,
    Section5ValidBasicSelfIssuedCRLSigningKeyTest6,
    Section5InvalidBasicSelfIssuedCRLSigningKeyTest7,
    Section5InvalidBasicSelfIssuedCRLSigningKeyTest8);

template <typename PkitsTestDelegate>
class PkitsTest06VerifyingBasicConstraints
    : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest06VerifyingBasicConstraints);

// 4.6.1 Invalid Missing basicConstraints Test1
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidMissingbasicConstraintsTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "MissingbasicConstraintsCACert",
                               "InvalidMissingbasicConstraintsTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "MissingbasicConstraintsCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.2 Invalid cA False Test2
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidcAFalseTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "basicConstraintsCriticalcAFalseCACert",
                               "InvalidcAFalseTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "basicConstraintsCriticalcAFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.3 Invalid cA False Test3
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidcAFalseTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "basicConstraintsNotCriticalcAFalseCACert",
                               "InvalidcAFalseTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "basicConstraintsNotCriticalcAFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.4 Valid basicConstraints Not Critical Test4
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidbasicConstraintsNotCriticalTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "basicConstraintsNotCriticalCACert",
                               "ValidbasicConstraintsNotCriticalTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "basicConstraintsNotCriticalCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.5 Invalid pathLenConstraint Test5
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest5) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "pathLenConstraint0CACert",
      "pathLenConstraint0subCACert", "InvalidpathLenConstraintTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL",
                              "pathLenConstraint0subCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.6 Invalid pathLenConstraint Test6
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest6) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "pathLenConstraint0CACert",
      "pathLenConstraint0subCACert", "InvalidpathLenConstraintTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL",
                              "pathLenConstraint0subCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.7 Valid pathLenConstraint Test7
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidpathLenConstraintTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint0CACert",
                               "ValidpathLenConstraintTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.8 Valid pathLenConstraint Test8
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidpathLenConstraintTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint0CACert",
                               "ValidpathLenConstraintTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.9 Invalid pathLenConstraint Test9
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest9) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "pathLenConstraint6CACert",
      "pathLenConstraint6subCA0Cert", "pathLenConstraint6subsubCA00Cert",
      "InvalidpathLenConstraintTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA0CRL",
                              "pathLenConstraint6subsubCA00CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.10 Invalid pathLenConstraint Test10
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest10) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "pathLenConstraint6CACert",
      "pathLenConstraint6subCA0Cert", "pathLenConstraint6subsubCA00Cert",
      "InvalidpathLenConstraintTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA0CRL",
                              "pathLenConstraint6subsubCA00CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.11 Invalid pathLenConstraint Test11
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest11) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint6CACert",
                               "pathLenConstraint6subCA1Cert",
                               "pathLenConstraint6subsubCA11Cert",
                               "pathLenConstraint6subsubsubCA11XCert",
                               "InvalidpathLenConstraintTest11EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA1CRL",
                              "pathLenConstraint6subsubCA11CRL",
                              "pathLenConstraint6subsubsubCA11XCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.12 Invalid pathLenConstraint Test12
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidpathLenConstraintTest12) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint6CACert",
                               "pathLenConstraint6subCA1Cert",
                               "pathLenConstraint6subsubCA11Cert",
                               "pathLenConstraint6subsubsubCA11XCert",
                               "InvalidpathLenConstraintTest12EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA1CRL",
                              "pathLenConstraint6subsubCA11CRL",
                              "pathLenConstraint6subsubsubCA11XCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.13 Valid pathLenConstraint Test13
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidpathLenConstraintTest13) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint6CACert",
                               "pathLenConstraint6subCA4Cert",
                               "pathLenConstraint6subsubCA41Cert",
                               "pathLenConstraint6subsubsubCA41XCert",
                               "ValidpathLenConstraintTest13EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA4CRL",
                              "pathLenConstraint6subsubCA41CRL",
                              "pathLenConstraint6subsubsubCA41XCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.14 Valid pathLenConstraint Test14
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidpathLenConstraintTest14) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint6CACert",
                               "pathLenConstraint6subCA4Cert",
                               "pathLenConstraint6subsubCA41Cert",
                               "pathLenConstraint6subsubsubCA41XCert",
                               "ValidpathLenConstraintTest14EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint6CACRL",
                              "pathLenConstraint6subCA4CRL",
                              "pathLenConstraint6subsubCA41CRL",
                              "pathLenConstraint6subsubsubCA41XCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.15 Valid Self-Issued pathLenConstraint Test15
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidSelfIssuedpathLenConstraintTest15) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint0CACert",
                               "pathLenConstraint0SelfIssuedCACert",
                               "ValidSelfIssuedpathLenConstraintTest15EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.6.16 Invalid Self-Issued pathLenConstraint Test16
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6InvalidSelfIssuedpathLenConstraintTest16) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "pathLenConstraint0CACert",
      "pathLenConstraint0SelfIssuedCACert", "pathLenConstraint0subCA2Cert",
      "InvalidSelfIssuedpathLenConstraintTest16EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint0CACRL",
                              "pathLenConstraint0subCA2CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.6.17 Valid Self-Issued pathLenConstraint Test17
WRAPPED_TYPED_TEST_P(PkitsTest06VerifyingBasicConstraints,
                     Section6ValidSelfIssuedpathLenConstraintTest17) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "pathLenConstraint1CACert",
                               "pathLenConstraint1SelfIssuedCACert",
                               "pathLenConstraint1subCACert",
                               "pathLenConstraint1SelfIssuedsubCACert",
                               "ValidSelfIssuedpathLenConstraintTest17EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "pathLenConstraint1CACRL",
                              "pathLenConstraint1subCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest06VerifyingBasicConstraints,
    Section6InvalidMissingbasicConstraintsTest1,
    Section6InvalidcAFalseTest2,
    Section6InvalidcAFalseTest3,
    Section6ValidbasicConstraintsNotCriticalTest4,
    Section6InvalidpathLenConstraintTest5,
    Section6InvalidpathLenConstraintTest6,
    Section6ValidpathLenConstraintTest7,
    Section6ValidpathLenConstraintTest8,
    Section6InvalidpathLenConstraintTest9,
    Section6InvalidpathLenConstraintTest10,
    Section6InvalidpathLenConstraintTest11,
    Section6InvalidpathLenConstraintTest12,
    Section6ValidpathLenConstraintTest13,
    Section6ValidpathLenConstraintTest14,
    Section6ValidSelfIssuedpathLenConstraintTest15,
    Section6InvalidSelfIssuedpathLenConstraintTest16,
    Section6ValidSelfIssuedpathLenConstraintTest17);

template <typename PkitsTestDelegate>
class PkitsTest07KeyUsage : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest07KeyUsage);

// 4.7.1 Invalid keyUsage Critical keyCertSign False Test1
WRAPPED_TYPED_TEST_P(PkitsTest07KeyUsage,
                     Section7InvalidkeyUsageCriticalkeyCertSignFalseTest1) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "keyUsageCriticalkeyCertSignFalseCACert",
      "InvalidkeyUsageCriticalkeyCertSignFalseTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "keyUsageCriticalkeyCertSignFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.7.2 Invalid keyUsage Not Critical keyCertSign False Test2
WRAPPED_TYPED_TEST_P(PkitsTest07KeyUsage,
                     Section7InvalidkeyUsageNotCriticalkeyCertSignFalseTest2) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "keyUsageNotCriticalkeyCertSignFalseCACert",
      "InvalidkeyUsageNotCriticalkeyCertSignFalseTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "keyUsageNotCriticalkeyCertSignFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.7.3 Valid keyUsage Not Critical Test3
WRAPPED_TYPED_TEST_P(PkitsTest07KeyUsage,
                     Section7ValidkeyUsageNotCriticalTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "keyUsageNotCriticalCACert",
                               "ValidkeyUsageNotCriticalTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "keyUsageNotCriticalCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.7.4 Invalid keyUsage Critical cRLSign False Test4
WRAPPED_TYPED_TEST_P(PkitsTest07KeyUsage,
                     Section7InvalidkeyUsageCriticalcRLSignFalseTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "keyUsageCriticalcRLSignFalseCACert",
                               "InvalidkeyUsageCriticalcRLSignFalseTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "keyUsageCriticalcRLSignFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.7.5 Invalid keyUsage Not Critical cRLSign False Test5
WRAPPED_TYPED_TEST_P(PkitsTest07KeyUsage,
                     Section7InvalidkeyUsageNotCriticalcRLSignFalseTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "keyUsageNotCriticalcRLSignFalseCACert",
                               "InvalidkeyUsageNotCriticalcRLSignFalseTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "keyUsageNotCriticalcRLSignFalseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest07KeyUsage,
    Section7InvalidkeyUsageCriticalkeyCertSignFalseTest1,
    Section7InvalidkeyUsageNotCriticalkeyCertSignFalseTest2,
    Section7ValidkeyUsageNotCriticalTest3,
    Section7InvalidkeyUsageCriticalcRLSignFalseTest4,
    Section7InvalidkeyUsageNotCriticalcRLSignFalseTest5);

// Skipping section 4.8
// Skipped 4.8.1 All Certificates Same Policy Test1
// Skipped 4.8.2 All Certificates No Policies Test2
// Skipped 4.8.3 Different Policies Test3
// Skipped 4.8.4 Different Policies Test4
// Skipped 4.8.5 Different Policies Test5
// Skipped 4.8.6 Overlapping Policies Test6
// Skipped 4.8.7 Different Policies Test7
// Skipped 4.8.8 Different Policies Test8
// Skipped 4.8.9 Different Policies Test9
// Skipped 4.8.10 All Certificates Same Policies Test10
// Skipped 4.8.11 All Certificates AnyPolicy Test11
// Skipped 4.8.12 Different Policies Test12
// Skipped 4.8.13 All Certificates Same Policies Test13
// Skipped 4.8.14 AnyPolicy Test14
// Skipped 4.8.15 User Notice Qualifier Test15
// Skipped 4.8.16 User Notice Qualifier Test16
// Skipped 4.8.17 User Notice Qualifier Test17
// Skipped 4.8.18 User Notice Qualifier Test18
// Skipped 4.8.19 User Notice Qualifier Test19
// Skipped 4.8.20 CPS Pointer Qualifier Test20

// Skipping section 4.9
// Skipped 4.9.1 Valid RequireExplicitPolicy Test1
// Skipped 4.9.2 Valid RequireExplicitPolicy Test2
// Skipped 4.9.3 Invalid RequireExplicitPolicy Test3
// Skipped 4.9.4 Valid RequireExplicitPolicy Test4
// Skipped 4.9.5 Invalid RequireExplicitPolicy Test5
// Skipped 4.9.6 Valid Self-Issued requireExplicitPolicy Test6
// Skipped 4.9.7 Invalid Self-Issued requireExplicitPolicy Test7
// Skipped 4.9.8 Invalid Self-Issued requireExplicitPolicy Test8

// Skipping section 4.10
// Skipped 4.10.1 Valid Policy Mapping Test1
// Skipped 4.10.2 Invalid Policy Mapping Test2
// Skipped 4.10.3 Valid Policy Mapping Test3
// Skipped 4.10.4 Invalid Policy Mapping Test4
// Skipped 4.10.5 Valid Policy Mapping Test5
// Skipped 4.10.6 Valid Policy Mapping Test6
// Skipped 4.10.7 Invalid Mapping From anyPolicy Test7
// Skipped 4.10.8 Invalid Mapping To anyPolicy Test8
// Skipped 4.10.9 Valid Policy Mapping Test9
// Skipped 4.10.10 Invalid Policy Mapping Test10
// Skipped 4.10.11 Valid Policy Mapping Test11
// Skipped 4.10.12 Valid Policy Mapping Test12
// Skipped 4.10.13 Valid Policy Mapping Test13
// Skipped 4.10.14 Valid Policy Mapping Test14

// Skipping section 4.11
// Skipped 4.11.1 Invalid inhibitPolicyMapping Test1
// Skipped 4.11.2 Valid inhibitPolicyMapping Test2
// Skipped 4.11.3 Invalid inhibitPolicyMapping Test3
// Skipped 4.11.4 Valid inhibitPolicyMapping Test4
// Skipped 4.11.5 Invalid inhibitPolicyMapping Test5
// Skipped 4.11.6 Invalid inhibitPolicyMapping Test6
// Skipped 4.11.7 Valid Self-Issued inhibitPolicyMapping Test7
// Skipped 4.11.8 Invalid Self-Issued inhibitPolicyMapping Test8
// Skipped 4.11.9 Invalid Self-Issued inhibitPolicyMapping Test9
// Skipped 4.11.10 Invalid Self-Issued inhibitPolicyMapping Test10
// Skipped 4.11.11 Invalid Self-Issued inhibitPolicyMapping Test11

// Skipping section 4.12
// Skipped 4.12.1 Invalid inhibitAnyPolicy Test1
// Skipped 4.12.2 Valid inhibitAnyPolicy Test2
// Skipped 4.12.3 inhibitAnyPolicy Test3
// Skipped 4.12.4 Invalid inhibitAnyPolicy Test4
// Skipped 4.12.5 Invalid inhibitAnyPolicy Test5
// Skipped 4.12.6 Invalid inhibitAnyPolicy Test6
// Skipped 4.12.7 Valid Self-Issued inhibitAnyPolicy Test7
// Skipped 4.12.8 Invalid Self-Issued inhibitAnyPolicy Test8
// Skipped 4.12.9 Valid Self-Issued inhibitAnyPolicy Test9
// Skipped 4.12.10 Invalid Self-Issued inhibitAnyPolicy Test10

template <typename PkitsTestDelegate>
class PkitsTest13NameConstraints : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest13NameConstraints);

// 4.13.1 Valid DN nameConstraints Test1
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "ValidDNnameConstraintsTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.2 Invalid DN nameConstraints Test2
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "InvalidDNnameConstraintsTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.3 Invalid DN nameConstraints Test3
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "InvalidDNnameConstraintsTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.4 Valid DN nameConstraints Test4
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "ValidDNnameConstraintsTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.5 Valid DN nameConstraints Test5
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN2CACert",
                               "ValidDNnameConstraintsTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN2CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.6 Valid DN nameConstraints Test6
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN3CACert",
                               "ValidDNnameConstraintsTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.7 Invalid DN nameConstraints Test7
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN3CACert",
                               "InvalidDNnameConstraintsTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.8 Invalid DN nameConstraints Test8
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN4CACert",
                               "InvalidDNnameConstraintsTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN4CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.9 Invalid DN nameConstraints Test9
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest9) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN4CACert",
                               "InvalidDNnameConstraintsTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN4CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.10 Invalid DN nameConstraints Test10
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest10) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN5CACert",
                               "InvalidDNnameConstraintsTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN5CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.11 Valid DN nameConstraints Test11
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest11) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN5CACert",
                               "ValidDNnameConstraintsTest11EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN5CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.12 Invalid DN nameConstraints Test12
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest12) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN1CACert",
      "nameConstraintsDN1subCA1Cert", "InvalidDNnameConstraintsTest12EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.13 Invalid DN nameConstraints Test13
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest13) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN1CACert",
      "nameConstraintsDN1subCA2Cert", "InvalidDNnameConstraintsTest13EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA2CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.14 Valid DN nameConstraints Test14
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest14) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN1CACert",
      "nameConstraintsDN1subCA2Cert", "ValidDNnameConstraintsTest14EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA2CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.15 Invalid DN nameConstraints Test15
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest15) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN3CACert",
      "nameConstraintsDN3subCA1Cert", "InvalidDNnameConstraintsTest15EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL",
                              "nameConstraintsDN3subCA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.16 Invalid DN nameConstraints Test16
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest16) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN3CACert",
      "nameConstraintsDN3subCA1Cert", "InvalidDNnameConstraintsTest16EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL",
                              "nameConstraintsDN3subCA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.17 Invalid DN nameConstraints Test17
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNnameConstraintsTest17) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN3CACert",
      "nameConstraintsDN3subCA2Cert", "InvalidDNnameConstraintsTest17EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL",
                              "nameConstraintsDN3subCA2CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.18 Valid DN nameConstraints Test18
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNnameConstraintsTest18) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN3CACert",
      "nameConstraintsDN3subCA2Cert", "ValidDNnameConstraintsTest18EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN3CACRL",
                              "nameConstraintsDN3subCA2CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.19 Valid Self-Issued DN nameConstraints Test19
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidSelfIssuedDNnameConstraintsTest19) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "nameConstraintsDN1CACert",
      "nameConstraintsDN1SelfIssuedCACert", "ValidDNnameConstraintsTest19EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.20 Invalid Self-Issued DN nameConstraints Test20
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidSelfIssuedDNnameConstraintsTest20) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "InvalidDNnameConstraintsTest20EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.21 Valid RFC822 nameConstraints Test21
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidRFC822nameConstraintsTest21) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA1Cert",
                               "ValidRFC822nameConstraintsTest21EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA1CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.22 Invalid RFC822 nameConstraints Test22
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidRFC822nameConstraintsTest22) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA1Cert",
                               "InvalidRFC822nameConstraintsTest22EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.23 Valid RFC822 nameConstraints Test23
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidRFC822nameConstraintsTest23) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA2Cert",
                               "ValidRFC822nameConstraintsTest23EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA2CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.24 Invalid RFC822 nameConstraints Test24
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidRFC822nameConstraintsTest24) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA2Cert",
                               "InvalidRFC822nameConstraintsTest24EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA2CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.25 Valid RFC822 nameConstraints Test25
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidRFC822nameConstraintsTest25) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA3Cert",
                               "ValidRFC822nameConstraintsTest25EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA3CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.26 Invalid RFC822 nameConstraints Test26
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidRFC822nameConstraintsTest26) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsRFC822CA3Cert",
                               "InvalidRFC822nameConstraintsTest26EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "nameConstraintsRFC822CA3CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.27 Valid DN and RFC822 nameConstraints Test27
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNandRFC822nameConstraintsTest27) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "nameConstraintsDN1subCA3Cert",
                               "ValidDNandRFC822nameConstraintsTest27EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA3CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.28 Invalid DN and RFC822 nameConstraints Test28
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNandRFC822nameConstraintsTest28) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "nameConstraintsDN1subCA3Cert",
                               "InvalidDNandRFC822nameConstraintsTest28EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA3CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.29 Invalid DN and RFC822 nameConstraints Test29
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNandRFC822nameConstraintsTest29) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDN1CACert",
                               "nameConstraintsDN1subCA3Cert",
                               "InvalidDNandRFC822nameConstraintsTest29EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDN1CACRL",
                              "nameConstraintsDN1subCA3CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.30 Valid DNS nameConstraints Test30
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNSnameConstraintsTest30) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDNS1CACert",
                               "ValidDNSnameConstraintsTest30EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDNS1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.31 Invalid DNS nameConstraints Test31
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNSnameConstraintsTest31) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDNS1CACert",
                               "InvalidDNSnameConstraintsTest31EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDNS1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.32 Valid DNS nameConstraints Test32
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidDNSnameConstraintsTest32) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDNS2CACert",
                               "ValidDNSnameConstraintsTest32EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDNS2CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.33 Invalid DNS nameConstraints Test33
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNSnameConstraintsTest33) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDNS2CACert",
                               "InvalidDNSnameConstraintsTest33EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDNS2CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.34 Valid URI nameConstraints Test34
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidURInameConstraintsTest34) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsURI1CACert",
                               "ValidURInameConstraintsTest34EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsURI1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.35 Invalid URI nameConstraints Test35
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidURInameConstraintsTest35) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsURI1CACert",
                               "InvalidURInameConstraintsTest35EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsURI1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.36 Valid URI nameConstraints Test36
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13ValidURInameConstraintsTest36) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsURI2CACert",
                               "ValidURInameConstraintsTest36EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsURI2CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.13.37 Invalid URI nameConstraints Test37
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidURInameConstraintsTest37) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsURI2CACert",
                               "InvalidURInameConstraintsTest37EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsURI2CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.13.38 Invalid DNS nameConstraints Test38
WRAPPED_TYPED_TEST_P(PkitsTest13NameConstraints,
                     Section13InvalidDNSnameConstraintsTest38) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "nameConstraintsDNS1CACert",
                               "InvalidDNSnameConstraintsTest38EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "nameConstraintsDNS1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest13NameConstraints,
    Section13ValidDNnameConstraintsTest1,
    Section13InvalidDNnameConstraintsTest2,
    Section13InvalidDNnameConstraintsTest3,
    Section13ValidDNnameConstraintsTest4,
    Section13ValidDNnameConstraintsTest5,
    Section13ValidDNnameConstraintsTest6,
    Section13InvalidDNnameConstraintsTest7,
    Section13InvalidDNnameConstraintsTest8,
    Section13InvalidDNnameConstraintsTest9,
    Section13InvalidDNnameConstraintsTest10,
    Section13ValidDNnameConstraintsTest11,
    Section13InvalidDNnameConstraintsTest12,
    Section13InvalidDNnameConstraintsTest13,
    Section13ValidDNnameConstraintsTest14,
    Section13InvalidDNnameConstraintsTest15,
    Section13InvalidDNnameConstraintsTest16,
    Section13InvalidDNnameConstraintsTest17,
    Section13ValidDNnameConstraintsTest18,
    Section13ValidSelfIssuedDNnameConstraintsTest19,
    Section13InvalidSelfIssuedDNnameConstraintsTest20,
    Section13ValidRFC822nameConstraintsTest21,
    Section13InvalidRFC822nameConstraintsTest22,
    Section13ValidRFC822nameConstraintsTest23,
    Section13InvalidRFC822nameConstraintsTest24,
    Section13ValidRFC822nameConstraintsTest25,
    Section13InvalidRFC822nameConstraintsTest26,
    Section13ValidDNandRFC822nameConstraintsTest27,
    Section13InvalidDNandRFC822nameConstraintsTest28,
    Section13InvalidDNandRFC822nameConstraintsTest29,
    Section13ValidDNSnameConstraintsTest30,
    Section13InvalidDNSnameConstraintsTest31,
    Section13ValidDNSnameConstraintsTest32,
    Section13InvalidDNSnameConstraintsTest33,
    Section13ValidURInameConstraintsTest34,
    Section13InvalidURInameConstraintsTest35,
    Section13ValidURInameConstraintsTest36,
    Section13InvalidURInameConstraintsTest37,
    Section13InvalidDNSnameConstraintsTest38);

template <typename PkitsTestDelegate>
class PkitsTest14DistributionPoints : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest14DistributionPoints);

// 4.14.1 Valid distributionPoint Test1
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValiddistributionPointTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint1CACert",
                               "ValiddistributionPointTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.2 Invalid distributionPoint Test2
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvaliddistributionPointTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint1CACert",
                               "InvaliddistributionPointTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.3 Invalid distributionPoint Test3
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvaliddistributionPointTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint1CACert",
                               "InvaliddistributionPointTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint1CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.4 Valid distributionPoint Test4
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValiddistributionPointTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint1CACert",
                               "ValiddistributionPointTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint1CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.5 Valid distributionPoint Test5
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValiddistributionPointTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint2CACert",
                               "ValiddistributionPointTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint2CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.6 Invalid distributionPoint Test6
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvaliddistributionPointTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint2CACert",
                               "InvaliddistributionPointTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint2CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.7 Valid distributionPoint Test7
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValiddistributionPointTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint2CACert",
                               "ValiddistributionPointTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint2CACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.8 Invalid distributionPoint Test8
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvaliddistributionPointTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint2CACert",
                               "InvaliddistributionPointTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint2CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.9 Invalid distributionPoint Test9
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvaliddistributionPointTest9) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "distributionPoint2CACert",
                               "InvaliddistributionPointTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "distributionPoint2CACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.10 Valid No issuingDistributionPoint Test10
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidNoissuingDistributionPointTest10) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "NoissuingDistributionPointCACert",
                               "ValidNoissuingDistributionPointTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "NoissuingDistributionPointCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.11 Invalid onlyContainsUserCerts CRL Test11
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlyContainsUserCertsCRLTest11) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlyContainsUserCertsCACert",
                               "InvalidonlyContainsUserCertsTest11EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlyContainsUserCertsCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.12 Invalid onlyContainsCACerts CRL Test12
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlyContainsCACertsCRLTest12) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlyContainsCACertsCACert",
                               "InvalidonlyContainsCACertsTest12EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "onlyContainsCACertsCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.13 Valid onlyContainsCACerts CRL Test13
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidonlyContainsCACertsCRLTest13) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlyContainsCACertsCACert",
                               "ValidonlyContainsCACertsTest13EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "onlyContainsCACertsCACRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.14 Invalid onlyContainsAttributeCerts Test14
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlyContainsAttributeCertsTest14) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlyContainsAttributeCertsCACert",
                               "InvalidonlyContainsAttributeCertsTest14EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlyContainsAttributeCertsCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.15 Invalid onlySomeReasons Test15
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlySomeReasonsTest15) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA1Cert",
                               "InvalidonlySomeReasonsTest15EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA1compromiseCRL",
                              "onlySomeReasonsCA1otherreasonsCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.16 Invalid onlySomeReasons Test16
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlySomeReasonsTest16) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA1Cert",
                               "InvalidonlySomeReasonsTest16EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA1compromiseCRL",
                              "onlySomeReasonsCA1otherreasonsCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.17 Invalid onlySomeReasons Test17
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlySomeReasonsTest17) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA2Cert",
                               "InvalidonlySomeReasonsTest17EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "onlySomeReasonsCA2CRL1",
                              "onlySomeReasonsCA2CRL2"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.18 Valid onlySomeReasons Test18
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidonlySomeReasonsTest18) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA3Cert",
                               "ValidonlySomeReasonsTest18EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA3compromiseCRL",
                              "onlySomeReasonsCA3otherreasonsCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.19 Valid onlySomeReasons Test19
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidonlySomeReasonsTest19) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA4Cert",
                               "ValidonlySomeReasonsTest19EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA4compromiseCRL",
                              "onlySomeReasonsCA4otherreasonsCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.20 Invalid onlySomeReasons Test20
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlySomeReasonsTest20) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA4Cert",
                               "InvalidonlySomeReasonsTest20EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA4compromiseCRL",
                              "onlySomeReasonsCA4otherreasonsCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.21 Invalid onlySomeReasons Test21
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidonlySomeReasonsTest21) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "onlySomeReasonsCA4Cert",
                               "InvalidonlySomeReasonsTest21EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "onlySomeReasonsCA4compromiseCRL",
                              "onlySomeReasonsCA4otherreasonsCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.22 Valid IDP with indirectCRL Test22
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidIDPwithindirectCRLTest22) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA1Cert",
                               "ValidIDPwithindirectCRLTest22EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA1CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.23 Invalid IDP with indirectCRL Test23
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidIDPwithindirectCRLTest23) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA1Cert",
                               "InvalidIDPwithindirectCRLTest23EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.24 Valid IDP with indirectCRL Test24
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidIDPwithindirectCRLTest24) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA2Cert", "indirectCRLCA1Cert",
                               "ValidIDPwithindirectCRLTest24EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA1CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.25 Valid IDP with indirectCRL Test25
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidIDPwithindirectCRLTest25) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA2Cert", "indirectCRLCA1Cert",
                               "ValidIDPwithindirectCRLTest25EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA1CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.26 Invalid IDP with indirectCRL Test26
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidIDPwithindirectCRLTest26) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA2Cert", "indirectCRLCA1Cert",
                               "InvalidIDPwithindirectCRLTest26EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA1CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.27 Invalid cRLIssuer Test27
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidcRLIssuerTest27) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA2Cert", "GoodCACert",
                               "InvalidcRLIssuerTest27EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "GoodCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.28 Valid cRLIssuer Test28
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidcRLIssuerTest28) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "indirectCRLCA3Cert",
      "indirectCRLCA3cRLIssuerCert", "ValidcRLIssuerTest28EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA3CRL",
                              "indirectCRLCA3cRLIssuerCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.29 Valid cRLIssuer Test29
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidcRLIssuerTest29) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "indirectCRLCA3Cert",
      "indirectCRLCA3cRLIssuerCert", "ValidcRLIssuerTest29EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA3CRL",
                              "indirectCRLCA3cRLIssuerCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.30 Valid cRLIssuer Test30
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidcRLIssuerTest30) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate", "indirectCRLCA4Cert",
      "indirectCRLCA4cRLIssuerCert", "ValidcRLIssuerTest30EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "indirectCRLCA4cRLIssuerCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.31 Invalid cRLIssuer Test31
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidcRLIssuerTest31) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA5Cert", "indirectCRLCA6Cert",
                               "InvalidcRLIssuerTest31EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA5CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.32 Invalid cRLIssuer Test32
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidcRLIssuerTest32) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA5Cert", "indirectCRLCA6Cert",
                               "InvalidcRLIssuerTest32EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA5CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.33 Valid cRLIssuer Test33
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14ValidcRLIssuerTest33) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA5Cert", "indirectCRLCA6Cert",
                               "ValidcRLIssuerTest33EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA5CRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.14.34 Invalid cRLIssuer Test34
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidcRLIssuerTest34) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA5Cert",
                               "InvalidcRLIssuerTest34EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA5CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.14.35 Invalid cRLIssuer Test35
WRAPPED_TYPED_TEST_P(PkitsTest14DistributionPoints,
                     Section14InvalidcRLIssuerTest35) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "indirectCRLCA5Cert",
                               "InvalidcRLIssuerTest35EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "indirectCRLCA5CRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest14DistributionPoints,
    Section14ValiddistributionPointTest1,
    Section14InvaliddistributionPointTest2,
    Section14InvaliddistributionPointTest3,
    Section14ValiddistributionPointTest4,
    Section14ValiddistributionPointTest5,
    Section14InvaliddistributionPointTest6,
    Section14ValiddistributionPointTest7,
    Section14InvaliddistributionPointTest8,
    Section14InvaliddistributionPointTest9,
    Section14ValidNoissuingDistributionPointTest10,
    Section14InvalidonlyContainsUserCertsCRLTest11,
    Section14InvalidonlyContainsCACertsCRLTest12,
    Section14ValidonlyContainsCACertsCRLTest13,
    Section14InvalidonlyContainsAttributeCertsTest14,
    Section14InvalidonlySomeReasonsTest15,
    Section14InvalidonlySomeReasonsTest16,
    Section14InvalidonlySomeReasonsTest17,
    Section14ValidonlySomeReasonsTest18,
    Section14ValidonlySomeReasonsTest19,
    Section14InvalidonlySomeReasonsTest20,
    Section14InvalidonlySomeReasonsTest21,
    Section14ValidIDPwithindirectCRLTest22,
    Section14InvalidIDPwithindirectCRLTest23,
    Section14ValidIDPwithindirectCRLTest24,
    Section14ValidIDPwithindirectCRLTest25,
    Section14InvalidIDPwithindirectCRLTest26,
    Section14InvalidcRLIssuerTest27,
    Section14ValidcRLIssuerTest28,
    Section14ValidcRLIssuerTest29,
    Section14ValidcRLIssuerTest30,
    Section14InvalidcRLIssuerTest31,
    Section14InvalidcRLIssuerTest32,
    Section14ValidcRLIssuerTest33,
    Section14InvalidcRLIssuerTest34,
    Section14InvalidcRLIssuerTest35);

template <typename PkitsTestDelegate>
class PkitsTest15DeltaCRLs : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest15DeltaCRLs);

// 4.15.1 Invalid deltaCRLIndicator No Base Test1
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs,
                     Section15InvaliddeltaCRLIndicatorNoBaseTest1) {
  const char* const certs[] = {"TrustAnchorRootCertificate",
                               "deltaCRLIndicatorNoBaseCACert",
                               "InvaliddeltaCRLIndicatorNoBaseTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL",
                              "deltaCRLIndicatorNoBaseCACRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.15.2 Valid delta-CRL Test2
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15ValiddeltaCRLTest2) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "ValiddeltaCRLTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.15.3 Invalid delta-CRL Test3
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15InvaliddeltaCRLTest3) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "InvaliddeltaCRLTest3EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.15.4 Invalid delta-CRL Test4
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15InvaliddeltaCRLTest4) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "InvaliddeltaCRLTest4EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.15.5 Valid delta-CRL Test5
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15ValiddeltaCRLTest5) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "ValiddeltaCRLTest5EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.15.6 Invalid delta-CRL Test6
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15InvaliddeltaCRLTest6) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "InvaliddeltaCRLTest6EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.15.7 Valid delta-CRL Test7
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15ValiddeltaCRLTest7) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA1Cert",
                               "ValiddeltaCRLTest7EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA1CRL",
                              "deltaCRLCA1deltaCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.15.8 Valid delta-CRL Test8
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15ValiddeltaCRLTest8) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA2Cert",
                               "ValiddeltaCRLTest8EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA2CRL",
                              "deltaCRLCA2deltaCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.15.9 Invalid delta-CRL Test9
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15InvaliddeltaCRLTest9) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA2Cert",
                               "InvaliddeltaCRLTest9EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA2CRL",
                              "deltaCRLCA2deltaCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

// 4.15.10 Invalid delta-CRL Test10
WRAPPED_TYPED_TEST_P(PkitsTest15DeltaCRLs, Section15InvaliddeltaCRLTest10) {
  const char* const certs[] = {"TrustAnchorRootCertificate", "deltaCRLCA3Cert",
                               "InvaliddeltaCRLTest10EE"};
  const char* const crls[] = {"TrustAnchorRootCRL", "deltaCRLCA3CRL",
                              "deltaCRLCA3deltaCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(PkitsTest15DeltaCRLs,
                                   Section15InvaliddeltaCRLIndicatorNoBaseTest1,
                                   Section15ValiddeltaCRLTest2,
                                   Section15InvaliddeltaCRLTest3,
                                   Section15InvaliddeltaCRLTest4,
                                   Section15ValiddeltaCRLTest5,
                                   Section15InvaliddeltaCRLTest6,
                                   Section15ValiddeltaCRLTest7,
                                   Section15ValiddeltaCRLTest8,
                                   Section15InvaliddeltaCRLTest9,
                                   Section15InvaliddeltaCRLTest10);

template <typename PkitsTestDelegate>
class PkitsTest16PrivateCertificateExtensions
    : public PkitsTest<PkitsTestDelegate> {};
TYPED_TEST_CASE_P(PkitsTest16PrivateCertificateExtensions);

// 4.16.1 Valid Unknown Not Critical Certificate Extension Test1
WRAPPED_TYPED_TEST_P(
    PkitsTest16PrivateCertificateExtensions,
    Section16ValidUnknownNotCriticalCertificateExtensionTest1) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "ValidUnknownNotCriticalCertificateExtensionTest1EE"};
  const char* const crls[] = {"TrustAnchorRootCRL"};
  ASSERT_TRUE(this->Verify(certs, crls));
}

// 4.16.2 Invalid Unknown Critical Certificate Extension Test2
WRAPPED_TYPED_TEST_P(PkitsTest16PrivateCertificateExtensions,
                     Section16InvalidUnknownCriticalCertificateExtensionTest2) {
  const char* const certs[] = {
      "TrustAnchorRootCertificate",
      "InvalidUnknownCriticalCertificateExtensionTest2EE"};
  const char* const crls[] = {"TrustAnchorRootCRL"};
  ASSERT_FALSE(this->Verify(certs, crls));
}

WRAPPED_REGISTER_TYPED_TEST_CASE_P(
    PkitsTest16PrivateCertificateExtensions,
    Section16ValidUnknownNotCriticalCertificateExtensionTest1,
    Section16InvalidUnknownCriticalCertificateExtensionTest2);
