/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.filters.IntFilter;

class IntRangeFilter
implements IntFilter {
    private static final int HASH_MULT = 29;
    private final Integer lowerBound;
    private final Integer upperBound;

    public IntRangeFilter(int lowerBound, int upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public boolean accept(int intValue) {
        return this.lowerBound.compareTo(intValue) <= 0 && this.upperBound.compareTo(intValue) >= 0;
    }

    public int hashCode() {
        return 29 * this.lowerBound + this.upperBound;
    }

    public boolean equals(Object object) {
        if (object instanceof IntRangeFilter) {
            IntRangeFilter other = (IntRangeFilter)object;
            return this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
        }
        return false;
    }

    public String toString() {
        return "IntRangeFilter[" + this.lowerBound + "," + this.upperBound + "]";
    }
}

