/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.regexp;

import com.puppycrawl.tools.checkstyle.checks.regexp.DetectorOptions;
import java.util.List;
import java.util.regex.Matcher;

class SinglelineDetector {
    private final DetectorOptions options;
    private int currentMatches;

    public SinglelineDetector(DetectorOptions options) {
        this.options = options;
    }

    public void processLines(List<String> lines) {
        this.resetState();
        int lineno = 0;
        for (String line : lines) {
            this.checkLine(++lineno, line, this.options.getPattern().matcher(line), 0);
        }
        this.finish();
    }

    private void finish() {
        if (this.currentMatches < this.options.getMinimum()) {
            if ("".equals(this.options.getMessage())) {
                this.options.getReporter().log(0, "regexp.minimum", this.options.getMinimum(), this.options.getFormat());
            } else {
                this.options.getReporter().log(0, this.options.getMessage(), new Object[0]);
            }
        }
    }

    private void resetState() {
        this.currentMatches = 0;
    }

    private void checkLine(int lineno, String line, Matcher matcher, int startPosition) {
        boolean foundMatch = matcher.find(startPosition);
        if (!foundMatch) {
            return;
        }
        int startCol = matcher.start(0);
        int endCol = matcher.end(0);
        if (this.options.getSuppressor().shouldSuppress(lineno, startCol, lineno, endCol - 1)) {
            if (endCol < line.length()) {
                this.checkLine(lineno, line, matcher, endCol);
            }
            return;
        }
        ++this.currentMatches;
        if (this.currentMatches > this.options.getMaximum()) {
            if ("".equals(this.options.getMessage())) {
                this.options.getReporter().log(lineno, "regexp.exceeded", matcher.pattern().toString());
            } else {
                this.options.getReporter().log(lineno, this.options.getMessage(), new Object[0]);
            }
        }
    }
}

