/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.base.Ascii;
import com.squareup.haha.guava.collect.AbstractMultiset;
import com.squareup.haha.guava.collect.Count;
import com.squareup.haha.guava.collect.Maps;
import com.squareup.haha.guava.collect.Multiset;
import com.squareup.haha.guava.primitives.Ints;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class AbstractMapBasedMultiset<E>
extends AbstractMultiset<E>
implements Serializable {
    private transient long size;

    @Override
    public final Set<Multiset.Entry<E>> entrySet() {
        return super.entrySet();
    }

    @Override
    final Iterator<Multiset.Entry<E>> entryIterator() {
        Iterator backingEntries = ((Map)null).entrySet().iterator();
        return new Iterator<Multiset.Entry<E>>(backingEntries){
            private Map.Entry<E, Count> toRemove;
            private /* synthetic */ Iterator val$backingEntries;
            {
                this.val$backingEntries = iterator;
            }

            @Override
            public final boolean hasNext() {
                return this.val$backingEntries.hasNext();
            }

            @Override
            public final void remove() {
                Ascii.checkRemove(this.toRemove != null);
                AbstractMapBasedMultiset.this.size -= this.toRemove.getValue().getAndSet(0);
                this.val$backingEntries.remove();
                this.toRemove = null;
            }
        };
    }

    @Override
    public void clear() {
        for (Count frequency : ((Map)null).values()) {
            boolean bl = false;
            Count count = frequency;
            frequency.value = 0;
        }
        ((Map)null).clear();
        this.size = 0L;
    }

    @Override
    final int distinctElements() {
        return ((Map)null).size();
    }

    @Override
    public int size() {
        return Ints.saturatedCast(this.size);
    }

    @Override
    public Iterator<E> iterator() {
        return new MapBasedMultisetIterator(this);
    }

    @Override
    public final int count(@Nullable Object element) {
        Count frequency = (Count)Maps.safeGet(null, element);
        if (frequency == null) {
            return 0;
        }
        Count count = frequency;
        return count.value;
    }

    @Override
    public final int add(@Nullable E element, int occurrences) {
        int oldCount;
        if (occurrences == 0) {
            return this.count(element);
        }
        Ascii.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)((Map)null).get(element);
        if (frequency == null) {
            oldCount = 0;
            ((Map)null).put(element, new Count(occurrences));
        } else {
            Count count = frequency;
            oldCount = count.value;
            long newCount = (long)oldCount + (long)occurrences;
            Ascii.checkArgument(newCount <= Integer.MAX_VALUE, "too many occurrences: %s", newCount);
            int n = occurrences;
            Count count2 = frequency;
            int n2 = count2.value;
            count2.value = n2 + n;
        }
        this.size += (long)occurrences;
        return oldCount;
    }

    @Override
    public final int remove(@Nullable Object element, int occurrences) {
        int numberRemoved;
        if (occurrences == 0) {
            return this.count(element);
        }
        Ascii.checkArgument(occurrences > 0, "occurrences cannot be negative: %s", occurrences);
        Count frequency = (Count)((Map)null).get(element);
        if (frequency == null) {
            return 0;
        }
        Count count = frequency;
        int oldCount = count.value;
        if (oldCount > occurrences) {
            numberRemoved = occurrences;
        } else {
            numberRemoved = oldCount;
            ((Map)null).remove(element);
        }
        frequency.addAndGet(-numberRemoved);
        this.size -= (long)numberRemoved;
        return oldCount;
    }

    @Override
    public final int setCount(@Nullable E element, int count) {
        int oldCount;
        Ascii.checkNonnegative(count, "count");
        if (count == 0) {
            Count existingCounter = (Count)((Map)null).remove(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
        } else {
            Count existingCounter = (Count)((Map)null).get(element);
            oldCount = AbstractMapBasedMultiset.getAndSet(existingCounter, count);
            if (existingCounter == null) {
                ((Map)null).put(element, new Count(count));
            }
        }
        this.size += (long)(count - oldCount);
        return oldCount;
    }

    private static int getAndSet(Count i, int count) {
        if (i == null) {
            return 0;
        }
        return i.getAndSet(count);
    }

    static /* synthetic */ Map access$000(AbstractMapBasedMultiset x0) {
        return null;
    }

    final class MapBasedMultisetIterator
    implements Iterator<E> {
        private Iterator<Map.Entry<E, Count>> entryIterator;
        private Map.Entry<E, Count> currentEntry;
        private int occurrencesLeft;
        private boolean canRemove;
        private /* synthetic */ AbstractMapBasedMultiset this$0;

        MapBasedMultisetIterator(AbstractMapBasedMultiset abstractMapBasedMultiset) {
            this.this$0 = abstractMapBasedMultiset;
            this.entryIterator = AbstractMapBasedMultiset.access$000(abstractMapBasedMultiset).entrySet().iterator();
        }

        @Override
        public final boolean hasNext() {
            return this.occurrencesLeft > 0 || this.entryIterator.hasNext();
        }

        @Override
        public final E next() {
            if (this.occurrencesLeft == 0) {
                this.currentEntry = this.entryIterator.next();
                Count count = this.currentEntry.getValue();
                this.occurrencesLeft = count.value;
            }
            --this.occurrencesLeft;
            this.canRemove = true;
            return this.currentEntry.getKey();
        }

        @Override
        public final void remove() {
            Ascii.checkRemove(this.canRemove);
            Count count = this.currentEntry.getValue();
            int frequency = count.value;
            if (frequency <= 0) {
                throw new ConcurrentModificationException();
            }
            if (this.currentEntry.getValue().addAndGet(-1) == 0) {
                this.entryIterator.remove();
            }
            this.this$0.size--;
            this.canRemove = false;
        }
    }
}

