/*
 * Decompiled with CFR 0.152.
 */
package com.google.vr.dynamite.client;

import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.google.android.aidl.BaseProxy;
import com.google.android.aidl.BaseStub;

public interface INativeLibraryLoader
extends IInterface {
    public long initializeAndLoadNativeLibrary(String var1) throws RemoteException;

    public int checkVersion(String var1) throws RemoteException;

    public static abstract class Stub
    extends BaseStub
    implements INativeLibraryLoader {
        private static final String DESCRIPTOR = "com.google.vr.dynamite.client.INativeLibraryLoader";
        static final int TRANSACTION_initializeAndLoadNativeLibrary = 1;
        static final int TRANSACTION_checkVersion = 2;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INativeLibraryLoader asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin instanceof INativeLibraryLoader) {
                return (INativeLibraryLoader)iin;
            }
            return new Proxy(obj);
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            if (this.routeToSuperOrEnforceInterface(code, data, reply, flags)) {
                return true;
            }
            switch (code) {
                case 1: {
                    String libraryName = data.readString();
                    long retval = this.initializeAndLoadNativeLibrary(libraryName);
                    reply.writeNoException();
                    reply.writeLong(retval);
                    break;
                }
                case 2: {
                    String clientVersion = data.readString();
                    int retval = this.checkVersion(clientVersion);
                    reply.writeNoException();
                    reply.writeInt(retval);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public static class Proxy
        extends BaseProxy
        implements INativeLibraryLoader {
            Proxy(IBinder remote) {
                super(remote, Stub.DESCRIPTOR);
            }

            @Override
            public long initializeAndLoadNativeLibrary(String libraryName) throws RemoteException {
                Parcel data = this.obtainAndWriteInterfaceToken();
                data.writeString(libraryName);
                Parcel reply = this.transactAndReadException(1, data);
                long retval = reply.readLong();
                reply.recycle();
                return retval;
            }

            @Override
            public int checkVersion(String clientVersion) throws RemoteException {
                Parcel data = this.obtainAndWriteInterfaceToken();
                data.writeString(clientVersion);
                Parcel reply = this.transactAndReadException(2, data);
                int retval = reply.readInt();
                reply.recycle();
                return retval;
            }
        }
    }
}

