# Histogram one-pager

For best practices on writing histogram descriptions, see
[README.md](./README.md)
For details on how to modify histograms.xml to add your description, keep reading.

In [histograms.xml](./histograms.xml)
file you will find two sections:

* The histograms section describes base histograms, giving their name,
  their units or enum type, expiration, a short one-line summary, and a more
  detailed description.
* The histogram_suffixes section provides a compact way of defining histograms
  by applying affixes to existing histograms. This can be done recursively
  to a max recursion depth of 5. See the example below for details on how it
  works.

Enum labels of histograms are defined and described in [enums.xml](./enums.xml).

## Histogram expiration

Histogram expiration can be specified as a date in YYYY-MM-DD format or as a
Chrome milestone. For example:
  `<histogram name="HistogramName" expires_after="2018-01-01">`
or
  `<histogram name="HistogramName" expires_after="M68">`

After a histogram expires, it will not be recorded (nor uploaded to the UMA
servers). The code to record it becomes dead code, and should be removed from
the codebase; and the histogram definition should be marked as obsolete. However,
if the histogram would remain useful, the expiration should be extended
accordingly. We recommend to always specify an expiry for new histograms.

## Histogram suffixes

Each histogram_suffixes tag lists the histograms that it affects. The complete
list of histograms is computed by appending (or prepending - see below) the
suffix names to each of the affected histograms. For example, if we define the following:

  ```
  <histogram name="FileLoadLatency"/>

  <histogram_suffixes name="SuperHttpExperiment" separator=".">
    <suffix name="SuperHttpEnabled"/>
    <suffix name="SuperHttpDisabled"/>
    <affected-histogram name="FileLoadLatency"/>
  </histogram_suffixes>
  ```

The complete list of histograms will be:

  ```
  FileLoadLatency
  FileLoadLatency.SuperHttpEnabled
  FileLoadLatency.SuperHttpDisabled
  ```

histogram_suffixes can also be used to insert affix in the middle. Example:

  ```
  <histogram name="Prerender.Events"/>

  <histogram_suffixes name="HoverStatsTypes" separator="_" ordering="prefix">
    <suffix name="HoverStats50"/>
    <affected-histogram name="Prerender.Events"/>
  </histogram_suffixes>
  ```

The complete list of histograms will be:

  ```
  Prerender.Events
  Prerender.HoverStats50_Events
  ```

When 'ordering="prefix"' is present in the histogram_suffixes tag, the suffix
will be inserted after the first dot separator of the affected-histogram name.
Optionally, ordering can be specified as "prefix,N" where N indicates after
how many dots the suffix should be inserted (default=1). The affected-histogram
name has to have at least N dots in it.

If a `<histogram>` or a `<suffix>` element is only provided so that its name can be
extended by `<histogram_suffixes>`, the element should be annotated with the
attribute `base="true"`. This instructs tools not to treat the base name as a
distinct histogram.

If two histogram_suffixes affect the same histogram, generated lists will be
combined as if only one suffix is defined. Histogram suffix may affect histogram
generated by another suffix (maximum depth of this recursion is 5). Example:

```
<histogram name="MyHist">

<histogram_suffixes name="Suffix1">
  <suffix name="A"/>
  <suffix name="B"/>
  <affected-histogram name="MyHist"/>
</histogram_suffixes>

<histogram_suffixes name="Suffix2">
  <suffix name="C"/>
  <suffix name="D"/>
  <affected-histogram name="MyHist"/>
  <affected-histogram name="MyHist.A"/>
</histogram_suffixes>
```

The complete list of histograms will be:

  ```
  MyHist.A
  MyHist.B
  MyHist.C
  MyHist.D
  MyHist.A.C
  MyHist.A.D
  ```

## Private histograms

Googlers: There are also a small number of private internal histograms found at
http://cs/file:chrome/histograms.xml - but prefer this file for new entries.