/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * This file was autogenerated from GrCircleBlurFragmentProcessor.fp; do not modify.
 */
#ifndef GrCircleBlurFragmentProcessor_DEFINED
#define GrCircleBlurFragmentProcessor_DEFINED
#include "SkTypes.h"
#if SK_SUPPORT_GPU
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
#include "GrColorSpaceXform.h"
#include "effects/GrProxyMove.h"
class GrCircleBlurFragmentProcessor : public GrFragmentProcessor {
public:
    SkRect circleRect() const { return fCircleRect; }
    float textureRadius() const { return fTextureRadius; }
    float solidRadius() const { return fSolidRadius; }

    static sk_sp<GrFragmentProcessor> Make(GrResourceProvider* resourceProvider,
                                           const SkRect& circle, float sigma);
    const char* name() const override { return "CircleBlurFragmentProcessor"; }

private:
    GrCircleBlurFragmentProcessor(SkRect circleRect, float textureRadius, float solidRadius,
                                  sk_sp<GrTextureProxy> blurProfileSampler,
                                  GrResourceProvider* resourceProvider)
            : INHERITED((OptimizationFlags)kCompatibleWithCoverageAsAlpha_OptimizationFlag)
            , fCircleRect(circleRect)
            , fTextureRadius(textureRadius)
            , fSolidRadius(solidRadius)
            , fBlurProfileSampler(std::move(blurProfileSampler)) {
        this->addTextureSampler(&fBlurProfileSampler);
        this->initClassID<GrCircleBlurFragmentProcessor>();
    }
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    SkRect fCircleRect;
    float fTextureRadius;
    float fSolidRadius;
    TextureSampler fBlurProfileSampler;
    typedef GrFragmentProcessor INHERITED;
};
#endif
#endif
