/*
 * Copyright (C) 2009 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef WebClipboard_h
#define WebClipboard_h

#include "public/platform/WebBlobInfo.h"
#include "public/platform/WebCommon.h"
#include "public/platform/WebImage.h"
#include "public/platform/WebString.h"
#include "public/platform/WebURL.h"
#include "public/platform/WebVector.h"

namespace blink {

class WebDragData;
class WebImage;
class WebURL;

class WebClipboard {
 public:
  enum Format {
    kFormatPlainText,
    kFormatHTML,
    kFormatBookmark,
    kFormatSmartPaste
  };

  enum Buffer {
    kBufferStandard,
    // Used on platforms like the X Window System that treat selection
    // as a type of clipboard.
    kBufferSelection,
  };

  // Returns an identifier which can be used to determine whether the data
  // contained within the clipboard has changed.
  virtual uint64_t SequenceNumber(Buffer) { return 0; }

  virtual bool IsFormatAvailable(Format, Buffer) { return false; }

  virtual WebVector<WebString> ReadAvailableTypes(Buffer,
                                                  bool* contains_filenames) {
    return WebVector<WebString>();
  }
  virtual WebString ReadPlainText(Buffer) { return WebString(); }
  // fragmentStart and fragmentEnd are indexes into the returned markup that
  // indicate the start and end of the fragment if the returned markup
  // contains additional context. If there is no additional context,
  // fragmentStart will be zero and fragmentEnd will be the same as the length
  // of the returned markup.
  virtual WebString ReadHTML(Buffer buffer,
                             WebURL* page_url,
                             unsigned* fragment_start,
                             unsigned* fragment_end) {
    return WebString();
  }
  virtual WebString ReadRTF(Buffer) { return WebString(); }
  virtual WebBlobInfo ReadImage(Buffer) { return WebBlobInfo(); }
  virtual WebString ReadCustomData(Buffer, const WebString& type) {
    return WebString();
  }

  virtual void WritePlainText(const WebString&) {}
  virtual void WriteHTML(const WebString& html_text,
                         const WebURL&,
                         const WebString& plain_text,
                         bool write_smart_paste) {}
  virtual void WriteImage(const WebImage&,
                          const WebURL&,
                          const WebString& title) {}
  virtual void WriteDataObject(const WebDragData&) {}

 protected:
  ~WebClipboard() {}
};

}  // namespace blink

#endif
