/*
 * Copyright (C) 2014 Google Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *     * Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following disclaimer
 * in the documentation and/or other materials provided with the
 * distribution.
 *     * Neither the name of Google Inc. nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef SVGTransformList_h
#define SVGTransformList_h

#include "core/svg/SVGParsingError.h"
#include "core/svg/SVGTransform.h"
#include "core/svg/properties/SVGListPropertyHelper.h"

namespace blink {

class SVGTransformListTearOff;

class SVGTransformList final
    : public SVGListPropertyHelper<SVGTransformList, SVGTransform> {
 public:
  typedef SVGTransformListTearOff TearOffType;

  static SVGTransformList* Create() { return new SVGTransformList(); }

  static SVGTransformList* Create(SVGTransformType, const String&);

  ~SVGTransformList() override;

  SVGTransform* Consolidate();

  bool Concatenate(AffineTransform& result) const;

  // SVGPropertyBase:
  SVGPropertyBase* CloneForAnimation(const String&) const override;
  String ValueAsString() const override;
  SVGParsingError SetValueAsString(const String&);
  bool Parse(const UChar*& ptr, const UChar* end);
  bool Parse(const LChar*& ptr, const LChar* end);

  void Add(SVGPropertyBase*, SVGElement*) override;
  void CalculateAnimatedValue(SVGAnimationElement*,
                              float percentage,
                              unsigned repeat_count,
                              SVGPropertyBase* from_value,
                              SVGPropertyBase* to_value,
                              SVGPropertyBase* to_at_end_of_duration_value,
                              SVGElement*) override;
  float CalculateDistance(SVGPropertyBase* to, SVGElement*) override;

  static AnimatedPropertyType ClassType() { return kAnimatedTransformList; }
  AnimatedPropertyType GetType() const override { return ClassType(); }

  const CSSValue* CssValue() const;

 private:
  SVGTransformList();

  template <typename CharType>
  SVGParsingError ParseInternal(const CharType*& ptr, const CharType* end);
};

DEFINE_SVG_PROPERTY_TYPE_CASTS(SVGTransformList);

SVGTransformType ParseTransformType(const String&);

}  // namespace blink

#endif  // SVGTransformList_h
