/*
 * Copyright 2017 Google Inc.
 *
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * This file was autogenerated from GrBlurredEdgeFragmentProcessor.fp; do not modify.
 */
#ifndef GrBlurredEdgeFragmentProcessor_DEFINED
#define GrBlurredEdgeFragmentProcessor_DEFINED
#include "SkTypes.h"
#if SK_SUPPORT_GPU
#include "GrFragmentProcessor.h"
#include "GrCoordTransform.h"
#include "GrColorSpaceXform.h"
#include "effects/GrProxyMove.h"
class GrBlurredEdgeFragmentProcessor : public GrFragmentProcessor {
public:
    enum Mode { kGaussian_Mode = 0, kSmoothStep_Mode = 1 };
    int mode() const { return fMode; }
    static sk_sp<GrFragmentProcessor> Make(int mode) {
        return sk_sp<GrFragmentProcessor>(new GrBlurredEdgeFragmentProcessor(mode));
    }
    const char* name() const override { return "BlurredEdgeFragmentProcessor"; }

private:
    GrBlurredEdgeFragmentProcessor(int mode) : INHERITED(kNone_OptimizationFlags), fMode(mode) {
        this->initClassID<GrBlurredEdgeFragmentProcessor>();
    }
    GrGLSLFragmentProcessor* onCreateGLSLInstance() const override;
    void onGetGLSLProcessorKey(const GrShaderCaps&, GrProcessorKeyBuilder*) const override;
    bool onIsEqual(const GrFragmentProcessor&) const override;
    GR_DECLARE_FRAGMENT_PROCESSOR_TEST
    int fMode;
    typedef GrFragmentProcessor INHERITED;
};
#endif
#endif
