About SampleApp
==========================
The SampleApp displays a series of slides that exhibit specific features of the Skia system. It is mainly controlled using the keyboard: left (&#x2190;) and (&#x2192;) right arrows to move from slide to slide. Some slides require use resources stored outside the program. These resources are stored in the `<skia-path>/resources` directory.

`<skia-path>/out/Release/SampleApp --resourcePath <skia-path>/resources`


In addition to displaying various aspects of Skia, SampleApp is used to debug and understand different parts of the Skia system.

* Observe rendering performance - pressing the 'f' key places the SampleApp in frame rate mode. It continuously draws the slide while desplaying the draw time in the title of the window.
* Try different rendering methods - pressing the 'd' key cycles among the three rendering methods raster, picture and opengl. You can use this with the 'f' key to see the effect that the different rendering methods have on drawing performance.
* Look at different angles - pressing the 'r' slowley rotates the slide.
* Display and manipulate your own pictures - use the `--picture <skp-file-path>.skp` to use the `.skp` file as the slide desplayed by SampleApp. A `.skp` file can be generated by...

Key                              | Action
-----------------------------|-------------
&#x2190; &#x2192; | Move between the slides
r                                    | Rotate the current slide
&#x2191; &#x2193; | Zoom in / out
d                                   | Change render methods among raster, picture and opengl
f                                     | Display the rendering time in the menu bar
G                                    | Show bounding box

