/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.ripe.rpki.validator3.util.ForkJoin;
import net.ripe.rpki.validator3.util.HttpStreaming;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class HttpStreaming {
    private static final Logger log = LoggerFactory.getLogger(HttpStreaming.class);

    public static <T> T readStream(Supplier<Request> requestF, Function<InputStream, T> reader) {
        BiFunction<InputStream, Long, Object> ignoreLastModified = (stream, ignoredLastModified) -> reader.apply((InputStream)stream);
        return (T)HttpStreaming.readStream(requestF, ignoreLastModified);
    }

    public static <T> T readStream(Supplier<Request> requestF, BiFunction<InputStream, Long, T> reader) {
        return (T)ForkJoin.blocking(() -> HttpStreaming.doReadStream((Supplier)requestF, (BiFunction)reader));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T doReadStream(Supplier<Request> requestF, BiFunction<InputStream, Long, T> reader) {
        InputStreamResponseListener listener = new InputStreamResponseListener();
        Request request = requestF.get();
        request.timeout(1L, TimeUnit.HOURS);
        request.idleTimeout(1L, TimeUnit.MINUTES);
        request.send((Response.CompleteListener)listener);
        Response response = null;
        try {
            response = listener.get(2L, TimeUnit.MINUTES);
            if (response.getStatus() != 200) {
                if (response.getStatus() == 304) {
                    NotModifiedException error = new NotModifiedException(request.getURI().toString());
                    response.abort((Throwable)error);
                    throw error;
                }
                HttpStatusException error = new HttpStatusException(response, request);
                response.abort((Throwable)error);
                throw error;
            }
            long lastModified = response.getHeaders().getDateField("Last-Modified");
            try (InputStream inputStream = listener.getInputStream();){
                InputStream inputStream2 = reader.apply(inputStream, lastModified);
                return (T)inputStream2;
            }
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            HttpFailureException error = new HttpFailureException("failed reading response stream for " + request.getURI() + ": " + e, (Throwable)e);
            if (response == null) throw error;
            response.abort((Throwable)error);
            throw error;
        }
        catch (ExecutionException e) {
            HttpFailureException error = new HttpFailureException("failed reading response stream for " + request.getURI() + ": " + e.getCause(), e.getCause());
            if (response == null) throw error;
            response.abort((Throwable)error);
            throw error;
        }
    }
}

