/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain;

import java.util.function.Predicate;
import java.util.stream.Stream;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceSet;
import net.ripe.ipresource.UniqueIpResource;
import net.ripe.ipresource.etree.IntervalMap;
import net.ripe.ipresource.etree.IntervalStrategy;
import net.ripe.ipresource.etree.IpResourceIntervalStrategy;
import net.ripe.ipresource.etree.NestedIntervalMap;
import net.ripe.rpki.validator3.api.ignorefilters.IgnoreFilter;
import net.ripe.rpki.validator3.domain.RoaPrefixDefinition;

public class IgnoreFiltersPredicate
implements Predicate<RoaPrefixDefinition> {
    private IpResourceSet ignoredAsns = new IpResourceSet();
    private IntervalMap<IpRange, IpResourceSet> ignoredPrefixes = new NestedIntervalMap((IntervalStrategy)IpResourceIntervalStrategy.getInstance());

    public IgnoreFiltersPredicate(Stream<IgnoreFilter> ignoreFilterStream) {
        ignoreFilterStream.forEach(filter -> {
            IpRange prefix = filter.getPrefix();
            if (prefix == null) {
                this.ignoredAsns.add((IpResource)new Asn(filter.getAsn().longValue()));
            } else {
                IpResourceSet existing = (IpResourceSet)this.ignoredPrefixes.findExact((Object)prefix);
                if (existing == null) {
                    existing = new IpResourceSet();
                    this.ignoredPrefixes.put((Object)prefix, (Object)existing);
                }
                if (filter.getAsn() == null) {
                    existing.add((IpResource)new Asn(0L).upTo((UniqueIpResource)new Asn(0xFFFFFFFFL)));
                } else {
                    existing.add((IpResource)new Asn(filter.getAsn().longValue()));
                }
            }
        });
    }

    @Override
    public boolean test(RoaPrefixDefinition roaPrefix) {
        if (this.ignoredAsns.contains((IpResource)new Asn(roaPrefix.getAsn()))) {
            return true;
        }
        IpResourceSet filter = (IpResourceSet)this.ignoredPrefixes.findExactOrFirstLessSpecific((Object)roaPrefix.getPrefix());
        return filter != null && filter.contains((IpResource)new Asn(roaPrefix.getAsn()));
    }
}

