/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgpsec;

import java.util.stream.Stream;
import javax.validation.Valid;
import net.ripe.ipresource.Asn;
import net.ripe.rpki.validator3.api.bgpsec.AddBgpSecAssertion;
import net.ripe.rpki.validator3.api.bgpsec.BgpSecAssertion;
import net.ripe.rpki.validator3.api.slurm.SlurmStore;
import net.ripe.rpki.validator3.api.slurm.dtos.Slurm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.annotation.Validated;

@Component
@Validated
public class BgpSecAssertionsService {
    private static final Logger log = LoggerFactory.getLogger(BgpSecAssertionsService.class);
    private final SlurmStore slurmStore;

    @Autowired
    public BgpSecAssertionsService(SlurmStore slurmStore) {
        this.slurmStore = slurmStore;
    }

    public long execute(@Valid AddBgpSecAssertion command) {
        long id = this.slurmStore.nextId();
        return (Long)this.slurmStore.updateWith(slurmExt -> {
            Slurm.SlurmBgpSecAssertion slurmBgpSecAssertion = new Slurm.SlurmBgpSecAssertion();
            slurmBgpSecAssertion.setAsn(Long.valueOf(Asn.parse((String)command.getAsn()).longValue()));
            slurmBgpSecAssertion.setPublicKey(command.getPublicKey());
            slurmBgpSecAssertion.setSki(command.getSki());
            slurmBgpSecAssertion.setComment(command.getComment());
            slurmExt.getBgpsecAssertions().put(id, slurmBgpSecAssertion);
            return id;
        });
    }

    public void remove(long id) {
        this.slurmStore.updateWith(slurmExt -> slurmExt.getPrefixAssertions().remove(id));
    }

    public Stream<BgpSecAssertion> all() {
        return this.slurmStore.read().getBgpsecAssertions().entrySet().stream().map(e -> {
            Slurm.SlurmBgpSecAssertion v = (Slurm.SlurmBgpSecAssertion)e.getValue();
            return new BgpSecAssertion((Long)e.getKey(), v.getAsn(), v.getComment(), v.getSki(), v.getPublicKey());
        });
    }

    public void clear() {
        this.slurmStore.updateWith(slurmExt -> slurmExt.getBgpsecAssertions().clear());
    }
}

