/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api;

import java.util.function.Predicate;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceType;
import net.ripe.rpki.validator3.domain.ValidatedRoaPrefix;

public class SearchTerm
implements Predicate<ValidatedRoaPrefix> {
    private final String term;
    private final IpRange range;
    private final Long asn;
    private final Predicate<ValidatedRoaPrefix> actualPredicate;
    private static final int IPv4_PREFIX_LENGTH = 32;
    private static final int IPv6_PREFIX_LENGTH = 128;

    public SearchTerm(String term) {
        this.term = term == null ? "" : term.trim();
        this.range = this.convertPrefix(term);
        this.asn = this.convertAsn(term);
        this.actualPredicate = this.createPredicate();
    }

    private Predicate<ValidatedRoaPrefix> createPredicate() {
        if (this.asn != null) {
            return prefix -> this.asn.longValue() == prefix.getAsn();
        }
        if (this.range != null) {
            return prefix -> this.range.overlaps((IpResource)prefix.getPrefix());
        }
        return prefix -> prefix.getTrustAnchor().getName().contains(this.term) || prefix.getLocations().stream().anyMatch(uri -> uri.contains(this.term));
    }

    public Long asAsn() {
        return this.asn;
    }

    public IpRange asIpRange() {
        return this.range;
    }

    public String asString() {
        return this.term;
    }

    @Override
    public boolean test(ValidatedRoaPrefix prefix) {
        return this.actualPredicate.test(prefix);
    }

    private Long convertAsn(String value) {
        try {
            return Asn.parse((String)value).longValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    private IpRange convertPrefix(String value) {
        try {
            return IpRange.parse((String)value);
        }
        catch (Exception e) {
            try {
                IpAddress ipAddress = IpAddress.parse((String)value);
                if (IpResourceType.IPv4.equals((Object)ipAddress.getType())) {
                    return IpRange.prefix((IpAddress)ipAddress, (int)32);
                }
                return IpRange.prefix((IpAddress)ipAddress, (int)128);
            }
            catch (Exception ignored) {
                return null;
            }
        }
    }
}

