/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.rtr.domain;

import java.util.Arrays;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;
import net.ripe.rpki.rtr.domain.RtrPrefix;
import net.ripe.rpki.rtr.domain.pdus.Flags;
import net.ripe.rpki.rtr.domain.pdus.Pdu;
import net.ripe.rpki.rtr.domain.pdus.ProtocolVersion;

public interface RtrDataUnit
extends Comparable<RtrDataUnit> {
    public Pdu toPdu(ProtocolVersion var1, Flags var2);

    public static RtrPrefix prefix(Asn asn, IpRange ipRange, Integer maxLength) {
        byte[] prefix;
        if (ipRange.getStart() instanceof Ipv4Address) {
            long address = ((Ipv4Address)ipRange.getStart()).longValue();
            byte[] prefix2 = new byte[]{(byte)(address >> 24 & 0xFFL), (byte)(address >> 16 & 0xFFL), (byte)(address >> 8 & 0xFFL), (byte)(address >> 0 & 0xFFL)};
            return RtrPrefix.of((byte)((byte)ipRange.getPrefixLength()), (byte)((byte)(maxLength != null ? maxLength.intValue() : ipRange.getPrefixLength())), (byte[])prefix2, (int)((int)asn.longValue()));
        }
        Ipv6Address address = (Ipv6Address)ipRange.getStart();
        byte[] bytes = address.getValue().toByteArray();
        if (bytes.length > 16) {
            prefix = Arrays.copyOfRange(bytes, bytes.length - 16, bytes.length);
        } else if (bytes.length < 16) {
            prefix = new byte[16];
            for (int i = 0; i < bytes.length; ++i) {
                prefix[i + 16 - bytes.length] = bytes[i];
            }
        } else {
            prefix = bytes;
        }
        return RtrPrefix.of((byte)((byte)ipRange.getPrefixLength()), (byte)((byte)(maxLength != null ? maxLength.intValue() : ipRange.getPrefixLength())), (byte[])prefix, (int)((int)asn.longValue()));
    }

    @Override
    default public int compareTo(RtrDataUnit o) {
        if (!this.getClass().equals(o.getClass())) {
            return this.getClass().getName().compareTo(o.getClass().getName());
        }
        return this.compareToSameType(o);
    }

    public int compareToSameType(RtrDataUnit var1);
}

