/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Base;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.BaseCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class RpkiObjectCoder
implements Coder<RpkiObject> {
    private static final short TYPE_TAG = Tags.unique((int)31);
    private static final short SHA256_TAG = Tags.unique((int)32);
    private static final short AKI_TAG = Tags.unique((int)33);
    private static final short LAST_MARKED_TAG = Tags.unique((int)34);
    private static final short SERIAL_TAG = Tags.unique((int)35);
    private static final short ENCODED_TAG = Tags.unique((int)36);
    private static final short SIGNING_TIME_TAG = Tags.unique((int)37);
    private static final short LOCATIONS_TAG = Tags.unique((int)38);
    private static final short ROA_PREFIXES = Tags.unique((int)39);

    public byte[] toBytes(RpkiObject rpkiObject) {
        Encoded encoded = new Encoded();
        BaseCoder.toBytesNoId((Base)rpkiObject, (Encoded)encoded);
        encoded.append(TYPE_TAG, Coders.toBytes((String)rpkiObject.getType().name()));
        encoded.append(SHA256_TAG, rpkiObject.getSha256());
        encoded.append(AKI_TAG, rpkiObject.getAuthorityKeyIdentifier());
        encoded.appendNotNull(SERIAL_TAG, (Object)rpkiObject.getSerialNumber(), Coders::toBytes);
        encoded.appendNotNull(ENCODED_TAG, rpkiObject.getEncoded());
        encoded.appendNotNull(SIGNING_TIME_TAG, (Object)rpkiObject.getSigningTime(), Coders::toBytes);
        return encoded.toByteArray();
    }

    public RpkiObject fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        RpkiObject rpkiObject = new RpkiObject();
        BaseCoder.fromBytesNoId((Map)content, (Base)rpkiObject);
        rpkiObject.setType(RpkiObject.Type.valueOf((String)Coders.toString((byte[])((byte[])content.get(TYPE_TAG)))));
        rpkiObject.setSha256((byte[])content.get(SHA256_TAG));
        rpkiObject.setEncoded((byte[])content.get(ENCODED_TAG));
        rpkiObject.setAuthorityKeyIdentifier((byte[])content.get(AKI_TAG));
        Encoded.field((Map)content, (short)SIGNING_TIME_TAG).ifPresent(b -> rpkiObject.setSigningTime(Coders.toInstant((byte[])b)));
        Encoded.field((Map)content, (short)SERIAL_TAG).ifPresent(b -> rpkiObject.setSerialNumber(Coders.toBigInteger((byte[])b)));
        return rpkiObject;
    }
}

