/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom.validation;

import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.RefCoder;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;
import net.ripe.rpki.validator3.storage.encoding.custom.validation.ValidationRunCoder;

public class CTValidationRunCoder
implements Coder<CertificateTreeValidationRun> {
    private static final short TA_TAG = Tags.unique((int)81);
    private static final short EARLIEST_OBJECT_EXPIRATION_TAG = Tags.unique((int)82);
    private static final RefCoder<TrustAnchor> taRefCoder = new RefCoder();

    public byte[] toBytes(CertificateTreeValidationRun validationRun) {
        Encoded encoded = new Encoded();
        ValidationRunCoder.toBytes((ValidationRun)validationRun, (Encoded)encoded);
        encoded.appendNotNull(TA_TAG, (Object)validationRun.getTrustAnchor(), arg_0 -> ((RefCoder)taRefCoder).toBytes(arg_0));
        encoded.appendNotNull(EARLIEST_OBJECT_EXPIRATION_TAG, (Object)validationRun.getEarliestObjectExpiration(), Coders::toBytes);
        return encoded.toByteArray();
    }

    public CertificateTreeValidationRun fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        Ref trustAnchorRef = taRefCoder.fromBytes((byte[])content.get(TA_TAG));
        CertificateTreeValidationRun validationRun = new CertificateTreeValidationRun(trustAnchorRef);
        Encoded.field((Map)content, (short)EARLIEST_OBJECT_EXPIRATION_TAG).ifPresent(b -> validationRun.setEarliestObjectExpiration(Coders.toInstant((byte[])b)));
        ValidationRunCoder.fromBytes((Map)content, (ValidationRun)validationRun);
        return validationRun;
    }
}

