/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.validation;

import java.net.URI;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.ripe.rpki.commons.crypto.CertificateRepositoryObject;
import net.ripe.rpki.commons.crypto.cms.manifest.ManifestCms;
import net.ripe.rpki.commons.crypto.crl.X509Crl;
import net.ripe.rpki.commons.crypto.x509cert.X509ResourceCertificate;
import net.ripe.rpki.commons.util.RepositoryObjectType;
import net.ripe.rpki.commons.validation.ValidationLocation;
import net.ripe.rpki.commons.validation.ValidationResult;
import net.ripe.rpki.commons.validation.ValidationStatus;
import net.ripe.rpki.commons.validation.objectvalidators.CertificateRepositoryObjectValidationContext;
import net.ripe.rpki.validator3.api.util.InstantWithoutNanos;
import net.ripe.rpki.validator3.background.ValidationScheduler;
import net.ripe.rpki.validator3.config.ValidationConfig;
import net.ripe.rpki.validator3.domain.RpkiObjectUtils;
import net.ripe.rpki.validator3.domain.metrics.TrustAnchorMetricsService;
import net.ripe.rpki.validator3.domain.validation.CertificateTreeValidationService;
import net.ripe.rpki.validator3.domain.validation.ValidatedRpkiObjects;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.Tx;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.data.RpkiObject;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.data.TrustAnchor;
import net.ripe.rpki.validator3.storage.data.validation.CertificateTreeValidationRun;
import net.ripe.rpki.validator3.storage.data.validation.ValidationRun;
import net.ripe.rpki.validator3.storage.stores.RpkiObjects;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import net.ripe.rpki.validator3.storage.stores.Settings;
import net.ripe.rpki.validator3.storage.stores.TrustAnchors;
import net.ripe.rpki.validator3.storage.stores.ValidationRuns;
import net.ripe.rpki.validator3.util.Bench;
import net.ripe.rpki.validator3.util.Sha256;
import net.ripe.rpki.validator3.util.Time;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class CertificateTreeValidationService {
    private static final Logger log = LoggerFactory.getLogger(CertificateTreeValidationService.class);
    public static final int MAX_NEXT_UPDATE_DIFFERENCE_MS = 60000;
    public final long LONG_DURATION_WARNING_MS = 60000L;
    private final ValidationConfig validationConfig;
    private final TrustAnchorMetricsService taMetricsService;
    private final RpkiObjects rpkiObjects;
    private final RpkiRepositories rpkiRepositories;
    private final Settings settings;
    private final ValidationScheduler validationScheduler;
    private final ValidationRuns validationRuns;
    private final TrustAnchors trustAnchors;
    private final Storage storage;
    private final ValidatedRpkiObjects validatedRpkiObjects;

    @Autowired
    public CertificateTreeValidationService(RpkiObjects rpkiObjects, RpkiRepositories rpkiRepositories, Settings settings, ValidationScheduler validationScheduler, ValidationRuns validationRuns, TrustAnchors trustAnchors, ValidatedRpkiObjects validatedRpkiObjects, Storage storage, TrustAnchorMetricsService taMetricsService, ValidationConfig validationConfig) {
        this.rpkiObjects = rpkiObjects;
        this.rpkiRepositories = rpkiRepositories;
        this.settings = settings;
        this.validationScheduler = validationScheduler;
        this.validationRuns = validationRuns;
        this.trustAnchors = trustAnchors;
        this.validatedRpkiObjects = validatedRpkiObjects;
        this.storage = storage;
        this.taMetricsService = taMetricsService;
        this.validationConfig = validationConfig;
    }

    private void logForDuration(String message, Object o1, long delta) {
        if (delta > 60000L) {
            log.warn(String.format("SLOW: %s", message), o1, (Object)delta);
        } else {
            log.info(message, o1, (Object)delta);
        }
    }

    private void logForDuration(String message, Object o1, Object o2, long delta) {
        if (delta > 60000L) {
            log.warn(String.format("SLOW: %s", message), new Object[]{o1, o2, delta});
        } else {
            log.info(message, new Object[]{o1, o2, delta});
        }
    }

    public void validate(long trustAnchorId) {
        Optional maybeTrustAnchor = (Optional)this.storage.readTx(tx -> this.trustAnchors.get(tx, Key.of((long)trustAnchorId)));
        if (maybeTrustAnchor.isPresent()) {
            TrustAnchor trustAnchor = (TrustAnchor)maybeTrustAnchor.get();
            Bench.mark0((String)("validateTa " + trustAnchor.getName()), () -> this.validateTa(trustAnchor));
        } else {
            log.error("Couldn't find trust anchor {}", (Object)trustAnchorId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTa(TrustAnchor trustAnchor) {
        log.info("Starting tree validation for {}", (Object)trustAnchor.getName());
        long begin = System.currentTimeMillis();
        ConcurrentHashMap registeredRepositories = new ConcurrentHashMap();
        Ref trustAnchorRef = (Ref)this.storage.readTx(tx -> this.trustAnchors.makeRef(tx, trustAnchor.key()));
        CertificateTreeValidationRun validationRun = new CertificateTreeValidationRun(trustAnchorRef);
        String trustAnchorLocation = (String)trustAnchor.getLocations().get(0);
        ValidationResult validations = ValidationResult.withLocation((String)trustAnchorLocation).withoutStoringPassingChecks();
        try {
            X509ResourceCertificate trustAnchorCertificate = trustAnchor.getCertificate();
            validations.rejectIfNull((Object)trustAnchorCertificate, "validator.trust.anchor.certificate.available");
            if (trustAnchorCertificate == null) {
                return;
            }
            CertificateRepositoryObjectValidationContext context = new CertificateRepositoryObjectValidationContext(URI.create(trustAnchorLocation), trustAnchorCertificate);
            trustAnchorCertificate.validate(trustAnchorLocation, context, null, null, this.validationConfig.validationOptions(), validations);
            if (validations.hasFailureForCurrentLocation()) {
                return;
            }
            URI locationUri = Optional.ofNullable(trustAnchorCertificate.getRrdpNotifyUri()).orElse(trustAnchorCertificate.getRepositoryUri());
            validations.warnIfNull((Object)locationUri, "validator.trust.anchor.certificate.rrdp.notify.uri.or.repository.uri.present");
            if (locationUri == null) {
                return;
            }
            ValidatedRpkiObjects.TrustAnchorData trustAnchorData = ValidatedRpkiObjects.TrustAnchorData.of((Key)trustAnchor.getId(), (String)trustAnchor.getName());
            CertificateAuthorityValidationResult certificateAuthorityValidationResult = this.validateCertificateAuthority(trustAnchorData, registeredRepositories, context);
            validations.addAll(certificateAuthorityValidationResult.getAllValidationResults());
            ValidatedRpkiObjects.Accumulator accumulator = certificateAuthorityValidationResult.getAllValidatedObjects();
            if (accumulator.isEmpty() && this.isValidationRunCompleted(validations)) {
                log.info("No associated objects, validation run: {}, validation result: {}", (Object)validationRun.key(), (Object)validations);
            }
            if (accumulator.getEarliestObjectExpiration() != null) {
                log.info("TA {} earliest object expiration time {}", (Object)trustAnchor.getName(), (Object)accumulator.getEarliestObjectExpiration());
                validationRun.setEarliestObjectExpiration(InstantWithoutNanos.from((Instant)accumulator.getEarliestObjectExpiration()));
            } else {
                log.warn("TA {} does not contain any valid, non-expired objects", (Object)trustAnchor.getName());
            }
            this.storage.writeTx0(tx -> {
                this.validationRuns.add(tx, (ValidationRun)validationRun);
                Long t = Time.timed(() -> accumulator.forEach(key -> this.validationRuns.associateRpkiObjectKey(tx, validationRun, key)));
                this.logForDuration("Associated {} objects with the validation run {} in {}ms", (Object)accumulator.size(), (Object)validationRun.key(), t.longValue());
                this.markTaObjectsReachable(tx, trustAnchorCertificate);
                Long tmr = Time.timed(() -> this.rpkiObjects.markReachable(tx, accumulator.getKeys()));
                this.logForDuration("Marked {} objects as reachable in {}ms", (Object)accumulator.size(), tmr.longValue());
                if (this.isValidationRunCompleted(validations)) {
                    trustAnchor.markInitialCertificateTreeValidationRunCompleted();
                    this.trustAnchors.update(tx, trustAnchor);
                    if (!this.settings.isInitialValidationRunCompleted((Tx.Read)tx) && this.trustAnchors.allInitialCertificateTreeValidationRunsCompleted((Tx.Read)tx)) {
                        this.settings.markInitialValidationRunCompleted(tx);
                        log.info("All trust anchors have completed their initial certificate tree validation run, validator is now ready");
                    }
                }
            });
            if (!accumulator.isEmpty()) {
                this.validatedRpkiObjects.updateByKey(trustAnchorRef, accumulator);
            }
        }
        finally {
            validationRun.completeWith(validations);
            this.storage.writeTx0(tx -> this.validationRuns.update(tx, (ValidationRun)validationRun));
            long delta = System.currentTimeMillis() - begin;
            this.logForDuration("Tree validation {} for {} in {}ms", (Object)validationRun.getStatus().toString().toLowerCase(), (Object)trustAnchor.getName(), delta);
            this.taMetricsService.update(trustAnchor, validationRun, delta);
        }
    }

    private void markTaObjectsReachable(Tx.Write tx, X509ResourceCertificate taCertificate) {
        InstantWithoutNanos now = InstantWithoutNanos.now();
        this.rpkiObjects.findLatestMftByAKI((Tx.Read)tx, taCertificate.getSubjectKeyIdentifier()).ifPresent(manifest -> {
            this.rpkiObjects.markReachable(tx, manifest.key(), now);
            manifest.get(ManifestCms.class, RpkiObjectUtils.newValidationResult((String)"ta-manifest.mft")).ifPresent(manifestCms -> this.rpkiObjects.findObjectsInManifest((Tx.Read)tx, manifestCms).forEach((entry, rpkiObject) -> this.rpkiObjects.markReachable(tx, rpkiObject.key(), now)));
        });
    }

    private boolean isValidationRunCompleted(ValidationResult validationResult) {
        return validationResult.getWarnings().stream().noneMatch(check -> check.getStatus() != ValidationStatus.PASSED && "validator.rpki.repository.pending".equals(check.getKey()));
    }

    private CertificateAuthorityValidationResult validateCertificateAuthority(ValidatedRpkiObjects.TrustAnchorData trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context) {
        ValidationResult validations = RpkiObjectUtils.newValidationResult((URI)context.getLocation());
        CertificateAuthorityValidationResult result = CertificateAuthorityValidationResult.of((ValidationResult)validations);
        try {
            RpkiRepository rpkiRepository = (RpkiRepository)Bench.mark((String)trustAnchor.getName(), (String)"registerRepository", () -> (RpkiRepository)this.storage.writeTx(tx -> this.registerRepository(tx, trustAnchor, registeredRepositories, context)));
            validations.warnIfTrue(rpkiRepository.isPending(), "validator.rpki.repository.pending", new String[]{rpkiRepository.getLocationUri()});
            if (rpkiRepository.isPending()) {
                return result;
            }
            X509ResourceCertificate certificate = context.getCertificate();
            URI manifestUri = certificate.getManifestUri();
            validations.setLocation(new ValidationLocation(manifestUri));
            Optional manifestObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"findLatestMftByAKI", () -> (Optional)this.storage.readTx(tx -> this.rpkiObjects.findLatestMftByAKI(tx, certificate.getSubjectKeyIdentifier())));
            if (!manifestObject.isPresent()) {
                if (rpkiRepository.getStatus() == RpkiRepository.Status.FAILED) {
                    validations.error("validator.no.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
                } else {
                    validations.error("validator.no.local.manifest.no.manifest.in.repository", new String[]{manifestUri.toString(), rpkiRepository.getLocationUri()});
                }
            }
            Optional maybeManifest = manifestObject.flatMap(x -> x.get(ManifestCms.class, validations));
            validations.rejectIfTrue(manifestObject.isPresent() && rpkiRepository.getStatus() == RpkiRepository.Status.FAILED && maybeManifest.isPresent() && ((ManifestCms)maybeManifest.get()).isPastValidityTime(), "validator.old.local.manifest.repository.failed", new String[]{rpkiRepository.getLocationUri()});
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            ManifestCms manifest = (ManifestCms)maybeManifest.get();
            List crlEntries = manifest.getFiles().entrySet().stream().filter(entry -> RepositoryObjectType.parse((String)((String)entry.getKey())) == RepositoryObjectType.Crl).collect(Collectors.toList());
            validations.rejectIfFalse(crlEntries.size() == 1, "validator.manifest.contains.one.crl.entry", new String[]{String.valueOf(crlEntries.size())});
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            Map.Entry crlEntry = (Map.Entry)crlEntries.get(0);
            URI crlUri = manifestUri.resolve((String)crlEntry.getKey());
            Optional crlObject = (Optional)this.storage.readTx(tx -> this.rpkiObjects.findBySha256(tx, (byte[])crlEntry.getValue()));
            validations.rejectIfFalse(crlObject.isPresent(), "validator.crl.found", new String[]{crlUri.toASCIIString()});
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            validations.setLocation(new ValidationLocation(crlUri));
            Optional crl = crlObject.flatMap(x -> x.get(X509Crl.class, validations));
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            X509Crl x509Crl = (X509Crl)crl.get();
            x509Crl.validate(crlUri.toASCIIString(), context, null, this.validationConfig.validationOptions(), validations);
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            long nextUpdateTimeDifferenceMs = manifest.getNextUpdateTime().getMillis() - x509Crl.getNextUpdateTime().getMillis();
            validations.warnIfFalse(Math.abs(nextUpdateTimeDifferenceMs) < 60000L, "manifest.crl.next.update.time.matches", new String[]{manifest.getNextUpdateTime().toString(), x509Crl.getNextUpdateTime().toString()});
            validations.setLocation(new ValidationLocation(manifestUri));
            manifest.validate(manifestUri.toASCIIString(), context, x509Crl, manifest.getCrlUri(), this.validationConfig.validationOptions(), validations);
            if (validations.hasFailureForCurrentLocation()) {
                return result;
            }
            result.add(trustAnchor, ((RpkiObject)manifestObject.get()).key(), (CertificateRepositoryObject)manifest, manifestUri);
            CertificateAuthorityValidationResult validatedManifestEntries = this.validateManifestEntries(trustAnchor, registeredRepositories, context, manifestUri, manifest, crlUri, x509Crl);
            result.addAll(validatedManifestEntries);
        }
        catch (Exception e) {
            validations.error("unhandled.exception", new String[]{e.toString(), ExceptionUtils.getStackTrace((Throwable)e)});
        }
        return result;
    }

    private CertificateAuthorityValidationResult validateManifestEntries(ValidatedRpkiObjects.TrustAnchorData trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context, URI manifestUri, ManifestCms manifest, URI crlUri, X509Crl x509Crl) {
        CertificateAuthorityValidationResult result = manifest.getFiles().entrySet().parallelStream().map(entry -> this.validateManifestEntry(trustAnchor, registeredRepositories, context, manifestUri, crlUri, x509Crl, entry)).collect(CertificateAuthorityValidationResult::empty, CertificateAuthorityValidationResult::addAll, CertificateAuthorityValidationResult::addAll);
        if (!this.validationConfig.isStrictValidation()) {
            return result;
        }
        result.getValidationResult().setLocation(new ValidationLocation(manifestUri));
        boolean hasManifestEntryFailures = result.getValidationResult().hasFailureForCurrentLocation();
        result.getValidationResult().warnIfTrue(hasManifestEntryFailures, "manifest.all.entries.valid");
        if (hasManifestEntryFailures) {
            return CertificateAuthorityValidationResult.of((ValidationResult)result.getValidationResult());
        }
        return result;
    }

    private CertificateAuthorityValidationResult validateManifestEntry(ValidatedRpkiObjects.TrustAnchorData trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context, URI manifestUri, URI crlUri, X509Crl crl, Map.Entry<String, byte[]> entry) {
        X509ResourceCertificate resourceCertificate;
        ValidationResult validations = RpkiObjectUtils.newValidationResult((URI)manifestUri);
        CertificateAuthorityValidationResult result = CertificateAuthorityValidationResult.of((ValidationResult)validations);
        String entryFilename = entry.getKey();
        byte[] entryHash = entry.getValue();
        URI entryLocation = manifestUri.resolve(entryFilename);
        Optional object = (Optional)this.storage.readTx(tx -> this.rpkiObjects.findBySha256(tx, entryHash));
        validations.rejectIfFalse(object.isPresent(), "validator.manifest.entry.found", new String[]{entryFilename});
        if (validations.hasFailureForCurrentLocation()) {
            return result;
        }
        RpkiObject rpkiObject = (RpkiObject)object.get();
        boolean hashMatches = Arrays.equals(Sha256.hash((byte[])rpkiObject.getEncoded()), entryHash);
        validations.rejectIfFalse(hashMatches, "validator.manifest.entry.hash.matches", new String[]{entryFilename});
        if (validations.hasFailureForCurrentLocation()) {
            return result;
        }
        SortedSet locations = (SortedSet)this.storage.readTx(tx -> this.rpkiObjects.getLocations(tx, rpkiObject.key()));
        validations.rejectIfFalse(locations.contains(entryLocation.toASCIIString()), "validator.repository.object.not.at.expected.location", new String[]{entryLocation.toASCIIString(), String.join((CharSequence)", ", locations)});
        if (validations.hasFailureForCurrentLocation()) {
            return result;
        }
        validations.warnIfTrue(locations.size() > 1, "validator.repository.object.at.expected.location.and.elsewhere", new String[]{String.join((CharSequence)", ", locations)});
        validations.setLocation(new ValidationLocation(entryLocation));
        Optional maybeCertificateRepositoryObject = (Optional)Bench.mark((String)trustAnchor.getName(), (String)"rpkiObject.get", () -> rpkiObject.get(CertificateRepositoryObject.class, validations));
        if (validations.hasFailureForCurrentLocation()) {
            return result;
        }
        CertificateRepositoryObject certificateRepositoryObject = (CertificateRepositoryObject)maybeCertificateRepositoryObject.get();
        Bench.mark0((String)trustAnchor.getName(), (String)"certificateRepositoryObject.validate", () -> certificateRepositoryObject.validate(entryLocation.toASCIIString(), context, crl, crlUri, this.validationConfig.validationOptions(), validations));
        if (validations.hasFailureForCurrentLocation()) {
            return result;
        }
        result.add(trustAnchor, Key.of((byte[])entryHash), certificateRepositoryObject, entryLocation);
        if (certificateRepositoryObject instanceof X509ResourceCertificate && (resourceCertificate = (X509ResourceCertificate)certificateRepositoryObject).isCa()) {
            CertificateRepositoryObjectValidationContext childContext = context.createChildContext(entryLocation, resourceCertificate);
            result.addChild(this.validateCertificateAuthority(trustAnchor, registeredRepositories, childContext));
        }
        return result;
    }

    private RpkiRepository registerRepository(Tx.Write tx, ValidatedRpkiObjects.TrustAnchorData trustAnchor, Map<URI, RpkiRepository> registeredRepositories, CertificateRepositoryObjectValidationContext context) {
        if (!this.validationConfig.isRsyncOnly() && context.getRpkiNotifyURI() != null) {
            return registeredRepositories.computeIfAbsent(context.getRpkiNotifyURI(), uri -> {
                Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.getId());
                RpkiRepository r = this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RRDP);
                tx.afterCommit(() -> this.validationScheduler.addRrdpRpkiRepository(r));
                return r;
            });
        }
        return registeredRepositories.computeIfAbsent(context.getRepositoryURI(), uri -> {
            Ref trustAnchorRef = this.trustAnchors.makeRef((Tx.Read)tx, trustAnchor.getId());
            return this.rpkiRepositories.register(tx, trustAnchorRef, uri.toASCIIString(), RpkiRepository.Type.RSYNC);
        });
    }
}

