/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.domain.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import net.ripe.rpki.validator3.domain.metrics.RrdpMetricsService;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RrdpMetricsService {
    private static final Logger log = LoggerFactory.getLogger(RrdpMetricsService.class);
    @Autowired
    private MeterRegistry registry;
    private ConcurrentHashMap<Tuple2<String, String>, RrdpMetric> rrdpMetrics = new ConcurrentHashMap();

    public void update(String uri, String status) {
        if (uri == null) {
            log.info("null url provided to RrdpMetricsService, with status {}", (Object)status);
            return;
        }
        this.update(URI.create(uri), status);
    }

    public void update(URI uri, String status) {
        if (uri == null || status == null) {
            log.info("null url or status provided to RrdpMetricsService, uri: '{}', status: '{}'", (Object)uri, (Object)status);
            return;
        }
        String rootURL = uri.resolve("/").toASCIIString();
        String targetStatus = status.replace("rrdp.", "");
        this.rrdpMetrics.computeIfAbsent(new Tuple2((Object)rootURL, (Object)targetStatus), key -> new RrdpMetric(this.registry, rootURL, targetStatus)).update();
    }
}

