/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForkJoin {
    private static final Logger log = LoggerFactory.getLogger(ForkJoin.class);
    private static final Semaphore maximumManagedBlockers;

    public static <T> T blocking(Supplier<T> supplier) {
        if (!maximumManagedBlockers.tryAcquire()) {
            return supplier.get();
        }
        try {
            AtomicReference result = new AtomicReference();
            ForkJoinPool.managedBlock((ForkJoinPool.ManagedBlocker)new /* Unavailable Anonymous Inner Class!! */);
            Object v = result.get();
            return (T)v;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            maximumManagedBlockers.release();
        }
    }

    static {
        int maximumSpares = Integer.parseInt(System.getProperty("java.util.concurrent.ForkJoinPool.common.maximumSpares", "256"));
        int max = Math.min(2 * ForkJoinPool.getCommonPoolParallelism(), maximumSpares / 4);
        log.info("maximum additional concurrent blocking threads for common fork-join pool is {}", (Object)max);
        maximumManagedBlockers = new Semaphore(max);
    }
}

