/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.xodus;

import java.io.File;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import net.ripe.rpki.validator3.storage.XodusInitialisationException;
import net.ripe.rpki.validator3.storage.xodus.Xodus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Profile(value={"!test"})
@Component
@Primary
public class XodusImpl
extends Xodus {
    private static final Logger log = LoggerFactory.getLogger(XodusImpl.class);
    private final String path;
    private Environment env;

    public XodusImpl(@Value(value="${rpki.validator.data.path}") String path) {
        this.path = path;
    }

    @PostConstruct
    public void initXodus() {
        try {
            String dbPath = this.createDirectoryIfNeeded();
            log.info("Creating Xodus environment at {}", (Object)dbPath);
            EnvironmentConfig config = new EnvironmentConfig().setLogCacheUseSoftReferences(true).setMemoryUsagePercentage(10).setLogCachePageSize(2048).setLogDurableWrite(true).setEnvGatherStatistics(true).setGcEnabled(true).setLogCacheUseNio(true).setEnvCloseForcedly(true);
            this.env = Environments.newInstance((String)dbPath, (EnvironmentConfig)config);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.waitForAllTxToFinishAndClose()));
        }
        catch (Exception e) {
            log.error("Couldn't open Xodus", (Throwable)e);
            throw new XodusInitialisationException(e);
        }
    }

    private String createDirectoryIfNeeded() {
        File mainDir = new File(this.path);
        if (!mainDir.exists() || !mainDir.isDirectory()) {
            throw new XodusInitialisationException("Directory " + this.path + " doesn't exist, please create one");
        }
        File dbDir = new File(this.path, "db");
        if (!dbDir.exists()) {
            log.info("Creating directory {}", (Object)dbDir.getAbsolutePath());
            if (!dbDir.mkdirs()) {
                throw new XodusInitialisationException("Couldn't create " + dbDir.getAbsolutePath());
            }
        }
        return dbDir.getAbsolutePath();
    }

    @PreDestroy
    public synchronized void waitForAllTxToFinishAndClose() {
        this.env.close();
    }

    protected Environment getEnv() {
        return this.env;
    }
}

