/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.storage.encoding.custom;

import java.io.Serializable;
import java.util.Map;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.Ref;
import net.ripe.rpki.validator3.storage.encoding.Coder;
import net.ripe.rpki.validator3.storage.encoding.custom.Coders;
import net.ripe.rpki.validator3.storage.encoding.custom.Encoded;
import net.ripe.rpki.validator3.storage.encoding.custom.Tags;

public class RefCoder<T extends Serializable>
implements Coder<Ref<T>> {
    private static final short TABLE_NAME_TAG = Tags.unique((int)11);
    private static final short KEY_TAG = Tags.unique((int)12);

    public byte[] toBytes(Ref<T> ref) {
        Encoded encoded = new Encoded();
        encoded.append(TABLE_NAME_TAG, Coders.toBytes((String)ref.getMapName()));
        encoded.append(KEY_TAG, ref.key().getBytes());
        return encoded.toByteArray();
    }

    public Ref<T> fromBytes(byte[] bytes) {
        Map content = Encoded.fromByteArray((byte[])bytes).getContent();
        return Ref.unsafe((String)Coders.toString((byte[])((byte[])content.get(TABLE_NAME_TAG))), (Key)Key.of((byte[])((byte[])content.get(KEY_TAG))));
    }
}

