/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.rpkirepositories;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ripe.rpki.validator3.api.ApiResponse;
import net.ripe.rpki.validator3.api.Metadata;
import net.ripe.rpki.validator3.api.Paging;
import net.ripe.rpki.validator3.api.PublicApiCall;
import net.ripe.rpki.validator3.api.SearchTerm;
import net.ripe.rpki.validator3.api.Sorting;
import net.ripe.rpki.validator3.api.rpkirepositories.RepositoriesStatus;
import net.ripe.rpki.validator3.api.rpkirepositories.RpkiRepositoryResource;
import net.ripe.rpki.validator3.storage.Storage;
import net.ripe.rpki.validator3.storage.data.Key;
import net.ripe.rpki.validator3.storage.data.RpkiRepository;
import net.ripe.rpki.validator3.storage.stores.RpkiRepositories;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@PublicApiCall
@RestController
@Api(tags={"RPKI repositories"})
@RequestMapping(path={"/api/rpki-repositories"}, produces={"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8", "application/json"})
public class RpkiRepositoriesController {
    private static final Logger log = LoggerFactory.getLogger(RpkiRepositoriesController.class);
    private final RpkiRepositories rpkiRepositories;
    private final Storage storage;

    @Autowired
    public RpkiRepositoriesController(RpkiRepositories rpkiRepositories, Storage storage) {
        this.rpkiRepositories = rpkiRepositories;
        this.storage = storage;
    }

    @ApiOperation(value="Get repositories (matching parameters)")
    @GetMapping
    public ResponseEntity<ApiResponse<Stream<RpkiRepositoryResource>>> list(@ApiParam(value="Validation status") @RequestParam(name="status", required=false) RpkiRepository.Status status, @ApiParam(value="Trust anchor id") @RequestParam(name="ta", required=false) Long taId, @RequestParam(name="startFrom", defaultValue="0") long startFrom, @RequestParam(name="pageSize", defaultValue="20") long pageSize, @RequestParam(name="search", defaultValue="", required=false) String searchString, @ApiParam(allowableValues="prefix, asn, ta, key, location, status, validity, type, lastchecked, comment, maximumlength") @RequestParam(name="sortBy", defaultValue="location") String sortBy, @ApiParam(allowableValues="asc, desc") @RequestParam(name="sortDirection", defaultValue="asc") String sortDirection, @RequestParam(name="hideChildrenOfDownloadedParent", defaultValue="true") boolean hideChildrenOfDownloadedParent) {
        SearchTerm searchTerm = StringUtils.isNotBlank((CharSequence)searchString) ? new SearchTerm(searchString) : null;
        Sorting sorting = Sorting.parse((String)sortBy, (String)sortDirection);
        Paging paging = Paging.of((Long)startFrom, (Long)pageSize);
        return (ResponseEntity)this.storage.readTx(tx -> {
            Key taKey = taId == null ? null : Key.of((long)taId);
            List repositories = this.rpkiRepositories.findAll(tx, status, taKey, hideChildrenOfDownloadedParent, searchTerm, sorting, paging).collect(Collectors.toList());
            int totalSize = (int)this.rpkiRepositories.countAll(tx, status, taKey, hideChildrenOfDownloadedParent, searchTerm);
            Links links = Paging.links((long)startFrom, (long)pageSize, (long)totalSize, (sf, ps) -> ((RpkiRepositoriesController)ControllerLinkBuilder.methodOn(RpkiRepositoriesController.class, (Object[])new Object[0])).list(status, taId, sf.longValue(), ps.longValue(), searchString, sortBy, sortDirection, hideChildrenOfDownloadedParent));
            Stream<RpkiRepositoryResource> data = repositories.stream().map(RpkiRepositoryResource::of);
            return ResponseEntity.ok((Object)ApiResponse.builder().data(data).links(links).metadata(Metadata.of((long)totalSize)).build());
        });
    }

    @ApiOperation(value="Get repository by id")
    @GetMapping(path={"/{id}"})
    public ResponseEntity<ApiResponse<RpkiRepositoryResource>> get(@PathVariable long id) {
        return ((Optional)this.storage.readTx(tx -> this.rpkiRepositories.get(tx, Key.of((long)id)))).map(r -> ResponseEntity.ok((Object)ApiResponse.data((Object)RpkiRepositoryResource.of((RpkiRepository)r)))).orElse(ResponseEntity.notFound().build());
    }

    @ApiOperation(value="Repository status by trust anchor")
    @GetMapping(path={"/statuses/{taId}"})
    public ApiResponse<RepositoriesStatus> repositories(@PathVariable long taId, @RequestParam(name="hideChildrenOfDownloadedParent", defaultValue="true") boolean hideChildrenOfDownloadedParent) {
        Map counts = (Map)this.storage.readTx(tx -> this.rpkiRepositories.countByStatus(tx, Key.of((long)taId), hideChildrenOfDownloadedParent));
        return ApiResponse.builder().data((Object)RepositoriesStatus.of((int)counts.getOrDefault(RpkiRepository.Status.DOWNLOADED, 0L).intValue(), (int)counts.getOrDefault(RpkiRepository.Status.PENDING, 0L).intValue(), (int)counts.getOrDefault(RpkiRepository.Status.FAILED, 0L).intValue())).build();
    }

    @ApiOperation(value="Delete repository by id")
    @DeleteMapping(path={"/{id}"})
    public ResponseEntity<?> delete(@PathVariable long id) {
        this.storage.writeTx0(tx -> this.rpkiRepositories.remove(tx, Key.of((long)id)));
        return ResponseEntity.noContent().build();
    }
}

