/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api.bgp;

import java.beans.ConstructorProperties;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpRange;

public class BgpRisEntry {
    final Asn origin;
    final IpRange prefix;
    final int visibility;

    @ConstructorProperties(value={"origin", "prefix", "visibility"})
    private BgpRisEntry(Asn origin, IpRange prefix, int visibility) {
        this.origin = origin;
        this.prefix = prefix;
        this.visibility = visibility;
    }

    public static BgpRisEntry of(Asn origin, IpRange prefix, int visibility) {
        return new BgpRisEntry(origin, prefix, visibility);
    }

    public Asn getOrigin() {
        return this.origin;
    }

    public IpRange getPrefix() {
        return this.prefix;
    }

    public int getVisibility() {
        return this.visibility;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BgpRisEntry)) {
            return false;
        }
        BgpRisEntry other = (BgpRisEntry)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getVisibility() != other.getVisibility()) {
            return false;
        }
        Asn this$origin = this.getOrigin();
        Asn other$origin = other.getOrigin();
        if (this$origin == null ? other$origin != null : !this$origin.equals(other$origin)) {
            return false;
        }
        IpRange this$prefix = this.getPrefix();
        IpRange other$prefix = other.getPrefix();
        return !(this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BgpRisEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getVisibility();
        Asn $origin = this.getOrigin();
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        IpRange $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        return result;
    }

    public String toString() {
        return "BgpRisEntry(origin=" + this.getOrigin() + ", prefix=" + this.getPrefix() + ", visibility=" + this.getVisibility() + ")";
    }
}

