/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api;

import java.beans.ConstructorProperties;

public final class Metadata {
    private final long totalCount;
    private final long lastModified;

    public static Metadata of(long totalCount) {
        return new Metadata(totalCount, System.currentTimeMillis());
    }

    @ConstructorProperties(value={"totalCount", "lastModified"})
    private Metadata(long totalCount, long lastModified) {
        this.totalCount = totalCount;
        this.lastModified = lastModified;
    }

    public static Metadata of(long totalCount, long lastModified) {
        return new Metadata(totalCount, lastModified);
    }

    public long getTotalCount() {
        return this.totalCount;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata other = (Metadata)o;
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        return this.getLastModified() == other.getLastModified();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalCount = this.getTotalCount();
        result = result * 59 + (int)($totalCount >>> 32 ^ $totalCount);
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        return result;
    }

    public String toString() {
        return "Metadata(totalCount=" + this.getTotalCount() + ", lastModified=" + this.getLastModified() + ")";
    }
}

