/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.api;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import net.ripe.rpki.validator3.api.ApiError;
import net.ripe.rpki.validator3.api.ApiErrorSource;
import net.ripe.rpki.validator3.api.ApiResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@ControllerAdvice(annotations={RestController.class})
public class ApiErrorHandler
extends ResponseEntityExceptionHandler {
    @Autowired
    private MessageSource messages;

    @ExceptionHandler(value={DataRetrievalFailureException.class})
    protected ResponseEntity<ApiResponse<?>> handleDataRetrievalFailureException(DataRetrievalFailureException ex, WebRequest request) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.valueOf((String)"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8"));
        return new ResponseEntity((Object)ApiResponse.error((ApiError[])new ApiError[]{ApiError.of((HttpStatus)HttpStatus.NOT_FOUND)}), (MultiValueMap)headers, HttpStatus.NOT_FOUND);
    }

    protected ResponseEntity<Object> handleMethodArgumentNotValid(MethodArgumentNotValidException ex, HttpHeaders headers, HttpStatus status, WebRequest request) {
        Locale locale = request.getLocale();
        List errors = ex.getBindingResult().getFieldErrors().stream().map(fieldError -> ApiError.builder().status(String.valueOf(HttpStatus.BAD_REQUEST.value())).code(fieldError.getCode()).title(this.messages.getMessage("title." + fieldError.getCode(), null, HttpStatus.BAD_REQUEST.getReasonPhrase(), locale)).detail(this.messages.getMessage((MessageSourceResolvable)fieldError, locale)).source(ApiErrorSource.of(Optional.of("/" + fieldError.getField().replaceAll("[.\\[]", "/").replace("]", "")), Optional.empty())).build()).collect(Collectors.toList());
        return ResponseEntity.badRequest().contentType(MediaType.valueOf((String)"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8")).body((Object)ApiResponse.error(errors));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    protected ResponseEntity<Object> handleMethodArgumentNotValidException(MethodArgumentTypeMismatchException ex, Locale locale) {
        ApiError error = ApiError.builder().status(String.valueOf(HttpStatus.BAD_REQUEST.value())).code(ex.getErrorCode()).title(this.messages.getMessage("title." + ex.getErrorCode(), null, HttpStatus.BAD_REQUEST.getReasonPhrase(), locale)).detail(this.messages.getMessage("methodArgument." + ex.getErrorCode(), new Object[]{ex.getValue(), this.messages.getMessage("type." + ex.getRequiredType(), null, locale)}, locale)).source(ApiErrorSource.of(Optional.empty(), Optional.of(ex.getName()))).build();
        return ResponseEntity.badRequest().contentType(MediaType.valueOf((String)"application/vnd.net.ripe.rpki.validator.v3+json; charset=UTF-8")).body((Object)ApiResponse.error((ApiError[])new ApiError[]{error}));
    }
}

