/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.rpki.validator3.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public class Rsync {
    private static final int DEFAULT_RSYNC_PORT = 873;

    private Rsync() {
    }

    public static File localFileFromRsyncUri(File localRsyncDirectory, URI rsyncUri) throws IOException {
        URI location = rsyncUri.normalize();
        String host = location.getHost() + "/" + (location.getPort() < 0 ? 873 : location.getPort());
        return new File(new File(localRsyncDirectory, host), location.getRawPath()).getCanonicalFile();
    }

    public static List<URI> generateCandidateParentUris(URI uri) {
        URI candidate = uri.normalize();
        if (!candidate.getPath().endsWith("/")) {
            candidate = URI.create(uri.toASCIIString() + "/");
        }
        ArrayList<URI> result = new ArrayList<URI>();
        while (!"/".equals(candidate.getPath())) {
            candidate = candidate.resolve("..");
            result.add(candidate);
        }
        return result;
    }
}

